/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import net.codestory.rest.Response;
import net.codestory.rest.RestResponse;
import net.codestory.rest.RestResponseShould;
import net.codestory.rest.Should;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Route;

public class RestAssert {
    private final String url;
    private final UnaryOperator<OkHttpClient.Builder> configureClient;
    private final UnaryOperator<Request.Builder> configureRequest;

    RestAssert(String url) {
        this(url, UnaryOperator.identity(), UnaryOperator.identity());
    }

    private RestAssert(String url, UnaryOperator<OkHttpClient.Builder> configureClient, UnaryOperator<Request.Builder> configureRequest) {
        this.url = url;
        this.configureRequest = configureRequest;
        this.configureClient = configureClient;
    }

    RestAssert withRequest(UnaryOperator<Request.Builder> configure) {
        return new RestAssert(this.url, this.configureClient, request -> (Request.Builder)configure.apply((Request.Builder)this.configureRequest.apply((Request.Builder)request)));
    }

    private RestAssert withClient(UnaryOperator<OkHttpClient.Builder> configure) {
        return new RestAssert(this.url, client -> (OkHttpClient.Builder)configure.apply((OkHttpClient.Builder)this.configureClient.apply((OkHttpClient.Builder)client)), this.configureRequest);
    }

    public Response response() {
        try {
            RestResponse call = this.call();
            return new Response(call.contentType(), call.bodyAsString(), call.code());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query: " + this.url, e);
        }
    }

    public RestAssert withHeader(String name, String value) {
        return this.withRequest(RestAssert.addHeader(name, value));
    }

    public RestAssert withPreemptiveAuthentication(String login, String password) {
        return this.withRequest(RestAssert.addBasicAuthHeader(login, password));
    }

    public RestAssert withAuthentication(final String login, final String password) {
        return this.withClient(RestAssert.setAuthenticator(new Authenticator(){
            AtomicInteger tries = new AtomicInteger(0);

            public Request authenticate(Route route, okhttp3.Response response) throws IOException {
                if (this.tries.getAndIncrement() > 0) {
                    return null;
                }
                return ((Request.Builder)RestAssert.addBasicAuthHeader(login, password).apply(response.request().newBuilder())).build();
            }
        }));
    }

    public Should should() {
        try {
            return new RestResponseShould(this.call(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query: " + this.url, e);
        }
    }

    private static UnaryOperator<OkHttpClient.Builder> setAuthenticator(Authenticator authenticator) {
        return client -> client.authenticator(authenticator);
    }

    private RestResponse call() throws IOException {
        return RestResponse.call(this.url, this.configureClient, this.configureRequest);
    }

    private static UnaryOperator<Request.Builder> addBasicAuthHeader(String login, String password) {
        return RestAssert.addHeader("Authorization", Credentials.basic((String)login, (String)password));
    }

    private static UnaryOperator<Request.Builder> addHeader(String name, String value) {
        return request -> request.addHeader(name, value);
    }
}

