/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class RestResponse {
    private final MemoryCookieJar cookieJar;
    private final Response response;
    private String bodyAsString;

    private RestResponse(MemoryCookieJar cookieJar, Response response) {
        this.cookieJar = cookieJar;
        this.response = response;
    }

    static RestResponse call(String url, Function<OkHttpClient.Builder, OkHttpClient.Builder> configureClient, Function<Request.Builder, Request.Builder> configureRequest) throws IOException {
        MemoryCookieJar cookieJar = new MemoryCookieJar();
        Request.Builder request = configureRequest.apply(new Request.Builder().url(url));
        OkHttpClient.Builder client = configureClient.apply(new OkHttpClient.Builder().cookieJar((CookieJar)cookieJar));
        OkHttpClient okHttpClient = client.build();
        Response response = okHttpClient.newCall(request.build()).execute();
        return new RestResponse(cookieJar, response);
    }

    public int code() {
        return this.response.code();
    }

    public String bodyAsString() {
        if (this.bodyAsString == null) {
            try {
                this.bodyAsString = this.response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read response as String", e);
            }
        }
        return this.bodyAsString;
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String header(String name) {
        return this.response.header(name);
    }

    public String cookie(String name) {
        List cookies = this.cookieJar.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return cookies.stream().filter(cookie -> cookie.name().equals(name)).findFirst().map(Cookie::value).orElse(null);
    }

    static class MemoryCookieJar
    implements CookieJar {
        Map<HttpUrl, List<Cookie>> map = Collections.synchronizedMap(new HashMap());

        MemoryCookieJar() {
        }

        public void saveFromResponse(HttpUrl httpUrl, List<Cookie> cookies) {
            this.map.put(httpUrl, cookies);
        }

        public List<Cookie> loadForRequest(HttpUrl httpUrl) {
            return this.map.getOrDefault(httpUrl, new ArrayList());
        }
    }
}

