/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import java.util.Objects;
import net.codestory.rest.RestResponse;
import net.codestory.rest.ShouldChain;

class RestResponseShould
implements ShouldChain {
    private final RestResponse response;
    private final boolean negate;

    RestResponseShould(RestResponse response, boolean negate) {
        this.response = response;
        this.negate = negate;
    }

    @Override
    public RestResponseShould not() {
        return new RestResponseShould(this.response, !this.negate);
    }

    @Override
    public RestResponseShould should() {
        return new RestResponseShould(this.response, false);
    }

    @Override
    public RestResponseShould respond(int statusCode) {
        return this.assertEquals("status code", this.response.code(), statusCode);
    }

    @Override
    public RestResponseShould succeed() {
        return this.assertBetween("status code", this.response.code(), 200, 299);
    }

    @Override
    public RestResponseShould fail() {
        return this.assertBetween("status code", this.response.code(), 400, 599);
    }

    @Override
    public RestResponseShould contain(String content) {
        return this.assertContains(this.response.bodyAsString(), content);
    }

    @Override
    public RestResponseShould beEmpty() {
        return this.assertEmpty(this.response.bodyAsString());
    }

    @Override
    public RestResponseShould haveType(String contentType) {
        return this.assertContains(this.response.contentType(), contentType);
    }

    @Override
    public RestResponseShould haveCookie(String name, String value) {
        return this.assertEquals("cookie " + name, this.response.cookie(name), value);
    }

    @Override
    public RestResponseShould haveHeader(String name, String value) {
        return this.assertEquals("header " + name, this.response.header(name), value);
    }

    private RestResponseShould assertEquals(String what, Object actual, Object expected) {
        if (this.negate == Objects.equals(expected, actual)) {
            throw new AssertionError((Object)String.format("Expecting [%s] to be [%s]. It was [%s]", what, expected, actual));
        }
        return this;
    }

    private RestResponseShould assertContains(String actual, String expected) {
        if (this.negate == actual.contains(expected)) {
            throw new AssertionError((Object)String.format("Expecting [%s] to contain [%s]", actual, expected));
        }
        return this;
    }

    private RestResponseShould assertEmpty(String actual) {
        if (this.negate == actual.isEmpty()) {
            throw new AssertionError((Object)String.format("Expecting [%s] to be empty", actual));
        }
        return this;
    }

    private RestResponseShould assertBetween(String what, int actual, int lowerBound, int higherBound) {
        if (this.negate == (actual >= lowerBound && actual <= higherBound)) {
            throw new AssertionError((Object)String.format("Expecting [%s] to be between [%d] and [%d]. It was [%s]", what, lowerBound, higherBound, actual));
        }
        return this;
    }
}

