/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.runtime.BaseTransactionManager;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseConfig {
    private final OpenHelperCreator openHelperCreator;
    private final Class<?> databaseClass;
    private final TransactionManagerCreator transactionManagerCreator;
    private final DatabaseHelperListener helperListener;
    private final Map<Class<?>, TableConfig> tableConfigMap;
    private final ModelNotifier modelNotifier;

    DatabaseConfig(Builder builder) {
        this.openHelperCreator = builder.openHelperCreator;
        this.databaseClass = builder.databaseClass;
        this.transactionManagerCreator = builder.transactionManagerCreator;
        this.helperListener = builder.helperListener;
        this.tableConfigMap = builder.tableConfigMap;
        this.modelNotifier = builder.modelNotifier;
    }

    public OpenHelperCreator helperCreator() {
        return this.openHelperCreator;
    }

    public DatabaseHelperListener helperListener() {
        return this.helperListener;
    }

    public Class<?> databaseClass() {
        return this.databaseClass;
    }

    public TransactionManagerCreator transactionManagerCreator() {
        return this.transactionManagerCreator;
    }

    public ModelNotifier modelNotifier() {
        return this.modelNotifier;
    }

    public Map<Class<?>, TableConfig> tableConfigMap() {
        return this.tableConfigMap;
    }

    public <TModel> TableConfig<TModel> getTableConfigForTable(Class<TModel> modelClass) {
        return this.tableConfigMap().get(modelClass);
    }

    public static final class Builder {
        OpenHelperCreator openHelperCreator;
        final Class<?> databaseClass;
        TransactionManagerCreator transactionManagerCreator;
        DatabaseHelperListener helperListener;
        final Map<Class<?>, TableConfig> tableConfigMap = new HashMap();
        ModelNotifier modelNotifier;

        public Builder(Class<?> databaseClass) {
            this.databaseClass = databaseClass;
        }

        public Builder transactionManagerCreator(TransactionManagerCreator transactionManager) {
            this.transactionManagerCreator = transactionManager;
            return this;
        }

        public Builder helperListener(DatabaseHelperListener helperListener) {
            this.helperListener = helperListener;
            return this;
        }

        public Builder addTableConfig(TableConfig<?> tableConfig) {
            this.tableConfigMap.put(tableConfig.tableClass(), tableConfig);
            return this;
        }

        public Builder modelNotifier(ModelNotifier modelNotifier) {
            this.modelNotifier = modelNotifier;
            return this;
        }

        public Builder openHelper(OpenHelperCreator openHelper) {
            this.openHelperCreator = openHelper;
            return this;
        }

        public DatabaseConfig build() {
            return new DatabaseConfig(this);
        }
    }

    public static interface TransactionManagerCreator {
        public BaseTransactionManager createManager(DatabaseDefinition var1);
    }

    public static interface OpenHelperCreator {
        public OpenHelper createHelper(DatabaseDefinition var1, DatabaseHelperListener var2);
    }
}

