/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import android.content.Context;
import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.config.DatabaseConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.runtime.BaseTransactionManager;
import com.raizlabs.android.dbflow.runtime.ContentResolverNotifier;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.sql.migration.Migration;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.ModelViewAdapter;
import com.raizlabs.android.dbflow.structure.QueryModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowSQLiteOpenHelper;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;
import com.raizlabs.android.dbflow.structure.database.transaction.DefaultTransactionManager;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DatabaseDefinition {
    final Map<Integer, List<Migration>> migrationMap = new HashMap<Integer, List<Migration>>();
    final Map<Class<?>, ModelAdapter> modelAdapters = new HashMap();
    final Map<String, Class<?>> modelTableNames = new HashMap();
    final Map<Class<?>, ModelViewAdapter> modelViewAdapterMap = new LinkedHashMap();
    final Map<Class<?>, QueryModelAdapter> queryModelAdapterMap = new LinkedHashMap();
    private OpenHelper openHelper;
    private DatabaseHelperListener helperListener;
    private boolean isResetting = false;
    private BaseTransactionManager transactionManager;
    private DatabaseConfig databaseConfig = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
    private ModelNotifier modelNotifier;

    public DatabaseDefinition() {
        if (this.databaseConfig != null) {
            Collection<TableConfig> tableConfigCollection = this.databaseConfig.tableConfigMap().values();
            for (TableConfig tableConfig : tableConfigCollection) {
                ModelAdapter modelAdapter = this.modelAdapters.get(tableConfig.tableClass());
                if (modelAdapter == null) continue;
                if (tableConfig.listModelLoader() != null) {
                    modelAdapter.setListModelLoader(tableConfig.listModelLoader());
                }
                if (tableConfig.singleModelLoader() != null) {
                    modelAdapter.setSingleModelLoader(tableConfig.singleModelLoader());
                }
                if (tableConfig.modelSaver() == null) continue;
                modelAdapter.setModelSaver(tableConfig.modelSaver());
            }
            this.helperListener = this.databaseConfig.helperListener();
        }
        this.transactionManager = this.databaseConfig == null || this.databaseConfig.transactionManagerCreator() == null ? new DefaultTransactionManager(this) : this.databaseConfig.transactionManagerCreator().createManager(this);
    }

    public List<Class<?>> getModelClasses() {
        return new ArrayList(this.modelAdapters.keySet());
    }

    public BaseTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public List<ModelAdapter> getModelAdapters() {
        return new ArrayList<ModelAdapter>(this.modelAdapters.values());
    }

    public <T> ModelAdapter<T> getModelAdapterForTable(Class<T> table) {
        return this.modelAdapters.get(table);
    }

    public Class<?> getModelClassForName(String tableName) {
        return this.modelTableNames.get(tableName);
    }

    public List<Class<?>> getModelViews() {
        return new ArrayList(this.modelViewAdapterMap.keySet());
    }

    public <T> ModelViewAdapter<T> getModelViewAdapterForTable(Class<T> table) {
        return this.modelViewAdapterMap.get(table);
    }

    public List<ModelViewAdapter> getModelViewAdapters() {
        return new ArrayList<ModelViewAdapter>(this.modelViewAdapterMap.values());
    }

    public List<QueryModelAdapter> getModelQueryAdapters() {
        return new ArrayList<QueryModelAdapter>(this.queryModelAdapterMap.values());
    }

    public <T> QueryModelAdapter<T> getQueryModelAdapterForQueryClass(Class<T> queryModel) {
        return this.queryModelAdapterMap.get(queryModel);
    }

    public Map<Integer, List<Migration>> getMigrations() {
        return this.migrationMap;
    }

    public synchronized OpenHelper getHelper() {
        if (this.openHelper == null) {
            DatabaseConfig config = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
            this.openHelper = config == null || config.helperCreator() == null ? new FlowSQLiteOpenHelper(this, this.helperListener) : config.helperCreator().createHelper(this, this.helperListener);
            this.openHelper.performRestoreFromBackup();
        }
        return this.openHelper;
    }

    public DatabaseWrapper getWritableDatabase() {
        return this.getHelper().getDatabase();
    }

    public ModelNotifier getModelNotifier() {
        if (this.modelNotifier == null) {
            DatabaseConfig config = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
            this.modelNotifier = config == null || config.modelNotifier() == null ? new ContentResolverNotifier() : config.modelNotifier();
        }
        return this.modelNotifier;
    }

    public Transaction.Builder beginTransactionAsync(ITransaction transaction) {
        return new Transaction.Builder(transaction, this);
    }

    public void executeTransaction(ITransaction transaction) {
        DatabaseWrapper database = this.getWritableDatabase();
        try {
            database.beginTransaction();
            transaction.execute(database);
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    public abstract String getDatabaseName();

    public String getDatabaseFileName() {
        return this.getDatabaseName() + (StringUtils.isNotNullOrEmpty((String)this.getDatabaseExtensionName()) ? "." + this.getDatabaseExtensionName() : "");
    }

    public String getDatabaseExtensionName() {
        return "db";
    }

    public abstract boolean isInMemory();

    public abstract int getDatabaseVersion();

    public abstract boolean areConsistencyChecksEnabled();

    public abstract boolean isForeignKeysSupported();

    public abstract boolean backupEnabled();

    public abstract Class<?> getAssociatedDatabaseClassFile();

    public void reset(Context context) {
        if (!this.isResetting) {
            this.isResetting = true;
            this.getTransactionManager().stopQueue();
            this.getHelper().closeDB();
            for (ModelAdapter modelAdapter : this.modelAdapters.values()) {
                modelAdapter.closeInsertStatement();
                modelAdapter.closeCompiledStatement();
            }
            context.deleteDatabase(this.getDatabaseFileName());
            this.transactionManager = this.databaseConfig == null || this.databaseConfig.transactionManagerCreator() == null ? new DefaultTransactionManager(this) : this.databaseConfig.transactionManagerCreator().createManager(this);
            this.openHelper = null;
            this.isResetting = false;
            this.getHelper().getDatabase();
        }
    }

    public void destroy(Context context) {
        if (!this.isResetting) {
            this.isResetting = true;
            this.getTransactionManager().stopQueue();
            this.getHelper().closeDB();
            context.deleteDatabase(this.getDatabaseFileName());
            this.openHelper = null;
            this.isResetting = false;
        }
    }

    public boolean isDatabaseIntegrityOk() {
        return this.getHelper().isDatabaseIntegrityOk();
    }

    public void backupDatabase() {
        this.getHelper().backupDB();
    }
}

