/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.os.Looper;
import android.os.Process;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;

public class DBBatchSaveQueue
extends Thread {
    private static final int MODEL_SAVE_SIZE = 50;
    private static final int sMODEL_SAVE_CHECK_TIME = 30000;
    private int modelSaveSize = 50;
    private long modelSaveCheckTime = 30000L;
    private final ArrayList<Object> models;
    private boolean isQuitting = false;
    private Transaction.Error errorListener;
    private Transaction.Success successListener;
    private Runnable emptyTransactionListener;
    private DatabaseDefinition databaseDefinition;
    private final ProcessModelTransaction.ProcessModel modelSaver = new ProcessModelTransaction.ProcessModel(){

        public void processModel(Object model, DatabaseWrapper wrapper) {
            if (model instanceof Model) {
                ((Model)model).save();
            } else if (model != null) {
                Class<?> modelClass = model.getClass();
                FlowManager.getModelAdapter(modelClass).save(model);
            }
        }
    };
    private final Transaction.Success successCallback = new Transaction.Success(){

        @Override
        public void onSuccess(Transaction transaction) {
            if (DBBatchSaveQueue.this.successListener != null) {
                DBBatchSaveQueue.this.successListener.onSuccess(transaction);
            }
        }
    };
    private final Transaction.Error errorCallback = new Transaction.Error(){

        @Override
        public void onError(Transaction transaction, Throwable error) {
            if (DBBatchSaveQueue.this.errorListener != null) {
                DBBatchSaveQueue.this.errorListener.onError(transaction, error);
            }
        }
    };

    DBBatchSaveQueue(DatabaseDefinition databaseDefinition) {
        super("DBBatchSaveQueue");
        this.databaseDefinition = databaseDefinition;
        this.models = new ArrayList();
    }

    public void setModelSaveSize(int mModelSaveSize) {
        this.modelSaveSize = mModelSaveSize;
    }

    public void setModelSaveCheckTime(long time) {
        this.modelSaveCheckTime = time;
    }

    public void setErrorListener(Transaction.Error errorListener) {
        this.errorListener = errorListener;
    }

    public void setSuccessListener(Transaction.Success successListener) {
        this.successListener = successListener;
    }

    public void setEmptyTransactionListener(Runnable emptyTransactionListener) {
        this.emptyTransactionListener = emptyTransactionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        Looper.prepare();
        Process.setThreadPriority((int)10);
        do {
            ArrayList<Object> tmpModels;
            ArrayList<Object> arrayList = this.models;
            synchronized (arrayList) {
                tmpModels = new ArrayList<Object>(this.models);
                this.models.clear();
            }
            if (tmpModels.size() > 0) {
                this.databaseDefinition.beginTransactionAsync(new ProcessModelTransaction.Builder<Object>(this.modelSaver).addAll((Collection<Object>)tmpModels).build()).success(this.successCallback).error(this.errorCallback).build().execute();
            } else if (this.emptyTransactionListener != null) {
                this.emptyTransactionListener.run();
            }
            try {
                Thread.sleep(this.modelSaveCheckTime);
            }
            catch (InterruptedException e) {
                FlowLog.log(FlowLog.Level.I, "DBRequestQueue Batch interrupted to start saving");
            }
        } while (!this.isQuitting);
    }

    public void purgeQueue() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object inModel) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.add(inModel);
            if (this.models.size() > this.modelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<Object> list) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.addAll(list);
            if (this.models.size() > this.modelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll2(Collection<?> list) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.addAll(list);
            if (this.models.size() > this.modelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object outModel) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.remove(outModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<Object> outCollection) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.removeAll(outCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll2(Collection<?> outCollection) {
        ArrayList<Object> arrayList = this.models;
        synchronized (arrayList) {
            this.models.removeAll(outCollection);
        }
    }

    public void quit() {
        this.isQuitting = true;
    }
}

