/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.database.sqlite.SQLiteDoneException;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.Actionable;
import com.raizlabs.android.dbflow.sql.queriable.Queriable;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatementWrapper;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public abstract class BaseQueriable<TModel>
implements Queriable,
Actionable {
    private final Class<TModel> table;

    protected BaseQueriable(Class<TModel> table) {
        this.table = table;
    }

    @NonNull
    public Class<TModel> getTable() {
        return this.table;
    }

    @Override
    public long count(DatabaseWrapper databaseWrapper) {
        try {
            String query = this.getQuery();
            FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
            return SqlUtils.longForQuery(databaseWrapper, query);
        }
        catch (SQLiteDoneException sde) {
            FlowLog.log(FlowLog.Level.E, sde);
            return 0L;
        }
    }

    @Override
    public long count() {
        return this.count(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    public boolean hasData() {
        return this.count() > 0L;
    }

    @Override
    public boolean hasData(DatabaseWrapper databaseWrapper) {
        return this.count(databaseWrapper) > 0L;
    }

    @Override
    public Cursor query() {
        this.query(FlowManager.getWritableDatabaseForTable(this.table));
        return null;
    }

    @Override
    public Cursor query(DatabaseWrapper databaseWrapper) {
        if (this.getPrimaryAction().equals((Object)BaseModel.Action.INSERT)) {
            DatabaseStatement databaseStatement = this.compileStatement(databaseWrapper);
            databaseStatement.executeInsert();
            databaseStatement.close();
        } else {
            String query = this.getQuery();
            FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
            databaseWrapper.execSQL(query);
        }
        return null;
    }

    @Override
    public long executeInsert() {
        return this.executeInsert(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    public long executeInsert(DatabaseWrapper databaseWrapper) {
        return this.compileStatement().executeInsert();
    }

    @Override
    public void execute() {
        Cursor cursor = this.query();
        if (cursor != null) {
            cursor.close();
        } else {
            NotifyDistributor.get().notifyTableChanged(this.getTable(), this.getPrimaryAction());
        }
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        Cursor cursor = this.query(databaseWrapper);
        if (cursor != null) {
            cursor.close();
        } else {
            NotifyDistributor.get().notifyTableChanged(this.getTable(), this.getPrimaryAction());
        }
    }

    @Override
    public DatabaseStatement compileStatement() {
        return this.compileStatement(FlowManager.getWritableDatabaseForTable(this.table));
    }

    @Override
    public DatabaseStatement compileStatement(DatabaseWrapper databaseWrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Compiling Query Into Statement: " + query);
        return new DatabaseStatementWrapper(databaseWrapper.compileStatement(query), this);
    }

    public String toString() {
        return this.getQuery();
    }

    @Override
    public abstract BaseModel.Action getPrimaryAction();
}

