/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.From;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.PropertyFactory;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Join<TModel, TFromModel>
implements Query {
    private final Class<TModel> table;
    private JoinType type;
    private From<TFromModel> from;
    private NameAlias alias;
    private OperatorGroup onGroup;
    private List<IProperty> using = new ArrayList<IProperty>();

    public Join(From<TFromModel> from, Class<TModel> table, @NonNull JoinType joinType) {
        this.from = from;
        this.table = table;
        this.type = joinType;
        this.alias = new NameAlias.Builder(FlowManager.getTableName(table)).build();
    }

    public Join(From<TFromModel> from, @NonNull JoinType joinType, ModelQueriable<TModel> modelQueriable) {
        this.table = modelQueriable.getTable();
        this.from = from;
        this.type = joinType;
        this.alias = PropertyFactory.from(modelQueriable).getNameAlias();
    }

    @NonNull
    public Join<TModel, TFromModel> as(String alias) {
        this.alias = this.alias.newBuilder().as(alias).build();
        return this;
    }

    @NonNull
    public From<TFromModel> on(SQLOperator ... onConditions) {
        this.checkNatural();
        this.onGroup = OperatorGroup.nonGroupingClause();
        this.onGroup.andAll(onConditions);
        return this.from;
    }

    @NonNull
    public From<TFromModel> using(IProperty ... columns) {
        this.checkNatural();
        Collections.addAll(this.using, columns);
        return this.from;
    }

    public From<TFromModel> end() {
        return this.from;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.append((Object)this.type.name().replace("_", " ")).appendSpace();
        queryBuilder.append((Object)"JOIN").appendSpace().append((Object)this.alias.getFullQuery()).appendSpace();
        if (!JoinType.NATURAL.equals((Object)this.type)) {
            if (this.onGroup != null) {
                queryBuilder.append((Object)"ON").appendSpace().append((Object)this.onGroup.getQuery()).appendSpace();
            } else if (!this.using.isEmpty()) {
                queryBuilder.append((Object)"USING (").appendList(this.using).append((Object)")").appendSpace();
            }
        }
        return queryBuilder.getQuery();
    }

    public Class<TModel> getTable() {
        return this.table;
    }

    private void checkNatural() {
        if (JoinType.NATURAL.equals((Object)this.type)) {
            throw new IllegalArgumentException("Cannot specify a clause for this join if its NATURAL. Specifying a clause would have no effect. Call end() to continue the query.");
        }
    }

    public static enum JoinType {
        LEFT_OUTER,
        INNER,
        CROSS,
        NATURAL;

    }
}

