/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.migration;

import android.support.annotation.CallSuper;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.migration.BaseMigration;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class UpdateTableMigration<TModel>
extends BaseMigration {
    private final Class<TModel> table;
    private OperatorGroup whereOperatorGroup;
    private OperatorGroup setOperatorGroup;

    public UpdateTableMigration(Class<TModel> table) {
        this.table = table;
    }

    public UpdateTableMigration<TModel> set(SQLOperator ... conditions) {
        if (this.setOperatorGroup == null) {
            this.setOperatorGroup = OperatorGroup.nonGroupingClause();
        }
        this.setOperatorGroup.andAll(conditions);
        return this;
    }

    public UpdateTableMigration<TModel> where(SQLOperator ... conditions) {
        if (this.whereOperatorGroup == null) {
            this.whereOperatorGroup = OperatorGroup.nonGroupingClause();
        }
        this.whereOperatorGroup.andAll(conditions);
        return this;
    }

    @Override
    public final void migrate(DatabaseWrapper database) {
        this.getUpdateStatement().execute(database);
    }

    @Override
    @CallSuper
    public void onPostMigrate() {
        this.setOperatorGroup = null;
        this.whereOperatorGroup = null;
    }

    public BaseQueriable<TModel> getUpdateStatement() {
        return SQLite.update(this.table).set(this.setOperatorGroup).where(this.whereOperatorGroup);
    }
}

