/*
 * Decompiled with CFR 0.152.
 */
package com.tinder.scarlet.websocket.okhttp;

import com.tinder.scarlet.Message;
import com.tinder.scarlet.ShutdownReason;
import com.tinder.scarlet.Stream;
import com.tinder.scarlet.WebSocket;
import com.tinder.scarlet.utils.FlowableUtils;
import com.tinder.scarlet.websocket.okhttp.OkHttpWebSocketEventObserver;
import com.tinder.scarlet.websocket.okhttp.OkHttpWebSocketHolder;
import io.reactivex.Flowable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscription;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket;", "Lcom/tinder/scarlet/WebSocket;", "okHttpWebSocketHolder", "Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocketHolder;", "okHttpWebSocketEventObserver", "Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocketEventObserver;", "connectionEstablisher", "Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$ConnectionEstablisher;", "(Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocketHolder;Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocketEventObserver;Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$ConnectionEstablisher;)V", "cancel", "", "close", "", "shutdownReason", "Lcom/tinder/scarlet/ShutdownReason;", "handleConnectionShutdown", "handleWebSocketEvent", "event", "Lcom/tinder/scarlet/WebSocket$Event;", "open", "Lcom/tinder/scarlet/Stream;", "send", "message", "Lcom/tinder/scarlet/Message;", "ConnectionEstablisher", "Factory", "scarlet-websocket-okhttp"})
public final class OkHttpWebSocket
implements WebSocket {
    @NotNull
    private final OkHttpWebSocketHolder okHttpWebSocketHolder;
    @NotNull
    private final OkHttpWebSocketEventObserver okHttpWebSocketEventObserver;
    @NotNull
    private final ConnectionEstablisher connectionEstablisher;

    public OkHttpWebSocket(@NotNull OkHttpWebSocketHolder okHttpWebSocketHolder, @NotNull OkHttpWebSocketEventObserver okHttpWebSocketEventObserver, @NotNull ConnectionEstablisher connectionEstablisher) {
        Intrinsics.checkNotNullParameter((Object)okHttpWebSocketHolder, (String)"okHttpWebSocketHolder");
        Intrinsics.checkNotNullParameter((Object)((Object)okHttpWebSocketEventObserver), (String)"okHttpWebSocketEventObserver");
        Intrinsics.checkNotNullParameter((Object)connectionEstablisher, (String)"connectionEstablisher");
        this.okHttpWebSocketHolder = okHttpWebSocketHolder;
        this.okHttpWebSocketEventObserver = okHttpWebSocketEventObserver;
        this.connectionEstablisher = connectionEstablisher;
    }

    @NotNull
    public Stream<WebSocket.Event> open() {
        Flowable flowable = this.okHttpWebSocketEventObserver.observe().doOnSubscribe(arg_0 -> OkHttpWebSocket.open$lambda-0(this, arg_0)).doOnNext(this::handleWebSocketEvent);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"okHttpWebSocketEventObse\u2026is::handleWebSocketEvent)");
        return (Stream)FlowableUtils.toStream((Flowable)flowable);
    }

    public synchronized boolean send(@NotNull Message message) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Message message2 = message;
        if (message2 instanceof Message.Text) {
            bl = this.okHttpWebSocketHolder.send(((Message.Text)message).getValue());
        } else if (message2 instanceof Message.Bytes) {
            byte[] bytes = ((Message.Bytes)message).getValue();
            ByteString byteString = ByteString.Companion.of(bytes, 0, bytes.length);
            bl = this.okHttpWebSocketHolder.send(byteString);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public synchronized boolean close(@NotNull ShutdownReason shutdownReason) {
        Intrinsics.checkNotNullParameter((Object)shutdownReason, (String)"shutdownReason");
        ShutdownReason shutdownReason2 = shutdownReason;
        int code = shutdownReason2.component1();
        String reasonText = shutdownReason2.component2();
        return this.okHttpWebSocketHolder.close(code, reasonText);
    }

    public synchronized void cancel() {
        this.okHttpWebSocketHolder.cancel();
    }

    private final void handleWebSocketEvent(WebSocket.Event event) {
        WebSocket.Event event2 = event;
        if (event2 instanceof WebSocket.Event.OnConnectionOpened) {
            this.okHttpWebSocketHolder.initiate((okhttp3.WebSocket)((WebSocket.Event.OnConnectionOpened)event).getWebSocket());
        } else if (event2 instanceof WebSocket.Event.OnConnectionClosing) {
            this.close(ShutdownReason.GRACEFUL);
        } else if (event2 instanceof WebSocket.Event.OnConnectionClosed ? true : event2 instanceof WebSocket.Event.OnConnectionFailed) {
            this.handleConnectionShutdown();
        }
    }

    private final synchronized void handleConnectionShutdown() {
        this.okHttpWebSocketHolder.shutdown();
        this.okHttpWebSocketEventObserver.terminate();
    }

    private static final void open$lambda-0(OkHttpWebSocket this$0, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.connectionEstablisher.establishConnection(this$0.okHttpWebSocketEventObserver);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$ConnectionEstablisher;", "", "establishConnection", "", "webSocketListener", "Lokhttp3/WebSocketListener;", "scarlet-websocket-okhttp"})
    public static interface ConnectionEstablisher {
        public void establishConnection(@NotNull WebSocketListener var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$Factory;", "Lcom/tinder/scarlet/WebSocket$Factory;", "connectionEstablisher", "Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$ConnectionEstablisher;", "(Lcom/tinder/scarlet/websocket/okhttp/OkHttpWebSocket$ConnectionEstablisher;)V", "create", "Lcom/tinder/scarlet/WebSocket;", "scarlet-websocket-okhttp"})
    public static final class Factory
    implements WebSocket.Factory {
        @NotNull
        private final ConnectionEstablisher connectionEstablisher;

        public Factory(@NotNull ConnectionEstablisher connectionEstablisher) {
            Intrinsics.checkNotNullParameter((Object)connectionEstablisher, (String)"connectionEstablisher");
            this.connectionEstablisher = connectionEstablisher;
        }

        @NotNull
        public WebSocket create() {
            return new OkHttpWebSocket(new OkHttpWebSocketHolder(), new OkHttpWebSocketEventObserver(), this.connectionEstablisher);
        }
    }
}

