/*
 * Decompiled with CFR 0.152.
 */
package yyydjk.com.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import yyydjk.com.library.R;

public class CouponViewHelper {
    private static final int DEFAULT_SEMICIRCLE_GAP = 4;
    private static final int DEFAULT_DASH_LINE_LENGTH = 10;
    private static final int DEFAULT_SEMICIRCLE_RADIUS = 4;
    private static final int DEFAULT_SEMICIRCLE_COLOR = -1;
    private static final int DEFAULT_DASH_LINE_HEIGHT = 1;
    private static final int DEFAULT_DASH_LINE_GAP = 5;
    private static final int DEFAULT_DASH_LINE_COLOR = -1;
    private static final int DEFAULT_DASH_LINE_MARGIN = 10;
    private Context context;
    private View view;
    private Paint semicirclePaint;
    private Paint dashLinePaint;
    private float semicircleGap = 4.0f;
    private float semicircleRadius = 4.0f;
    private int semicircleColor = -1;
    private int semicircleNumX;
    private int semicircleNumY;
    private int remindSemicircleX;
    private int remindSemicircleY;
    private float dashLineLength = 10.0f;
    private float dashLineHeight = 1.0f;
    private float dashLineGap = 5.0f;
    private int dashLineColor = -1;
    private int remindDashLineX;
    private int remindDashLineY;
    private int dashLineNumX;
    private int dashLineNumY;
    private boolean isSemicircleTop = true;
    private boolean isSemicircleBottom = true;
    private boolean isSemicircleLeft = false;
    private boolean isSemicircleRight = false;
    private boolean isDashLineTop = false;
    private boolean isDashLineBottom = false;
    private boolean isDashLineLeft = true;
    private boolean isDashLineRight = true;
    private int viewWidth;
    private int viewHeight;
    private float dashLineMarginTop = 10.0f;
    private float dashLineMarginBottom = 10.0f;
    private float dashLineMarginLeft = 10.0f;
    private float dashLineMarginRight = 10.0f;

    public CouponViewHelper(View view, Context context, AttributeSet attrs, int defStyle) {
        this.context = context;
        this.view = view;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CouponView, defStyle, 0);
        this.semicircleRadius = a.getDimensionPixelSize(R.styleable.CouponView_cv_semicircle_radius, this.dp2Px(4.0f));
        this.semicircleGap = a.getDimensionPixelSize(R.styleable.CouponView_cv_semicircle_gap, this.dp2Px(4.0f));
        this.semicircleColor = a.getColor(R.styleable.CouponView_cv_semicircle_color, -1);
        this.dashLineGap = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_gap, this.dp2Px(5.0f));
        this.dashLineHeight = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_height, this.dp2Px(1.0f));
        this.dashLineLength = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_length, this.dp2Px(10.0f));
        this.dashLineColor = a.getColor(R.styleable.CouponView_cv_dash_line_color, -1);
        this.isSemicircleTop = a.getBoolean(R.styleable.CouponView_cv_is_semicircle_top, this.isSemicircleTop);
        this.isSemicircleBottom = a.getBoolean(R.styleable.CouponView_cv_is_semicircle_bottom, this.isSemicircleBottom);
        this.isSemicircleLeft = a.getBoolean(R.styleable.CouponView_cv_is_semicircle_left, this.isSemicircleLeft);
        this.isSemicircleRight = a.getBoolean(R.styleable.CouponView_cv_is_semicircle_right, this.isSemicircleRight);
        this.isDashLineTop = a.getBoolean(R.styleable.CouponView_cv_is_dash_line_top, this.isDashLineTop);
        this.isDashLineBottom = a.getBoolean(R.styleable.CouponView_cv_is_dash_line_bottom, this.isDashLineBottom);
        this.isDashLineLeft = a.getBoolean(R.styleable.CouponView_cv_is_dash_line_left, this.isDashLineLeft);
        this.isDashLineRight = a.getBoolean(R.styleable.CouponView_cv_is_dash_line_right, this.isDashLineRight);
        this.dashLineMarginTop = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_margin_top, this.dp2Px(10.0f));
        this.dashLineMarginBottom = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_margin_bottom, this.dp2Px(10.0f));
        this.dashLineMarginLeft = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_margin_left, this.dp2Px(10.0f));
        this.dashLineMarginRight = a.getDimensionPixelSize(R.styleable.CouponView_cv_dash_line_margin_right, this.dp2Px(10.0f));
        a.recycle();
        this.init();
    }

    private void init() {
        this.semicirclePaint = new Paint(1);
        this.semicirclePaint.setDither(true);
        this.semicirclePaint.setColor(this.semicircleColor);
        this.semicirclePaint.setStyle(Paint.Style.FILL);
        this.dashLinePaint = new Paint(1);
        this.dashLinePaint.setDither(true);
        this.dashLinePaint.setColor(this.dashLineColor);
        this.dashLinePaint.setStyle(Paint.Style.FILL);
    }

    public void onSizeChanged(int w, int h) {
        this.viewWidth = w;
        this.viewHeight = h;
        this.calculate();
    }

    private void calculate() {
        if (this.isSemicircleTop || this.isSemicircleBottom) {
            this.remindSemicircleX = (int)(((float)this.viewWidth - this.semicircleGap) % (2.0f * this.semicircleRadius + this.semicircleGap));
            this.semicircleNumX = (int)(((float)this.viewWidth - this.semicircleGap) / (2.0f * this.semicircleRadius + this.semicircleGap));
        }
        if (this.isSemicircleLeft || this.isSemicircleRight) {
            this.remindSemicircleY = (int)(((float)this.viewHeight - this.semicircleGap) % (2.0f * this.semicircleRadius + this.semicircleGap));
            this.semicircleNumY = (int)(((float)this.viewHeight - this.semicircleGap) / (2.0f * this.semicircleRadius + this.semicircleGap));
        }
        if (this.isDashLineTop || this.isDashLineBottom) {
            this.remindDashLineX = (int)(((float)this.viewWidth + this.dashLineGap - this.dashLineMarginLeft - this.dashLineMarginRight) % (this.dashLineLength + this.dashLineGap));
            this.dashLineNumX = (int)(((float)this.viewWidth + this.dashLineGap - this.dashLineMarginLeft - this.dashLineMarginRight) / (this.dashLineLength + this.dashLineGap));
        }
        if (this.isDashLineLeft || this.isDashLineRight) {
            this.remindDashLineY = (int)(((float)this.viewHeight + this.dashLineGap - this.dashLineMarginTop - this.dashLineMarginBottom) % (this.dashLineLength + this.dashLineGap));
            this.dashLineNumY = (int)(((float)this.viewHeight + this.dashLineGap - this.dashLineMarginTop - this.dashLineMarginBottom) / (this.dashLineLength + this.dashLineGap));
        }
    }

    public void onDraw(Canvas canvas) {
        float y;
        float x;
        int i;
        if (this.isSemicircleTop) {
            for (i = 0; i < this.semicircleNumX; ++i) {
                x = this.semicircleGap + this.semicircleRadius + (float)(this.remindSemicircleX / 2) + (this.semicircleGap + this.semicircleRadius * 2.0f) * (float)i;
                canvas.drawCircle(x, 0.0f, this.semicircleRadius, this.semicirclePaint);
            }
        }
        if (this.isSemicircleBottom) {
            for (i = 0; i < this.semicircleNumX; ++i) {
                x = this.semicircleGap + this.semicircleRadius + (float)(this.remindSemicircleX / 2) + (this.semicircleGap + this.semicircleRadius * 2.0f) * (float)i;
                canvas.drawCircle(x, (float)this.viewHeight, this.semicircleRadius, this.semicirclePaint);
            }
        }
        if (this.isSemicircleLeft) {
            for (i = 0; i < this.semicircleNumY; ++i) {
                y = this.semicircleGap + this.semicircleRadius + (float)(this.remindSemicircleY / 2) + (this.semicircleGap + this.semicircleRadius * 2.0f) * (float)i;
                canvas.drawCircle(0.0f, y, this.semicircleRadius, this.semicirclePaint);
            }
        }
        if (this.isSemicircleRight) {
            for (i = 0; i < this.semicircleNumY; ++i) {
                y = this.semicircleGap + this.semicircleRadius + (float)(this.remindSemicircleY / 2) + (this.semicircleGap + this.semicircleRadius * 2.0f) * (float)i;
                canvas.drawCircle((float)this.viewWidth, y, this.semicircleRadius, this.semicirclePaint);
            }
        }
        if (this.isDashLineTop) {
            for (i = 0; i < this.dashLineNumX; ++i) {
                x = this.dashLineMarginLeft + (float)(this.remindDashLineX / 2) + (this.dashLineGap + this.dashLineLength) * (float)i;
                canvas.drawRect(x, this.dashLineMarginTop, x + this.dashLineLength, this.dashLineMarginTop + this.dashLineHeight, this.dashLinePaint);
            }
        }
        if (this.isDashLineBottom) {
            for (i = 0; i < this.dashLineNumX; ++i) {
                x = this.dashLineMarginLeft + (float)(this.remindDashLineX / 2) + (this.dashLineGap + this.dashLineLength) * (float)i;
                canvas.drawRect(x, (float)this.viewHeight - this.dashLineHeight - this.dashLineMarginBottom, x + this.dashLineLength, (float)this.viewHeight - this.dashLineMarginBottom, this.dashLinePaint);
            }
        }
        if (this.isDashLineLeft) {
            for (i = 0; i < this.dashLineNumY; ++i) {
                y = this.dashLineMarginTop + (float)(this.remindDashLineY / 2) + (this.dashLineGap + this.dashLineLength) * (float)i;
                canvas.drawRect(this.dashLineMarginLeft, y, this.dashLineMarginLeft + this.dashLineHeight, y + this.dashLineLength, this.dashLinePaint);
            }
        }
        if (this.isDashLineRight) {
            for (i = 0; i < this.dashLineNumY; ++i) {
                y = this.dashLineMarginTop + (float)(this.remindDashLineY / 2) + (this.dashLineGap + this.dashLineLength) * (float)i;
                canvas.drawRect((float)this.viewWidth - this.dashLineMarginRight - this.dashLineHeight, y, (float)this.viewWidth - this.dashLineMarginRight, y + this.dashLineLength, this.dashLinePaint);
            }
        }
    }

    private int dp2Px(float dp) {
        return (int)(dp * this.context.getResources().getDisplayMetrics().density + 0.5f);
    }

    private int px2Dp(float px) {
        return (int)(px / this.context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public float getSemicircleGap() {
        return this.px2Dp(this.semicircleGap);
    }

    public void setSemicircleGap(float semicircleGap) {
        if (this.semicircleGap != semicircleGap) {
            this.semicircleGap = semicircleGap;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getSemicircleRadius() {
        return this.px2Dp(this.semicircleRadius);
    }

    public void setSemicircleRadius(float semicircleRadius) {
        if (this.semicircleRadius != semicircleRadius) {
            this.semicircleRadius = semicircleRadius;
            this.calculate();
            this.view.invalidate();
        }
    }

    public int getSemicircleColor() {
        return this.semicircleColor;
    }

    public void setSemicircleColor(int semicircleColor) {
        if (this.semicircleColor != semicircleColor) {
            this.semicircleColor = semicircleColor;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineLength() {
        return this.px2Dp(this.dashLineLength);
    }

    public void setDashLineLength(float dashLineLength) {
        if (this.dashLineLength != dashLineLength) {
            this.dashLineLength = dashLineLength;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineHeight() {
        return this.px2Dp(this.dashLineHeight);
    }

    public void setDashLineHeight(float dashLineHeight) {
        if (this.dashLineHeight != dashLineHeight) {
            this.dashLineHeight = dashLineHeight;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineGap() {
        return this.px2Dp(this.dashLineGap);
    }

    public void setDashLineGap(float dashLineGap) {
        if (this.dashLineGap != dashLineGap) {
            this.dashLineGap = dashLineGap;
            this.calculate();
            this.view.invalidate();
        }
    }

    public int getDashLineColor() {
        return this.dashLineColor;
    }

    public void setDashLineColor(int dashLineColor) {
        if (this.dashLineColor != dashLineColor) {
            this.dashLineColor = dashLineColor;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isSemicircleTop() {
        return this.isSemicircleTop;
    }

    public void setSemicircleTop(boolean semicircleTop) {
        if (this.isSemicircleTop != semicircleTop) {
            this.isSemicircleTop = semicircleTop;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isSemicircleBottom() {
        return this.isSemicircleBottom;
    }

    public void setSemicircleBottom(boolean semicircleBottom) {
        if (this.isSemicircleBottom != semicircleBottom) {
            this.isSemicircleBottom = semicircleBottom;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isSemicircleLeft() {
        return this.isSemicircleLeft;
    }

    public void setSemicircleLeft(boolean semicircleLeft) {
        if (this.isSemicircleLeft != semicircleLeft) {
            this.isSemicircleLeft = semicircleLeft;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isSemicircleRight() {
        return this.isSemicircleRight;
    }

    public void setSemicircleRight(boolean semicircleRight) {
        if (this.isSemicircleRight != semicircleRight) {
            this.isSemicircleRight = semicircleRight;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isDashLineTop() {
        return this.isDashLineTop;
    }

    public void setDashLineTop(boolean dashLineTop) {
        if (this.isDashLineTop != dashLineTop) {
            this.isDashLineTop = dashLineTop;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isDashLineBottom() {
        return this.isDashLineBottom;
    }

    public void setDashLineBottom(boolean dashLineBottom) {
        if (this.isDashLineBottom != dashLineBottom) {
            this.isDashLineBottom = dashLineBottom;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isDashLineLeft() {
        return this.isDashLineLeft;
    }

    public void setDashLineLeft(boolean dashLineLeft) {
        if (this.isDashLineLeft != dashLineLeft) {
            this.isDashLineLeft = dashLineLeft;
            this.calculate();
            this.view.invalidate();
        }
    }

    public boolean isDashLineRight() {
        return this.isDashLineRight;
    }

    public void setDashLineRight(boolean dashLineRight) {
        if (this.isDashLineRight != dashLineRight) {
            this.isDashLineRight = dashLineRight;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineMarginTop() {
        return this.px2Dp(this.dashLineMarginTop);
    }

    public void setDashLineMarginTop(float dashLineMarginTop) {
        if (this.dashLineMarginTop != dashLineMarginTop) {
            this.dashLineMarginTop = dashLineMarginTop;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineMarginBottom() {
        return this.px2Dp(this.dashLineMarginBottom);
    }

    public void setDashLineMarginBottom(float dashLineMarginBottom) {
        if (this.dashLineMarginBottom != dashLineMarginBottom) {
            this.dashLineMarginBottom = dashLineMarginBottom;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineMarginLeft() {
        return this.px2Dp(this.dashLineMarginLeft);
    }

    public void setDashLineMarginLeft(float dashLineMarginLeft) {
        if (this.dashLineMarginLeft != dashLineMarginLeft) {
            this.dashLineMarginLeft = dashLineMarginLeft;
            this.calculate();
            this.view.invalidate();
        }
    }

    public float getDashLineMarginRight() {
        return this.px2Dp(this.dashLineMarginRight);
    }

    public void setDashLineMarginRight(float dashLineMarginRight) {
        if (this.dashLineMarginRight != dashLineMarginRight) {
            this.dashLineMarginRight = dashLineMarginRight;
            this.calculate();
            this.view.invalidate();
        }
    }
}

