/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.BaseViewHolder;
import com.freelib.multiitem.listener.OnItemClickListener;
import com.freelib.multiitem.listener.OnItemLongClickListener;

public abstract class ViewHolderManager<T, V extends BaseViewHolder> {
    @NonNull
    public abstract V onCreateViewHolder(@NonNull ViewGroup var1);

    public abstract void onBindViewHolder(@NonNull V var1, @NonNull T var2);

    public void onBindViewHolder(@NonNull V holder, @NonNull T t, @NonNull ViewHolderParams params) {
        ((BaseViewHolder)((Object)holder)).itemView.setOnClickListener((View.OnClickListener)params.clickListener);
        ((BaseViewHolder)((Object)holder)).itemView.setOnLongClickListener((View.OnLongClickListener)params.longClickListener);
        this.onBindViewHolder(holder, t);
    }

    public final int getPosition(@NonNull RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    protected View getItemView(@LayoutRes int layoutId, ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
    }

    protected <T extends View> T getView(View view, int id) {
        return (T)view.findViewById(id);
    }

    protected <T extends View> T getView(RecyclerView.ViewHolder viewHolder, int id) {
        return this.getView(viewHolder.itemView, id);
    }

    public static class ViewHolderParams {
        private OnItemClickListener clickListener;
        private OnItemLongClickListener longClickListener;
        private int itemCount;
        private int listViewScrollState;

        ViewHolderParams setClickListener(OnItemClickListener clickListener) {
            this.clickListener = clickListener;
            return this;
        }

        ViewHolderParams setLongClickListener(OnItemLongClickListener longClickListener) {
            this.longClickListener = longClickListener;
            return this;
        }

        ViewHolderParams setItemCount(int itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        ViewHolderParams setListViewScrollState(int listViewScrollState) {
            this.listViewScrollState = listViewScrollState;
            return this;
        }

        public OnItemClickListener getClickListener() {
            return this.clickListener;
        }

        public OnItemLongClickListener getLongClickListener() {
            return this.longClickListener;
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public int getListViewScrollState() {
            return this.listViewScrollState;
        }
    }
}

