/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter.type;

import android.support.annotation.NonNull;
import com.freelib.multiitem.adapter.holder.ViewHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManagerGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemTypeManager {
    protected Map<String, ViewHolderManagerGroup> itemClassNameGroupMap = new HashMap<String, ViewHolderManagerGroup>();
    protected List<String> itemClassNames = new ArrayList<String>();
    protected List<ViewHolderManager> viewHolderManagers = new ArrayList<ViewHolderManager>();

    public void register(Class<?> cls, ViewHolderManager manager) {
        this.register(this.getClassName(cls), manager);
    }

    public void register(Class<?> cls, ViewHolderManagerGroup group) {
        ViewHolderManager[] managers = group.getViewHolderManagers();
        int length = managers.length;
        for (int i = 0; i < length; ++i) {
            this.register(this.getClassNameFromGroup(cls, group, managers[i]), managers[i]);
        }
        this.itemClassNameGroupMap.put(this.getClassName(cls), group);
    }

    private void register(String className, ViewHolderManager manager) {
        if (this.itemClassNames.contains(className)) {
            this.viewHolderManagers.set(this.itemClassNames.indexOf(className), manager);
        } else {
            this.itemClassNames.add(className);
            this.viewHolderManagers.add(manager);
        }
    }

    public int getItemType(@NonNull Object itemData) {
        String key = this.getClassName(itemData.getClass());
        if (this.itemClassNameGroupMap.containsKey(key)) {
            ViewHolderManager manager = this.itemClassNameGroupMap.get(key).getViewHolderManager(itemData);
            key = this.getClassNameFromGroup(itemData.getClass(), this.itemClassNameGroupMap.get(key), manager);
        }
        return this.itemClassNames.indexOf(key);
    }

    public ViewHolderManager getViewHolderManager(int type) {
        if (type < 0 || type > this.viewHolderManagers.size() - 1) {
            return null;
        }
        return this.viewHolderManagers.get(type);
    }

    public ViewHolderManager getViewHolderManager(Object itemData) {
        return this.getViewHolderManager(this.getItemType(itemData));
    }

    public List<ViewHolderManager> getViewHolderManagers() {
        return this.viewHolderManagers;
    }

    public List<String> getItemClassNames() {
        return this.itemClassNames;
    }

    private String getClassName(Class<?> cls) {
        return cls.getName();
    }

    private String getClassNameFromGroup(Class<?> cls, ViewHolderManagerGroup group, ViewHolderManager manager) {
        return this.getClassName(cls) + group.getViewHolderManagerTag(manager);
    }
}

