/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter.holder;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.ViewHolderParams;
import com.freelib.multiitem.item.ItemData;

public abstract class ViewHolderManager<T, V extends BaseViewHolder> {
    private boolean fullSpan;
    private int spanSize;

    @NonNull
    public abstract V onCreateViewHolder(@NonNull ViewGroup var1);

    public abstract void onBindViewHolder(@NonNull V var1, @NonNull T var2);

    public void onBindViewHolder(@NonNull V holder, @NonNull T t, @NonNull ViewHolderParams params) {
        if (this.isClickable()) {
            ((BaseViewHolder)((Object)holder)).itemView.setOnClickListener((View.OnClickListener)params.getClickListener());
            ((BaseViewHolder)((Object)holder)).itemView.setOnLongClickListener((View.OnLongClickListener)params.getLongClickListener());
        }
        if (t instanceof ItemData) {
            this.bindView(holder, (ItemData)t);
        }
        this.onBindViewHolder(holder, t);
    }

    protected void bindView(V holder, ItemData data) {
        this.setVisibility(((BaseViewHolder)((Object)holder)).itemView, data.getVisibility());
    }

    protected void setVisibility(View itemView, int visibility) {
        itemView.setVisibility(visibility);
    }

    public final int getPosition(@NonNull RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    protected View getItemView(ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(this.getItemLayoutId(), parent, false);
    }

    @LayoutRes
    protected abstract int getItemLayoutId();

    protected <T extends View> T getView(View view, int id) {
        return (T)view.findViewById(id);
    }

    protected <T extends View> T getView(RecyclerView.ViewHolder viewHolder, int id) {
        return this.getView(viewHolder.itemView, id);
    }

    public void setFullSpan(boolean fullSpan) {
        this.fullSpan = fullSpan;
    }

    public boolean isFullSpan() {
        return this.fullSpan;
    }

    public int getSpanSize(int spanCount) {
        return this.spanSize > 0 ? this.spanSize : (this.isFullSpan() ? spanCount : 1);
    }

    public void setSpanSize(int spanSize) {
        this.spanSize = spanSize;
    }

    public boolean isClickable() {
        return true;
    }
}

