/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.item;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.BaseItemAdapter;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.HeadFootHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManager;
import com.freelib.multiitem.item.ItemManager;
import com.freelib.multiitem.item.LoadMoreManager$$Lambda$1;
import com.freelib.multiitem.listener.OnLoadMoreListener;

public abstract class LoadMoreManager
extends HeadFootHolderManager
implements ItemManager {
    protected BaseItemAdapter adapter;
    protected OnLoadMoreListener onLoadMoreListener;
    protected boolean isAutoLoadMore;
    protected View loadMoreView;
    protected View.OnClickListener loadMoreClickListener = LoadMoreManager$$Lambda$1.lambdaFactory$(this);
    protected boolean isLoadFinish;

    public LoadMoreManager(OnLoadMoreListener onLoadMoreListener) {
        this(onLoadMoreListener, true);
    }

    public LoadMoreManager(OnLoadMoreListener onLoadMoreListener, boolean isAutoLoadMore) {
        this.onLoadMoreListener = onLoadMoreListener;
        this.isAutoLoadMore = isAutoLoadMore;
    }

    @Override
    @NonNull
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent) {
        BaseViewHolder holder = super.onCreateViewHolder(parent);
        this.loadMoreView = holder.itemView;
        this.setOnLoadMoreClickListener(this.loadMoreClickListener);
        return holder;
    }

    private void setOnLoadMoreClickListener(View.OnClickListener loadMoreClickListener) {
        this.loadMoreView.setOnClickListener(loadMoreClickListener);
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, @NonNull Object o) {
        if (this.isNeeLoadMore(holder)) {
            if (this.isAutoLoadMore()) {
                this.onLoadMore();
            }
        } else {
            this.updateLoadInitView();
        }
    }

    protected boolean isNeeLoadMore(@NonNull BaseViewHolder holder) {
        int headFootCount = this.adapter.getHeadCount() + this.adapter.getFootCount();
        return headFootCount < holder.getItemPosition();
    }

    protected abstract void updateLoadInitView();

    @Override
    protected abstract int getItemLayoutId();

    protected void onLoadMore() {
        if (!this.isLoadFinish) {
            this.getOnLoadMoreListener().onLoadMore();
            this.setOnLoadMoreClickListener(null);
            this.updateLoadingMoreView();
        }
    }

    protected abstract void updateLoadingMoreView();

    public void loadCompleted(boolean isLoadAll) {
        this.setOnLoadMoreClickListener(isLoadAll ? null : this.loadMoreClickListener);
        this.isLoadFinish = isLoadAll;
        this.updateLoadCompletedView(isLoadAll);
    }

    protected abstract void updateLoadCompletedView(boolean var1);

    public void loadFailed() {
        this.setOnLoadMoreClickListener(this.loadMoreClickListener);
        this.updateLoadFailedView();
    }

    protected abstract void updateLoadFailedView();

    @Override
    public boolean isClickable() {
        return false;
    }

    @Override
    @NonNull
    public String getItemTypeName() {
        return this.toString();
    }

    @Override
    @NonNull
    public ViewHolderManager getViewHolderManager() {
        return this;
    }

    public OnLoadMoreListener getOnLoadMoreListener() {
        return this.onLoadMoreListener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    public boolean isAutoLoadMore() {
        return this.isAutoLoadMore;
    }

    public void setAutoLoadMore(boolean autoLoadMore) {
        this.isAutoLoadMore = autoLoadMore;
    }

    public void setAdapter(BaseItemAdapter adapter) {
        this.adapter = adapter;
    }

    static /* synthetic */ void lambda$new$0(LoadMoreManager this_, View view) {
        this_.onLoadMore();
    }
}

