/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.layer.toast;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import per.goweii.layer.core.DecorLayer;
import per.goweii.layer.core.Layers;
import per.goweii.layer.core.anim.AnimatorHelper;
import per.goweii.layer.core.utils.Utils;
import per.goweii.layer.toast.R;

public class ToastLayer
extends DecorLayer {
    protected static final long DEFAULT_ANIMATOR_DURATION = 220L;
    private final Runnable mDismissRunnable = new DismissRunnable();

    @NonNull
    public static ToastLayer create() {
        return new ToastLayer(Layers.requireCurrentActivity());
    }

    public ToastLayer(@NonNull Context context) {
        this(Utils.requireActivity((Context)context));
    }

    public ToastLayer(@NonNull Activity activity) {
        super(activity);
    }

    @IntRange(from=0L)
    protected int getLevel() {
        return 6000;
    }

    @NonNull
    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    @NonNull
    public ViewHolder getViewHolder() {
        return (ViewHolder)super.getViewHolder();
    }

    @NonNull
    protected Config onCreateConfig() {
        return new Config();
    }

    @NonNull
    public Config getConfig() {
        return (Config)super.getConfig();
    }

    @NonNull
    protected ListenerHolder onCreateListenerHolder() {
        return new ListenerHolder();
    }

    @NonNull
    public ListenerHolder getListenerHolder() {
        return (ListenerHolder)super.getListenerHolder();
    }

    @CallSuper
    protected void onAttach() {
        super.onAttach();
        this.getChild().setTag(R.id.layer_toast_tag, (Object)this);
        if (this.getConfig().mRemoveOthers) {
            this.removeOthers();
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getChild().getLayoutParams();
        params.gravity = this.getConfig().mGravity;
        if (this.getConfig().mMarginLeft != null) {
            params.leftMargin = this.getConfig().mMarginLeft;
        }
        if (this.getConfig().mMarginTop != null) {
            params.topMargin = this.getConfig().mMarginTop;
        }
        if (this.getConfig().mMarginRight != null) {
            params.rightMargin = this.getConfig().mMarginRight;
        }
        if (this.getConfig().mMarginBottom != null) {
            params.bottomMargin = this.getConfig().mMarginBottom;
        }
        this.getChild().setLayoutParams((ViewGroup.LayoutParams)params);
        this.getViewHolder().getContent().setAlpha(this.getConfig().mAlpha);
    }

    @CallSuper
    protected void onPostShow() {
        super.onPostShow();
        if (this.getConfig().mDuration > 0L) {
            this.getChild().postDelayed(this.mDismissRunnable, this.getConfig().mDuration);
        }
    }

    @CallSuper
    protected void onPreDismiss() {
        this.getChild().removeCallbacks(this.mDismissRunnable);
        super.onPreDismiss();
    }

    @CallSuper
    protected void onDetach() {
        this.getChild().setTag(R.id.layer_toast_tag, null);
        super.onDetach();
    }

    @NonNull
    protected View onCreateChild(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        FrameLayout container = new FrameLayout((Context)this.getActivity());
        View content = this.onCreateContent(inflater, (ViewGroup)container);
        ViewGroup.LayoutParams contentLayoutParams = content.getLayoutParams();
        FrameLayout.LayoutParams newContentLayoutParams = contentLayoutParams == null ? this.generateContentDefaultLayoutParams() : (contentLayoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)contentLayoutParams : new FrameLayout.LayoutParams(contentLayoutParams.width, contentLayoutParams.height));
        content.setLayoutParams((ViewGroup.LayoutParams)newContentLayoutParams);
        this.getViewHolder().setContent(content);
        container.addView(content);
        return container;
    }

    protected void onDestroyChild() {
        this.getViewHolder().getChild().removeAllViews();
        if (!this.isViewCacheable()) {
            this.getViewHolder().setContent(null);
        }
        super.onDestroyChild();
    }

    @NonNull
    protected View onCreateContent(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        if (this.getConfig().mContentView != null) {
            Utils.removeViewParent((View)this.getConfig().mContentView);
            return this.getConfig().mContentView;
        }
        if (this.getConfig().mContentViewId != -1) {
            return inflater.inflate(this.getConfig().mContentViewId, parent, false);
        }
        throw new IllegalStateException("\u672a\u8bbe\u7f6econtentView");
    }

    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    @NonNull
    protected FrameLayout.LayoutParams generateContentDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-2, -2);
    }

    @NonNull
    protected Animator onCreateInAnimator(@NonNull View view) {
        Animator animator = super.onCreateInAnimator(view);
        if (animator == null) {
            animator = AnimatorHelper.createZoomAlphaInAnim((View)view);
            animator.setDuration(220L);
        }
        return animator;
    }

    @NonNull
    protected Animator onCreateOutAnimator(@NonNull View view) {
        Animator animator = super.onCreateOutAnimator(view);
        if (animator == null) {
            animator = AnimatorHelper.createZoomAlphaOutAnim((View)view);
            animator.setDuration(220L);
        }
        return animator;
    }

    private void removeOthers() {
        ViewGroup parent = this.getParent();
        int count = parent.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            ToastLayer toastLayer;
            View child = parent.getChildAt(i);
            Object tag = child.getTag(R.id.layer_toast_tag);
            if (!(tag instanceof ToastLayer) || (toastLayer = (ToastLayer)((Object)tag)) == this) continue;
            toastLayer.dismiss(false);
        }
    }

    @NonNull
    public ToastLayer setRemoveOthers(boolean removeOthers) {
        this.getConfig().mRemoveOthers = removeOthers;
        return this;
    }

    @NonNull
    public ToastLayer setContentView(@NonNull View contentView) {
        this.getConfig().mContentView = contentView;
        return this;
    }

    @NonNull
    public ToastLayer setContentView(@LayoutRes int contentView) {
        this.getConfig().mContentViewId = contentView;
        return this;
    }

    @NonNull
    public ToastLayer setDuration(long duration) {
        this.getConfig().mDuration = duration;
        return this;
    }

    @NonNull
    public ToastLayer setGravity(int gravity) {
        this.getConfig().mGravity = gravity;
        return this;
    }

    @NonNull
    public ToastLayer setMarginLeft(@Nullable Integer marginLeft) {
        this.getConfig().mMarginLeft = marginLeft;
        return this;
    }

    @NonNull
    public ToastLayer setMarginTop(@Nullable Integer marginTop) {
        this.getConfig().mMarginTop = marginTop;
        return this;
    }

    @NonNull
    public ToastLayer setMarginRight(@Nullable Integer marginRight) {
        this.getConfig().mMarginRight = marginRight;
        return this;
    }

    @NonNull
    public ToastLayer setMarginBottom(@Nullable Integer marginBottom) {
        this.getConfig().mMarginBottom = marginBottom;
        return this;
    }

    @NonNull
    public ToastLayer setAlpha(float alpha) {
        this.getConfig().mAlpha = alpha;
        return this;
    }

    protected static class ListenerHolder
    extends DecorLayer.ListenerHolder {
        protected ListenerHolder() {
        }
    }

    protected static class Config
    extends DecorLayer.Config {
        private View mContentView = null;
        private int mContentViewId = -1;
        private boolean mRemoveOthers = true;
        private long mDuration = 3000L;
        private float mAlpha = 1.0f;
        private int mGravity = 81;
        private Integer mMarginLeft = null;
        private Integer mMarginTop = null;
        private Integer mMarginRight = null;
        private Integer mMarginBottom = null;

        protected Config() {
        }
    }

    public static class ViewHolder
    extends DecorLayer.ViewHolder {
        private View mContent;

        @NonNull
        public FrameLayout getChild() {
            return (FrameLayout)super.getChild();
        }

        protected void setContent(@Nullable View content) {
            this.mContent = content;
        }

        @NonNull
        public View getContent() {
            Utils.requireNonNull((Object)this.mContent, (String)"\u5fc5\u987b\u5728show\u65b9\u6cd5\u540e\u8c03\u7528");
            return this.mContent;
        }
    }

    private class DismissRunnable
    implements Runnable {
        private DismissRunnable() {
        }

        @Override
        public void run() {
            if (ToastLayer.this.isShown()) {
                ToastLayer.this.dismiss();
            }
        }
    }
}

