/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.visualeffect.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import per.goweii.visualeffect.core.ParcelableVisualEffect;
import per.goweii.visualeffect.core.VisualEffect;
import per.goweii.visualeffect.view.ContextExtKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003JKLB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\tH\u0002J\u0006\u00109\u001a\u000205J\b\u0010:\u001a\u000205H\u0002J\b\u0010;\u001a\u000205H\u0002J\u000e\u0010<\u001a\u0002052\u0006\u00107\u001a\u00020\u0007J\u0010\u0010=\u001a\u0002052\u0006\u00107\u001a\u00020\u0007H\u0002J\u0018\u0010>\u001a\u0002052\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\tH\u0002J&\u0010?\u001a\u0002052\b\u0010@\u001a\u0004\u0018\u00010A2\u0014\u0010B\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010A\u0012\u0004\u0012\u0002050CJ\u0016\u0010D\u001a\u00020A2\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010A0EJ\b\u0010F\u001a\u000205H\u0002J\b\u0010G\u001a\u000205H\u0002J\b\u0010H\u001a\u000205H\u0002J\b\u0010I\u001a\u000205H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00060&R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u0010\u001a\u0004\u0018\u00010.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006M"}, d2={"Lper/goweii/visualeffect/view/BackdropVisualEffectHelper;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "activityDecorView", "bitmapCanvas", "Landroid/graphics/Canvas;", "cacheBitmap", "Landroid/graphics/Bitmap;", "dstRect", "Landroid/graphics/Rect;", "isDifferentRoot", "", "isRendering", "()Z", "value", "isShowDebugInfo", "setShowDebugInfo", "(Z)V", "locations", "", "", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "paint", "Landroid/graphics/Paint;", "realScaleXY", "", "getRealScaleXY", "()[F", "renderEndTime", "", "renderStartTime", "renderingListener", "Lper/goweii/visualeffect/view/BackdropVisualEffectHelper$RenderingListener;", "", "simpleSize", "getSimpleSize", "()F", "setSimpleSize", "(F)V", "srcRect", "Lper/goweii/visualeffect/core/VisualEffect;", "visualEffect", "getVisualEffect", "()Lper/goweii/visualeffect/core/VisualEffect;", "setVisualEffect", "(Lper/goweii/visualeffect/core/VisualEffect;)V", "captureToBitmap", "", "decor", "canvas", "bitmap", "checkRendering", "onAttachedToWindow", "onDetachedFromWindow", "onDraw", "onDrawDebugInfo", "onDrawEffectedBitmap", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "callSuper", "Lkotlin/Function1;", "onSaveInstanceState", "Lkotlin/Function0;", "prepare", "registerRenderingListener", "renderOnce", "unregisterRenderingListener", "RenderingListener", "SavedState", "StopException", "visualeffect-view_release"})
public final class BackdropVisualEffectHelper {
    private Canvas bitmapCanvas;
    private Bitmap cacheBitmap;
    private View activityDecorView;
    private boolean isDifferentRoot;
    private final RenderingListener renderingListener;
    private final int[] locations;
    private final Rect srcRect;
    private final Rect dstRect;
    private final Paint paint;
    private final float[] realScaleXY;
    private long renderStartTime;
    private long renderEndTime;
    private int overlayColor;
    @Nullable
    private VisualEffect visualEffect;
    private float simpleSize;
    private boolean isShowDebugInfo;
    private final View view;

    private final float[] getRealScaleXY() {
        this.realScaleXY[0] = this.view.getScaleX();
        this.realScaleXY[1] = this.view.getScaleY();
        ViewParent viewParent = this.view.getParent();
        if (!(viewParent instanceof ViewGroup)) {
            viewParent = null;
        }
        ViewGroup viewGroup = (ViewGroup)viewParent;
        while (viewGroup != null) {
            this.realScaleXY[0] = this.realScaleXY[0] * viewGroup.getScaleX();
            this.realScaleXY[1] = this.realScaleXY[1] * viewGroup.getScaleY();
            ViewParent viewParent2 = viewGroup.getParent();
            if (!(viewParent2 instanceof ViewGroup)) {
                viewParent2 = null;
            }
            viewGroup = (ViewGroup)viewParent2;
        }
        return this.realScaleXY;
    }

    public final boolean isRendering() {
        return this.renderEndTime < this.renderStartTime;
    }

    public final int getOverlayColor() {
        return this.overlayColor;
    }

    public final void setOverlayColor(int value) {
        if (this.overlayColor != value) {
            this.overlayColor = value;
            this.view.postInvalidate();
        }
    }

    @Nullable
    public final VisualEffect getVisualEffect() {
        return this.visualEffect;
    }

    public final void setVisualEffect(@Nullable VisualEffect value) {
        if (Intrinsics.areEqual((Object)this.visualEffect, (Object)value) ^ true) {
            VisualEffect visualEffect = this.visualEffect;
            if (visualEffect != null) {
                visualEffect.recycle();
            }
            this.visualEffect = value;
            this.view.postInvalidate();
        }
    }

    public final float getSimpleSize() {
        return this.simpleSize;
    }

    public final void setSimpleSize(float value) {
        if (this.simpleSize != value) {
            float f = 1.0f;
            boolean bl = false;
            this.simpleSize = Math.max(f, value);
            this.view.postInvalidate();
        }
    }

    public final boolean isShowDebugInfo() {
        return this.isShowDebugInfo;
    }

    public final void setShowDebugInfo(boolean value) {
        if (this.isShowDebugInfo != value) {
            this.isShowDebugInfo = value;
            this.view.postInvalidate();
        }
    }

    public final void checkRendering() {
        if (this.isRendering()) {
            throw (Throwable)StopException.INSTANCE;
        }
    }

    public final void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.checkRendering();
        Bitmap bitmap = this.cacheBitmap;
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap2;
            boolean bl3 = false;
            this.onDrawEffectedBitmap(canvas, it);
        }
        canvas.drawColor(this.overlayColor);
        if (this.isShowDebugInfo) {
            this.onDrawDebugInfo(canvas);
        }
    }

    public final void onRestoreInstanceState(@Nullable Parcelable state, @NotNull Function1<? super Parcelable, Unit> callSuper) {
        Intrinsics.checkNotNullParameter(callSuper, (String)"callSuper");
        if (!(state instanceof SavedState)) {
            callSuper.invoke((Object)state);
            return;
        }
        callSuper.invoke((Object)((SavedState)state).getSuperState());
        this.setShowDebugInfo(((SavedState)state).isShowDebugInfo());
        this.setSimpleSize(((SavedState)state).getSimpleSize());
        this.setOverlayColor(((SavedState)state).getOverlayColor());
        this.setVisualEffect((VisualEffect)((SavedState)state).getVisualEffect());
    }

    @NotNull
    public final Parcelable onSaveInstanceState(@NotNull Function0<? extends Parcelable> callSuper) {
        Parcelable superState;
        Intrinsics.checkNotNullParameter(callSuper, (String)"callSuper");
        Parcelable parcelable = (Parcelable)callSuper.invoke();
        if (parcelable == null) {
            parcelable = (Parcelable)View.BaseSavedState.EMPTY_STATE;
        }
        Parcelable parcelable2 = superState = parcelable;
        Intrinsics.checkNotNullExpressionValue((Object)parcelable2, (String)"superState");
        VisualEffect visualEffect = this.visualEffect;
        if (!(visualEffect instanceof ParcelableVisualEffect)) {
            visualEffect = null;
        }
        return (Parcelable)new SavedState(parcelable2, this.isShowDebugInfo, this.simpleSize, this.overlayColor, (ParcelableVisualEffect)visualEffect);
    }

    private final void onAttachedToWindow() {
        Activity it;
        boolean bl;
        boolean bl2;
        Activity activity;
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Activity activity2 = ContextExtKt.getActivity(context);
        if (activity2 != null) {
            activity = activity2;
            bl2 = false;
            bl = false;
            it = activity;
            boolean bl3 = false;
            Window window = it.getWindow();
            this.activityDecorView = window != null ? window.getDecorView() : null;
        }
        this.registerRenderingListener();
        View view = this.activityDecorView;
        if (view != null) {
            activity = view;
            bl2 = false;
            bl = false;
            it = activity;
            boolean bl4 = false;
            boolean bl5 = this.isDifferentRoot = it.getRootView() != this.view.getRootView();
            if (this.isDifferentRoot) {
                it.postInvalidate();
            }
        } else {
            boolean bl6 = false;
            bl2 = false;
            boolean bl7 = false;
            this.isDifferentRoot = false;
        }
    }

    private final void onDetachedFromWindow() {
        block0: {
            this.unregisterRenderingListener();
            VisualEffect visualEffect = this.visualEffect;
            if (visualEffect == null) break block0;
            visualEffect.recycle();
        }
    }

    private final void registerRenderingListener() {
        block2: {
            View view = this.activityDecorView;
            if (view == null) break block2;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            ViewTreeObserver viewTreeObserver = it.getViewTreeObserver();
            Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"it.viewTreeObserver");
            if (viewTreeObserver.isAlive()) {
                it.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.renderingListener);
            }
            boolean bl4 = this.isDifferentRoot = it.getRootView() != this.view.getRootView();
            if (this.isDifferentRoot) {
                it.postInvalidate();
            }
        }
    }

    private final void unregisterRenderingListener() {
        block1: {
            View view = this.activityDecorView;
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            ViewTreeObserver viewTreeObserver = it.getViewTreeObserver();
            Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"it.viewTreeObserver");
            if (viewTreeObserver.isAlive()) {
                it.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.renderingListener);
            }
        }
    }

    private final void prepare() {
        block7: {
            Bitmap bitmap;
            BackdropVisualEffectHelper backdropVisualEffectHelper;
            int simpledHeight;
            int simpledWidth;
            block8: {
                block6: {
                    simpledWidth = (int)((float)this.view.getWidth() / this.simpleSize);
                    simpledHeight = (int)((float)this.view.getHeight() / this.simpleSize);
                    if (simpledWidth > 0 && simpledHeight > 0) break block6;
                    this.bitmapCanvas = null;
                    this.cacheBitmap = null;
                    break block7;
                }
                if (this.cacheBitmap == null) break block8;
                Bitmap bitmap2 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                if (bitmap2.getWidth() != simpledWidth) break block8;
                Bitmap bitmap3 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap3);
                if (bitmap3.getHeight() == simpledHeight) break block7;
            }
            BackdropVisualEffectHelper backdropVisualEffectHelper2 = this;
            try {
                backdropVisualEffectHelper = backdropVisualEffectHelper2;
                bitmap = Bitmap.createBitmap((int)simpledWidth, (int)simpledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                backdropVisualEffectHelper = backdropVisualEffectHelper2;
                Runtime.getRuntime().gc();
                bitmap = null;
            }
            backdropVisualEffectHelper.cacheBitmap = bitmap;
            if (this.cacheBitmap != null) {
                if (this.bitmapCanvas == null) {
                    this.bitmapCanvas = new Canvas();
                }
                Canvas canvas = this.bitmapCanvas;
                Intrinsics.checkNotNull((Object)canvas);
                canvas.setBitmap(this.cacheBitmap);
            } else {
                this.bitmapCanvas = null;
            }
        }
    }

    private final void renderOnce() {
        VisualEffect visualEffect = this.visualEffect;
        if (visualEffect == null) {
            return;
        }
        VisualEffect visualEffect2 = visualEffect;
        if (!this.view.isShown()) {
            return;
        }
        View view = this.activityDecorView;
        if (view == null) {
            return;
        }
        View decor = view;
        if (!decor.isDirty()) {
            return;
        }
        this.prepare();
        Canvas canvas = this.bitmapCanvas;
        if (canvas == null) {
            return;
        }
        Canvas canvas2 = canvas;
        Bitmap bitmap = this.cacheBitmap;
        if (bitmap == null) {
            return;
        }
        Bitmap bitmap2 = bitmap;
        this.renderStartTime = System.nanoTime();
        bitmap2.eraseColor(0);
        this.captureToBitmap(decor, canvas2, bitmap2);
        visualEffect2.process(bitmap2, bitmap2);
        this.renderEndTime = System.nanoTime();
        this.view.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void captureToBitmap(View decor, Canvas canvas, Bitmap bitmap) {
        int restoreCount = canvas.save();
        try {
            decor.getLocationOnScreen(this.locations);
            int x = -this.locations[0];
            int y = -this.locations[1];
            this.view.getLocationOnScreen(this.locations);
            float[] realScaleXX = this.getRealScaleXY();
            float vw = (float)this.view.getWidth() * realScaleXX[0];
            float vh = (float)this.view.getHeight() * realScaleXX[1];
            canvas.scale((float)bitmap.getWidth() / vw, (float)bitmap.getHeight() / vh);
            canvas.translate(-((float)(x += this.locations[0])), -((float)(y += this.locations[1])));
            Drawable drawable = decor.getBackground();
            if (drawable != null) {
                drawable.draw(canvas);
            }
            decor.draw(canvas);
        }
        catch (StopException stopException) {
        }
        finally {
            canvas.restoreToCount(restoreCount);
        }
    }

    private final void onDrawEffectedBitmap(Canvas canvas, Bitmap bitmap) {
        this.paint.setColor(-1);
        this.srcRect.right = bitmap.getWidth();
        this.srcRect.bottom = bitmap.getHeight();
        this.dstRect.right = this.view.getWidth();
        this.dstRect.bottom = this.view.getHeight();
        canvas.drawBitmap(bitmap, this.srcRect, this.dstRect, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDrawDebugInfo(Canvas canvas) {
        void $this$apply;
        void $this$apply2;
        float textBaseLine = 0.0f;
        double costTime = (double)(this.renderEndTime - this.renderStartTime) / (double)1000000;
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        NumberFormat it = numberFormat;
        boolean bl3 = false;
        NumberFormat numberFormat2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat2, (String)"it");
        numberFormat2.setGroupingUsed(false);
        it.setMinimumFractionDigits(3);
        it.setMaximumFractionDigits(3);
        String costText = it.format(costTime);
        numberFormat = this.paint;
        bl = false;
        bl2 = false;
        it = numberFormat;
        float f = textBaseLine += -this.paint.getFontMetrics().ascent;
        float f2 = (float)this.view.getWidth() - this.paint.measureText(costText);
        String string = costText;
        Canvas canvas2 = canvas;
        boolean $i$a$-apply-BackdropVisualEffectHelper$onDrawDebugInfo$32 = false;
        $this$apply2.setColor(costTime > (double)16.6f ? -65536 : -16777216);
        Unit unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, (Paint)numberFormat);
        Bitmap bitmap = this.cacheBitmap;
        Bitmap bitmap2 = this.cacheBitmap;
        String bmpSizeText = "" + (bitmap != null ? bitmap.getWidth() : 0) + '*' + (bitmap2 != null ? bitmap2.getHeight() : 0);
        Paint paint = this.paint;
        bl2 = false;
        boolean bl4 = false;
        Paint $i$a$-apply-BackdropVisualEffectHelper$onDrawDebugInfo$32 = paint;
        f = textBaseLine += -this.paint.getFontMetrics().ascent;
        f2 = (float)this.view.getWidth() - this.paint.measureText(bmpSizeText);
        string = bmpSizeText;
        canvas2 = canvas;
        boolean bl5 = false;
        $this$apply.setColor(-16777216);
        unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, paint);
    }

    /*
     * WARNING - void declaration
     */
    public BackdropVisualEffectHelper(@NotNull View view) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.renderingListener = new RenderingListener();
        this.locations = new int[2];
        this.srcRect = new Rect();
        this.dstRect = new Rect();
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        BackdropVisualEffectHelper backdropVisualEffectHelper = this;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setTypeface(Typeface.MONOSPACE);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.context.resources");
        $this$apply.setTextSize(TypedValue.applyDimension((int)2, (float)9.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        Unit unit = Unit.INSTANCE;
        backdropVisualEffectHelper.paint = paint;
        this.realScaleXY = new float[]{1.0f, 1.0f};
        this.simpleSize = 1.0f;
        this.view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.onAttachedToWindow();
            }

            public void onViewDetachedFromWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.onDetachedFromWindow();
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lper/goweii/visualeffect/view/BackdropVisualEffectHelper$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "isShowDebugInfo", "", "simpleSize", "", "overlayColor", "", "visualEffect", "Lper/goweii/visualeffect/core/ParcelableVisualEffect;", "(Landroid/os/Parcelable;ZFILper/goweii/visualeffect/core/ParcelableVisualEffect;)V", "()Z", "getOverlayColor", "()I", "getSimpleSize", "()F", "getVisualEffect", "()Lper/goweii/visualeffect/core/ParcelableVisualEffect;", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "visualeffect-view_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        private final boolean isShowDebugInfo;
        private final float simpleSize;
        private final int overlayColor;
        @Nullable
        private final ParcelableVisualEffect visualEffect;

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isShowDebugInfo ? 1 : 0);
            dest.writeFloat(this.simpleSize);
            dest.writeInt(this.overlayColor);
            dest.writeParcelable((Parcelable)this.visualEffect, 0);
        }

        public final boolean isShowDebugInfo() {
            return this.isShowDebugInfo;
        }

        public final float getSimpleSize() {
            return this.simpleSize;
        }

        public final int getOverlayColor() {
            return this.overlayColor;
        }

        @Nullable
        public final ParcelableVisualEffect getVisualEffect() {
            return this.visualEffect;
        }

        public SavedState(@NotNull Parcelable superState, boolean isShowDebugInfo, float simpleSize, int overlayColor, @Nullable ParcelableVisualEffect visualEffect) {
            Intrinsics.checkNotNullParameter((Object)superState, (String)"superState");
            super(superState);
            this.isShowDebugInfo = isShowDebugInfo;
            this.simpleSize = simpleSize;
            this.overlayColor = overlayColor;
            this.visualEffect = visualEffect;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lper/goweii/visualeffect/view/BackdropVisualEffectHelper$RenderingListener;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "(Lper/goweii/visualeffect/view/BackdropVisualEffectHelper;)V", "onPreDraw", "", "visualeffect-view_release"})
    private final class RenderingListener
    implements ViewTreeObserver.OnPreDrawListener {
        public boolean onPreDraw() {
            BackdropVisualEffectHelper.this.renderOnce();
            return true;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lper/goweii/visualeffect/view/BackdropVisualEffectHelper$StopException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "visualeffect-view_release"})
    private static final class StopException
    extends RuntimeException {
        @NotNull
        public static final StopException INSTANCE;

        private StopException() {
        }

        static {
            StopException stopException;
            INSTANCE = stopException = new StopException();
        }
    }
}

