/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.visualeffect.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import per.goweii.visualeffect.core.ParcelableVisualEffect;
import per.goweii.visualeffect.core.VisualEffect;
import per.goweii.visualeffect.view.ChildrenVisualEffectHelper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0013\u0018\u00002\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020(0+J\u0010\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0018\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\bH\u0002J&\u0010/\u001a\u00020(2\b\u00100\u001a\u0004\u0018\u0001012\u0014\u0010*\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000101\u0012\u0004\u0012\u00020(0+J\u0016\u00102\u001a\u0002012\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010103J\b\u00104\u001a\u00020(H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR$\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u000e\u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00066"}, d2={"Lper/goweii/visualeffect/view/ChildrenVisualEffectHelper;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "bitmapCanvas", "Landroid/graphics/Canvas;", "cacheBitmap", "Landroid/graphics/Bitmap;", "dstRect", "Landroid/graphics/Rect;", "isRendering", "", "()Z", "value", "isShowDebugInfo", "setShowDebugInfo", "(Z)V", "onAttachStateChangeListener", "per/goweii/visualeffect/view/ChildrenVisualEffectHelper$onAttachStateChangeListener$1", "Lper/goweii/visualeffect/view/ChildrenVisualEffectHelper$onAttachStateChangeListener$1;", "paint", "Landroid/graphics/Paint;", "renderEndTime", "", "renderStartTime", "", "simpleSize", "getSimpleSize", "()F", "setSimpleSize", "(F)V", "srcRect", "Lper/goweii/visualeffect/core/VisualEffect;", "visualEffect", "getVisualEffect", "()Lper/goweii/visualeffect/core/VisualEffect;", "setVisualEffect", "(Lper/goweii/visualeffect/core/VisualEffect;)V", "draw", "", "canvas", "callSuper", "Lkotlin/Function1;", "onDrawDebugInfo", "onDrawEffectedBitmap", "bitmap", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "Lkotlin/Function0;", "prepare", "SavedState", "visualeffect-view_release"})
public final class ChildrenVisualEffectHelper {
    private Canvas bitmapCanvas;
    private Bitmap cacheBitmap;
    private final Paint paint;
    private final Rect srcRect;
    private final Rect dstRect;
    private long renderStartTime;
    private long renderEndTime;
    @Nullable
    private VisualEffect visualEffect;
    private float simpleSize;
    private boolean isShowDebugInfo;
    private final onAttachStateChangeListener.1 onAttachStateChangeListener;
    private final View view;

    @Nullable
    public final VisualEffect getVisualEffect() {
        return this.visualEffect;
    }

    public final void setVisualEffect(@Nullable VisualEffect value) {
        if (Intrinsics.areEqual((Object)this.visualEffect, (Object)value) ^ true) {
            VisualEffect visualEffect = this.visualEffect;
            if (visualEffect != null) {
                visualEffect.recycle();
            }
            this.visualEffect = value;
            this.view.postInvalidate();
        }
    }

    public final float getSimpleSize() {
        return this.simpleSize;
    }

    public final void setSimpleSize(float value) {
        if (this.simpleSize != value) {
            float f = 1.0f;
            boolean bl = false;
            this.simpleSize = Math.max(f, value);
            this.view.postInvalidate();
        }
    }

    public final boolean isShowDebugInfo() {
        return this.isShowDebugInfo;
    }

    public final void setShowDebugInfo(boolean value) {
        if (this.isShowDebugInfo != value) {
            this.isShowDebugInfo = value;
            this.view.postInvalidate();
        }
    }

    public final boolean isRendering() {
        return this.renderEndTime < this.renderStartTime;
    }

    public final void draw(@NotNull Canvas canvas, @NotNull Function1<? super Canvas, Unit> callSuper) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter(callSuper, (String)"callSuper");
        VisualEffect visualEffect = this.visualEffect;
        if (visualEffect == null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            callSuper.invoke((Object)canvas);
            return;
        }
        VisualEffect visualEffect2 = visualEffect;
        this.prepare();
        Canvas canvas2 = this.bitmapCanvas;
        if (canvas2 == null) {
            return;
        }
        Canvas bitmapCanvas = canvas2;
        Bitmap bitmap = this.cacheBitmap;
        if (bitmap == null) {
            return;
        }
        Bitmap cacheBitmap = bitmap;
        this.renderStartTime = System.nanoTime();
        int restoreCount = bitmapCanvas.save();
        bitmapCanvas.drawColor(0);
        bitmapCanvas.scale((float)cacheBitmap.getWidth() / (float)this.view.getWidth(), (float)cacheBitmap.getHeight() / (float)this.view.getHeight());
        callSuper.invoke((Object)bitmapCanvas);
        bitmapCanvas.restoreToCount(restoreCount);
        visualEffect2.process(cacheBitmap, cacheBitmap);
        this.renderEndTime = System.nanoTime();
        this.onDrawEffectedBitmap(canvas, cacheBitmap);
        if (this.isShowDebugInfo) {
            this.onDrawDebugInfo(canvas);
        }
    }

    public final void onRestoreInstanceState(@Nullable Parcelable state, @NotNull Function1<? super Parcelable, Unit> callSuper) {
        Intrinsics.checkNotNullParameter(callSuper, (String)"callSuper");
        if (!(state instanceof SavedState)) {
            callSuper.invoke((Object)state);
            return;
        }
        callSuper.invoke((Object)((SavedState)state).getSuperState());
        this.setShowDebugInfo(((SavedState)state).isShowDebugInfo());
        this.setSimpleSize(((SavedState)state).getSimpleSize());
        this.setVisualEffect((VisualEffect)((SavedState)state).getVisualEffect());
    }

    @NotNull
    public final Parcelable onSaveInstanceState(@NotNull Function0<? extends Parcelable> callSuper) {
        Parcelable superState;
        Intrinsics.checkNotNullParameter(callSuper, (String)"callSuper");
        Parcelable parcelable = (Parcelable)callSuper.invoke();
        if (parcelable == null) {
            parcelable = (Parcelable)View.BaseSavedState.EMPTY_STATE;
        }
        Parcelable parcelable2 = superState = parcelable;
        Intrinsics.checkNotNullExpressionValue((Object)parcelable2, (String)"superState");
        VisualEffect visualEffect = this.visualEffect;
        if (!(visualEffect instanceof ParcelableVisualEffect)) {
            visualEffect = null;
        }
        return (Parcelable)new SavedState(parcelable2, this.isShowDebugInfo, this.simpleSize, (ParcelableVisualEffect)visualEffect);
    }

    private final void prepare() {
        block7: {
            Bitmap bitmap;
            ChildrenVisualEffectHelper childrenVisualEffectHelper;
            int simpledHeight;
            int simpledWidth;
            block8: {
                block6: {
                    simpledWidth = (int)((float)this.view.getWidth() / this.simpleSize);
                    simpledHeight = (int)((float)this.view.getHeight() / this.simpleSize);
                    if (simpledWidth > 0 && simpledHeight > 0) break block6;
                    this.bitmapCanvas = null;
                    this.cacheBitmap = null;
                    break block7;
                }
                if (this.cacheBitmap == null) break block8;
                Bitmap bitmap2 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                if (bitmap2.getWidth() != simpledWidth) break block8;
                Bitmap bitmap3 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap3);
                if (bitmap3.getHeight() == simpledHeight) break block7;
            }
            ChildrenVisualEffectHelper childrenVisualEffectHelper2 = this;
            try {
                childrenVisualEffectHelper = childrenVisualEffectHelper2;
                bitmap = Bitmap.createBitmap((int)simpledWidth, (int)simpledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                childrenVisualEffectHelper = childrenVisualEffectHelper2;
                Runtime.getRuntime().gc();
                bitmap = null;
            }
            childrenVisualEffectHelper.cacheBitmap = bitmap;
            if (this.cacheBitmap != null) {
                if (this.bitmapCanvas == null) {
                    this.bitmapCanvas = new Canvas();
                }
                Canvas canvas = this.bitmapCanvas;
                Intrinsics.checkNotNull((Object)canvas);
                canvas.setBitmap(this.cacheBitmap);
            } else {
                this.bitmapCanvas = null;
            }
        }
    }

    private final void onDrawEffectedBitmap(Canvas canvas, Bitmap bitmap) {
        this.paint.setColor(-1);
        this.srcRect.right = bitmap.getWidth();
        this.srcRect.bottom = bitmap.getHeight();
        this.dstRect.right = this.view.getWidth();
        this.dstRect.bottom = this.view.getHeight();
        canvas.drawBitmap(bitmap, this.srcRect, this.dstRect, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDrawDebugInfo(Canvas canvas) {
        void $this$apply;
        void $this$apply2;
        float textBaseLine = 0.0f;
        double costTime = (double)(this.renderEndTime - this.renderStartTime) / (double)1000000;
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        NumberFormat it = numberFormat;
        boolean bl3 = false;
        NumberFormat numberFormat2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat2, (String)"it");
        numberFormat2.setGroupingUsed(false);
        it.setMinimumFractionDigits(3);
        it.setMaximumFractionDigits(3);
        String costText = it.format(costTime);
        numberFormat = this.paint;
        bl = false;
        bl2 = false;
        it = numberFormat;
        float f = textBaseLine += -this.paint.getFontMetrics().ascent;
        float f2 = (float)this.view.getWidth() - this.paint.measureText(costText);
        String string = costText;
        Canvas canvas2 = canvas;
        boolean $i$a$-apply-ChildrenVisualEffectHelper$onDrawDebugInfo$32 = false;
        $this$apply2.setColor(costTime > (double)16.6f ? -65536 : -16777216);
        Unit unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, (Paint)numberFormat);
        Bitmap bitmap = this.cacheBitmap;
        Bitmap bitmap2 = this.cacheBitmap;
        String bmpSizeText = "" + (bitmap != null ? bitmap.getWidth() : 0) + '*' + (bitmap2 != null ? bitmap2.getHeight() : 0);
        Paint paint = this.paint;
        bl2 = false;
        boolean bl4 = false;
        Paint $i$a$-apply-ChildrenVisualEffectHelper$onDrawDebugInfo$32 = paint;
        f = textBaseLine += -this.paint.getFontMetrics().ascent;
        f2 = (float)this.view.getWidth() - this.paint.measureText(bmpSizeText);
        string = bmpSizeText;
        canvas2 = canvas;
        boolean bl5 = false;
        $this$apply.setColor(-16777216);
        unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, paint);
    }

    /*
     * WARNING - void declaration
     */
    public ChildrenVisualEffectHelper(@NotNull View view) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        ChildrenVisualEffectHelper childrenVisualEffectHelper = this;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setTypeface(Typeface.MONOSPACE);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.context.resources");
        $this$apply.setTextSize(TypedValue.applyDimension((int)2, (float)9.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        Unit unit = Unit.INSTANCE;
        childrenVisualEffectHelper.paint = paint;
        this.srcRect = new Rect();
        this.dstRect = new Rect();
        this.simpleSize = 1.0f;
        this.onAttachStateChangeListener = new View.OnAttachStateChangeListener(this){
            final /* synthetic */ ChildrenVisualEffectHelper this$0;

            public void onViewAttachedToWindow(@Nullable View v) {
            }

            public void onViewDetachedFromWindow(@Nullable View v) {
                block0: {
                    VisualEffect visualEffect = this.this$0.getVisualEffect();
                    if (visualEffect == null) break block0;
                    visualEffect.recycle();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeListener);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lper/goweii/visualeffect/view/ChildrenVisualEffectHelper$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "isShowDebugInfo", "", "simpleSize", "", "visualEffect", "Lper/goweii/visualeffect/core/ParcelableVisualEffect;", "(Landroid/os/Parcelable;ZFLper/goweii/visualeffect/core/ParcelableVisualEffect;)V", "()Z", "getSimpleSize", "()F", "getVisualEffect", "()Lper/goweii/visualeffect/core/ParcelableVisualEffect;", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "", "visualeffect-view_release"})
    private static final class SavedState
    extends View.BaseSavedState {
        private final boolean isShowDebugInfo;
        private final float simpleSize;
        @Nullable
        private final ParcelableVisualEffect visualEffect;

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isShowDebugInfo ? 1 : 0);
            dest.writeFloat(this.simpleSize);
            dest.writeParcelable((Parcelable)this.visualEffect, 0);
        }

        public final boolean isShowDebugInfo() {
            return this.isShowDebugInfo;
        }

        public final float getSimpleSize() {
            return this.simpleSize;
        }

        @Nullable
        public final ParcelableVisualEffect getVisualEffect() {
            return this.visualEffect;
        }

        public SavedState(@NotNull Parcelable superState, boolean isShowDebugInfo, float simpleSize, @Nullable ParcelableVisualEffect visualEffect) {
            Intrinsics.checkNotNullParameter((Object)superState, (String)"superState");
            super(superState);
            this.isShowDebugInfo = isShowDebugInfo;
            this.simpleSize = simpleSize;
            this.visualEffect = visualEffect;
        }
    }
}

