/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.visualeffect.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import per.goweii.visualeffect.core.VisualEffect;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\nH\u0014J\u0010\u0010,\u001a\u00020)2\u0006\u0010+\u001a\u00020\nH\u0002J\u0018\u0010-\u001a\u00020)2\u0006\u0010+\u001a\u00020\n2\u0006\u0010.\u001a\u00020\fH\u0002J\b\u0010/\u001a\u00020)H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R$\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lper/goweii/visualeffect/view/VisualEffectImageView;", "Landroid/widget/ImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bitmapCanvas", "Landroid/graphics/Canvas;", "cacheBitmap", "Landroid/graphics/Bitmap;", "dstRect", "Landroid/graphics/Rect;", "isRendering", "", "()Z", "value", "isShowDebugInfo", "setShowDebugInfo", "(Z)V", "paint", "Landroid/graphics/Paint;", "renderEndTime", "", "renderStartTime", "", "simpleSize", "getSimpleSize", "()F", "setSimpleSize", "(F)V", "srcRect", "Lper/goweii/visualeffect/core/VisualEffect;", "visualEffect", "getVisualEffect", "()Lper/goweii/visualeffect/core/VisualEffect;", "setVisualEffect", "(Lper/goweii/visualeffect/core/VisualEffect;)V", "onDetachedFromWindow", "", "onDraw", "canvas", "onDrawDebugInfo", "onDrawEffectedBitmap", "bitmap", "prepare", "visualeffect-view_release"})
public class VisualEffectImageView
extends ImageView {
    private final Canvas bitmapCanvas;
    private Bitmap cacheBitmap;
    private final Rect srcRect;
    private final Rect dstRect;
    private long renderStartTime;
    private long renderEndTime;
    @Nullable
    private VisualEffect visualEffect;
    private float simpleSize;
    private boolean isShowDebugInfo;
    private final Paint paint;

    @Nullable
    public final VisualEffect getVisualEffect() {
        return this.visualEffect;
    }

    public final void setVisualEffect(@Nullable VisualEffect value) {
        if (Intrinsics.areEqual((Object)this.visualEffect, (Object)value) ^ true) {
            VisualEffect visualEffect = this.visualEffect;
            if (visualEffect != null) {
                visualEffect.recycle();
            }
            this.visualEffect = value;
            this.postInvalidate();
        }
    }

    public final float getSimpleSize() {
        return this.simpleSize;
    }

    public final void setSimpleSize(float value) {
        if (this.simpleSize != value) {
            float f = 1.0f;
            boolean bl = false;
            this.simpleSize = Math.max(f, value);
            this.postInvalidate();
        }
    }

    public final boolean isShowDebugInfo() {
        return this.isShowDebugInfo;
    }

    public final void setShowDebugInfo(boolean value) {
        if (this.isShowDebugInfo != value) {
            this.isShowDebugInfo = value;
            this.postInvalidate();
        }
    }

    public final boolean isRendering() {
        return this.renderEndTime < this.renderStartTime;
    }

    protected void onDetachedFromWindow() {
        VisualEffect visualEffect = this.visualEffect;
        if (visualEffect != null) {
            visualEffect.recycle();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        VisualEffect visualEffect = this.visualEffect;
        if (visualEffect == null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            super.onDraw(canvas);
            return;
        }
        VisualEffect visualEffect2 = visualEffect;
        this.prepare();
        Bitmap bitmap = this.cacheBitmap;
        if (bitmap == null) {
            return;
        }
        Bitmap cacheBitmap = bitmap;
        this.renderStartTime = System.nanoTime();
        int restoreCount = this.bitmapCanvas.save();
        this.bitmapCanvas.drawColor(0);
        this.bitmapCanvas.scale((float)cacheBitmap.getWidth() / (float)this.getWidth(), (float)cacheBitmap.getHeight() / (float)this.getHeight());
        super.onDraw(this.bitmapCanvas);
        this.bitmapCanvas.restoreToCount(restoreCount);
        visualEffect2.process(cacheBitmap, cacheBitmap);
        this.renderEndTime = System.nanoTime();
        this.onDrawEffectedBitmap(canvas, cacheBitmap);
        if (this.isShowDebugInfo) {
            this.onDrawDebugInfo(canvas);
        }
    }

    private final void prepare() {
        block4: {
            Bitmap bitmap;
            VisualEffectImageView visualEffectImageView;
            int simpledHeight;
            int simpledWidth;
            block3: {
                simpledWidth = (int)((float)this.getWidth() / this.simpleSize);
                simpledHeight = (int)((float)this.getHeight() / this.simpleSize);
                if (this.cacheBitmap == null) break block3;
                Bitmap bitmap2 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                if (bitmap2.getWidth() != simpledWidth) break block3;
                Bitmap bitmap3 = this.cacheBitmap;
                Intrinsics.checkNotNull((Object)bitmap3);
                if (bitmap3.getHeight() == simpledHeight) break block4;
            }
            VisualEffectImageView visualEffectImageView2 = this;
            try {
                visualEffectImageView = visualEffectImageView2;
                bitmap = Bitmap.createBitmap((int)simpledWidth, (int)simpledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                visualEffectImageView = visualEffectImageView2;
                bitmap = null;
            }
            visualEffectImageView.cacheBitmap = bitmap;
            this.bitmapCanvas.setBitmap(this.cacheBitmap);
        }
    }

    private final void onDrawEffectedBitmap(Canvas canvas, Bitmap bitmap) {
        this.paint.setColor(-1);
        this.srcRect.right = bitmap.getWidth();
        this.srcRect.bottom = bitmap.getHeight();
        this.dstRect.right = this.getWidth();
        this.dstRect.bottom = this.getHeight();
        canvas.drawBitmap(bitmap, this.srcRect, this.dstRect, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDrawDebugInfo(Canvas canvas) {
        void $this$apply;
        void $this$apply2;
        float textBaseLine = 0.0f;
        double costTime = (double)(this.renderEndTime - this.renderStartTime) / (double)1000000;
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        NumberFormat it = numberFormat;
        boolean bl3 = false;
        NumberFormat numberFormat2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat2, (String)"it");
        numberFormat2.setGroupingUsed(false);
        it.setMinimumFractionDigits(3);
        it.setMaximumFractionDigits(3);
        String costText = it.format(costTime);
        numberFormat = this.paint;
        bl = false;
        bl2 = false;
        it = numberFormat;
        float f = textBaseLine += -this.paint.getFontMetrics().ascent;
        float f2 = (float)this.getWidth() - this.paint.measureText(costText);
        String string = costText;
        Canvas canvas2 = canvas;
        boolean $i$a$-apply-VisualEffectImageView$onDrawDebugInfo$32 = false;
        $this$apply2.setColor(costTime > (double)16.6f ? -65536 : -16777216);
        Unit unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, (Paint)numberFormat);
        Bitmap bitmap = this.cacheBitmap;
        Bitmap bitmap2 = this.cacheBitmap;
        String bmpSizeText = "" + (bitmap != null ? bitmap.getWidth() : 0) + '*' + (bitmap2 != null ? bitmap2.getHeight() : 0);
        Paint paint = this.paint;
        bl2 = false;
        boolean bl4 = false;
        Paint $i$a$-apply-VisualEffectImageView$onDrawDebugInfo$32 = paint;
        f = textBaseLine += -this.paint.getFontMetrics().ascent;
        f2 = (float)this.getWidth() - this.paint.measureText(bmpSizeText);
        string = bmpSizeText;
        canvas2 = canvas;
        boolean bl5 = false;
        $this$apply.setColor(-16777216);
        unit = Unit.INSTANCE;
        canvas2.drawText(string, f2, f, paint);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public VisualEffectImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.bitmapCanvas = new Canvas();
        this.srcRect = new Rect();
        this.dstRect = new Rect();
        this.simpleSize = 1.0f;
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        VisualEffectImageView visualEffectImageView = this;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setTypeface(Typeface.MONOSPACE);
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        $this$apply.setTextSize(TypedValue.applyDimension((int)2, (float)9.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        Unit unit = Unit.INSTANCE;
        visualEffectImageView.paint = paint;
    }

    public /* synthetic */ VisualEffectImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public VisualEffectImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VisualEffectImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

