/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.utility;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.wheelpicker.contract.AddressParser;
import com.github.gzuliyujiang.wheelpicker.entity.CityEntity;
import com.github.gzuliyujiang.wheelpicker.entity.CountyEntity;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddressJsonParser
implements AddressParser {
    private final Builder builder;

    public AddressJsonParser() {
        this(new Builder());
    }

    public AddressJsonParser(Builder builder) {
        this.builder = builder;
    }

    @Override
    @NonNull
    public List<ProvinceEntity> parseData(@NonNull String text) {
        try {
            JSONArray provinceArray = new JSONArray(text);
            return this.parseProvince(provinceArray);
        }
        catch (JSONException e) {
            DialogLog.print((Object)((Object)e));
            return new ArrayList<ProvinceEntity>();
        }
    }

    private List<ProvinceEntity> parseProvince(JSONArray provinceArray) {
        ArrayList<ProvinceEntity> data = new ArrayList<ProvinceEntity>();
        int x = provinceArray.length();
        for (int i = 0; i < x; ++i) {
            ProvinceEntity provinceEntity = new ProvinceEntity();
            JSONObject provinceObject = provinceArray.optJSONObject(i);
            provinceEntity.setCode(provinceObject.optString(this.builder.provinceCodeField));
            provinceEntity.setName(provinceObject.optString(this.builder.provinceNameField));
            provinceEntity.setCityList(new ArrayList<CityEntity>());
            JSONArray cityArray = provinceObject.optJSONArray(this.builder.provinceChildField);
            this.parseCity(provinceEntity, cityArray);
            data.add(provinceEntity);
        }
        return data;
    }

    private void parseCity(ProvinceEntity provinceEntity, JSONArray cityArray) {
        if (cityArray == null || cityArray.length() == 0) {
            return;
        }
        int y = cityArray.length();
        for (int j = 0; j < y; ++j) {
            CityEntity cityEntity = new CityEntity();
            JSONObject cityObject = cityArray.optJSONObject(j);
            cityEntity.setCode(cityObject.optString(this.builder.cityCodeField));
            cityEntity.setName(cityObject.optString(this.builder.cityNameField));
            cityEntity.setCountyList(new ArrayList<CountyEntity>());
            provinceEntity.getCityList().add(cityEntity);
            JSONArray countyArray = cityObject.optJSONArray(this.builder.cityChildField);
            this.parseCounty(cityEntity, countyArray);
        }
    }

    private void parseCounty(CityEntity cityEntity, JSONArray countyArray) {
        if (countyArray == null || countyArray.length() == 0) {
            return;
        }
        int z = countyArray.length();
        for (int k = 0; k < z; ++k) {
            CountyEntity countyEntity = new CountyEntity();
            JSONObject countyObject = countyArray.optJSONObject(k);
            countyEntity.setCode(countyObject.optString(this.builder.countyCodeField));
            countyEntity.setName(countyObject.optString(this.builder.countyNameField));
            cityEntity.getCountyList().add(countyEntity);
        }
    }

    public static class Builder {
        private String provinceCodeField = "code";
        private String provinceNameField = "name";
        private String provinceChildField = "cityList";
        private String cityCodeField = "code";
        private String cityNameField = "name";
        private String cityChildField = "areaList";
        private String countyCodeField = "code";
        private String countyNameField = "name";

        public Builder provinceCodeField(String provinceCodeField) {
            if (TextUtils.isEmpty((CharSequence)provinceCodeField)) {
                return this;
            }
            this.provinceCodeField = provinceCodeField;
            return this;
        }

        public Builder provinceNameField(String provinceNameField) {
            if (TextUtils.isEmpty((CharSequence)provinceNameField)) {
                return this;
            }
            this.provinceNameField = provinceNameField;
            return this;
        }

        public Builder provinceChildField(String provinceChildField) {
            if (TextUtils.isEmpty((CharSequence)provinceChildField)) {
                return this;
            }
            this.provinceChildField = provinceChildField;
            return this;
        }

        public Builder cityCodeField(String cityCodeField) {
            if (TextUtils.isEmpty((CharSequence)cityCodeField)) {
                return this;
            }
            this.cityCodeField = cityCodeField;
            return this;
        }

        public Builder cityNameField(String cityNameField) {
            if (TextUtils.isEmpty((CharSequence)cityNameField)) {
                return this;
            }
            this.cityNameField = cityNameField;
            return this;
        }

        public Builder cityChildField(String cityChildField) {
            if (TextUtils.isEmpty((CharSequence)cityChildField)) {
                return this;
            }
            this.cityChildField = cityChildField;
            return this;
        }

        public Builder countyCodeField(String countyCodeField) {
            if (TextUtils.isEmpty((CharSequence)countyCodeField)) {
                return this;
            }
            this.countyCodeField = countyCodeField;
            return this;
        }

        public Builder countyNameField(String countyNameField) {
            if (TextUtils.isEmpty((CharSequence)countyNameField)) {
                return this;
            }
            this.countyNameField = countyNameField;
            return this;
        }

        public AddressJsonParser build() {
            return new AddressJsonParser(this);
        }
    }
}

