/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.imagepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import com.github.gzuliyujiang.imagepicker.BitmapUtils;
import com.github.gzuliyujiang.imagepicker.CropImageView;
import java.lang.ref.WeakReference;

@SuppressLint(value={"StaticFieldLeak"})
final class BitmapCroppingTask
extends AsyncTask<Void, Void, Result> {
    private final WeakReference<CropImageView> mCropImageViewReference;
    private final Bitmap mBitmap;
    private final Uri mUri;
    private final float[] mCropPoints;
    private final int mDegreesRotated;
    private final int mOrgWidth;
    private final int mOrgHeight;
    private final boolean mFixAspectRatio;
    private final int mAspectRatioX;
    private final int mAspectRatioY;
    private final int mReqWidth;
    private final int mReqHeight;
    private final CropImageView.RequestSizeOptions mReqSizeOptions;
    private final Uri mSaveUri;
    private final Bitmap.CompressFormat mSaveCompressFormat;
    private final int mSaveCompressQuality;

    BitmapCroppingTask(CropImageView cropImageView, Bitmap bitmap, float[] cropPoints, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight, CropImageView.RequestSizeOptions options, Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mBitmap = bitmap;
        this.mCropPoints = cropPoints;
        this.mUri = null;
        this.mDegreesRotated = degreesRotated;
        this.mFixAspectRatio = fixAspectRatio;
        this.mAspectRatioX = aspectRatioX;
        this.mAspectRatioY = aspectRatioY;
        this.mReqWidth = reqWidth;
        this.mReqHeight = reqHeight;
        this.mReqSizeOptions = options;
        this.mSaveUri = saveUri;
        this.mSaveCompressFormat = saveCompressFormat;
        this.mSaveCompressQuality = saveCompressQuality;
        this.mOrgWidth = 0;
        this.mOrgHeight = 0;
    }

    BitmapCroppingTask(CropImageView cropImageView, Uri uri, float[] cropPoints, int degreesRotated, int orgWidth, int orgHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight, CropImageView.RequestSizeOptions options, Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mUri = uri;
        this.mCropPoints = cropPoints;
        this.mDegreesRotated = degreesRotated;
        this.mFixAspectRatio = fixAspectRatio;
        this.mAspectRatioX = aspectRatioX;
        this.mAspectRatioY = aspectRatioY;
        this.mOrgWidth = orgWidth;
        this.mOrgHeight = orgHeight;
        this.mReqWidth = reqWidth;
        this.mReqHeight = reqHeight;
        this.mReqSizeOptions = options;
        this.mSaveUri = saveUri;
        this.mSaveCompressFormat = saveCompressFormat;
        this.mSaveCompressQuality = saveCompressQuality;
        this.mBitmap = null;
    }

    public Uri getUri() {
        return this.mUri;
    }

    protected Result doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                BitmapUtils.BitmapSampled bitmapSampled;
                CropImageView cropImageView = (CropImageView)((Object)this.mCropImageViewReference.get());
                Context mContext = cropImageView.getContext();
                if (this.mUri != null) {
                    bitmapSampled = BitmapUtils.cropBitmap(mContext, this.mUri, this.mCropPoints, this.mDegreesRotated, this.mOrgWidth, this.mOrgHeight, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY, this.mReqWidth, this.mReqHeight);
                } else if (this.mBitmap != null) {
                    bitmapSampled = BitmapUtils.cropBitmapObjectHandleOOM(this.mBitmap, this.mCropPoints, this.mDegreesRotated, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY);
                } else {
                    return new Result((Bitmap)null, 1);
                }
                Bitmap bitmap = BitmapUtils.resizeBitmap(bitmapSampled.bitmap, this.mReqWidth, this.mReqHeight, this.mReqSizeOptions);
                if (this.mSaveUri == null) {
                    return new Result(bitmap, bitmapSampled.sampleSize);
                }
                BitmapUtils.writeBitmapToUri(mContext, bitmap, this.mSaveUri, this.mSaveCompressFormat, this.mSaveCompressQuality);
                bitmap.recycle();
                return new Result(this.mSaveUri, bitmapSampled.sampleSize);
            }
            return null;
        }
        catch (Exception e) {
            return new Result(e, this.mSaveUri != null);
        }
    }

    protected void onPostExecute(Result result) {
        if (result != null) {
            CropImageView cropImageView;
            boolean completeCalled = false;
            if (!this.isCancelled() && (cropImageView = (CropImageView)((Object)this.mCropImageViewReference.get())) != null) {
                completeCalled = true;
                cropImageView.onImageCroppingAsyncComplete(result);
            }
            if (!completeCalled && result.bitmap != null) {
                result.bitmap.recycle();
            }
        }
    }

    static final class Result {
        public final Bitmap bitmap;
        public final Uri uri;
        final Exception error;
        final boolean isSave;
        final int sampleSize;

        Result(Bitmap bitmap, int sampleSize) {
            this.bitmap = bitmap;
            this.uri = null;
            this.error = null;
            this.isSave = false;
            this.sampleSize = sampleSize;
        }

        Result(Uri uri, int sampleSize) {
            this.bitmap = null;
            this.uri = uri;
            this.error = null;
            this.isSave = true;
            this.sampleSize = sampleSize;
        }

        Result(Exception error, boolean isSave) {
            this.bitmap = null;
            this.uri = null;
            this.error = error;
            this.isSave = isSave;
            this.sampleSize = 1;
        }
    }
}

