/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.github.gzuliyujiang.imagepicker.CropImageActivity;
import com.github.gzuliyujiang.imagepicker.CropImageOptions;
import com.github.gzuliyujiang.imagepicker.CropImageView;

public class ActivityBuilder {
    private final Uri mSource;
    private final CropImageOptions mOptions;

    public ActivityBuilder(Uri source) {
        this.mSource = source;
        this.mOptions = new CropImageOptions();
    }

    public Intent getCropIntent(@NonNull Context context) {
        this.mOptions.validate();
        Intent intent = new Intent(context, CropImageActivity.class);
        intent.putExtra("CROP_IMAGE_EXTRA_SOURCE", (Parcelable)this.mSource);
        intent.putExtra("CROP_IMAGE_EXTRA_OPTIONS", (Parcelable)this.mOptions);
        return intent;
    }

    public void start(@NonNull Activity activity) {
        this.mOptions.validate();
        activity.startActivityForResult(this.getCropIntent((Context)activity), 203);
    }

    public void start(@NonNull Fragment fragment) {
        fragment.startActivityForResult(this.getCropIntent((Context)fragment.requireActivity()), 203);
    }

    public ActivityBuilder setCropShape(@NonNull CropImageView.CropShape cropShape) {
        this.mOptions.cropShape = cropShape;
        return this;
    }

    public ActivityBuilder setSnapRadius(float snapRadius) {
        this.mOptions.snapRadius = snapRadius;
        return this;
    }

    public ActivityBuilder setTouchRadius(float touchRadius) {
        this.mOptions.touchRadius = touchRadius;
        return this;
    }

    public ActivityBuilder setGuidelines(@NonNull CropImageView.Guidelines guidelines) {
        this.mOptions.guidelines = guidelines;
        return this;
    }

    public ActivityBuilder setScaleType(@NonNull CropImageView.ScaleType scaleType) {
        this.mOptions.scaleType = scaleType;
        return this;
    }

    public ActivityBuilder setShowCropOverlay(boolean showCropOverlay) {
        this.mOptions.showCropOverlay = showCropOverlay;
        return this;
    }

    public ActivityBuilder setAutoZoomEnabled(boolean autoZoomEnabled) {
        this.mOptions.autoZoomEnabled = autoZoomEnabled;
        return this;
    }

    public ActivityBuilder setMultiTouchEnabled(boolean multiTouchEnabled) {
        this.mOptions.multiTouchEnabled = multiTouchEnabled;
        return this;
    }

    public ActivityBuilder setMaxZoom(int maxZoom) {
        this.mOptions.maxZoom = maxZoom;
        return this;
    }

    public ActivityBuilder setInitialCropWindowPaddingRatio(float initialCropWindowPaddingRatio) {
        this.mOptions.initialCropWindowPaddingRatio = initialCropWindowPaddingRatio;
        return this;
    }

    public ActivityBuilder setFixAspectRatio(boolean fixAspectRatio) {
        this.mOptions.fixAspectRatio = fixAspectRatio;
        return this;
    }

    public ActivityBuilder setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mOptions.aspectRatioX = aspectRatioX;
        this.mOptions.aspectRatioY = aspectRatioY;
        this.mOptions.fixAspectRatio = true;
        return this;
    }

    public ActivityBuilder setBorderLineThickness(float borderLineThickness) {
        this.mOptions.borderLineThickness = borderLineThickness;
        return this;
    }

    public ActivityBuilder setBorderLineColor(int borderLineColor) {
        this.mOptions.borderLineColor = borderLineColor;
        return this;
    }

    public ActivityBuilder setBorderCornerThickness(float borderCornerThickness) {
        this.mOptions.borderCornerThickness = borderCornerThickness;
        return this;
    }

    public ActivityBuilder setBorderCornerOffset(float borderCornerOffset) {
        this.mOptions.borderCornerOffset = borderCornerOffset;
        return this;
    }

    public ActivityBuilder setBorderCornerLength(float borderCornerLength) {
        this.mOptions.borderCornerLength = borderCornerLength;
        return this;
    }

    public ActivityBuilder setBorderCornerColor(int borderCornerColor) {
        this.mOptions.borderCornerColor = borderCornerColor;
        return this;
    }

    public ActivityBuilder setGuidelinesThickness(float guidelinesThickness) {
        this.mOptions.guidelinesThickness = guidelinesThickness;
        return this;
    }

    public ActivityBuilder setGuidelinesColor(int guidelinesColor) {
        this.mOptions.guidelinesColor = guidelinesColor;
        return this;
    }

    public ActivityBuilder setBackgroundColor(int backgroundColor) {
        this.mOptions.backgroundColor = backgroundColor;
        return this;
    }

    public ActivityBuilder setMinCropWindowSize(int minCropWindowWidth, int minCropWindowHeight) {
        this.mOptions.minCropWindowWidth = minCropWindowWidth;
        this.mOptions.minCropWindowHeight = minCropWindowHeight;
        return this;
    }

    public ActivityBuilder setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mOptions.minCropResultWidth = minCropResultWidth;
        this.mOptions.minCropResultHeight = minCropResultHeight;
        return this;
    }

    public ActivityBuilder setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mOptions.maxCropResultWidth = maxCropResultWidth;
        this.mOptions.maxCropResultHeight = maxCropResultHeight;
        return this;
    }

    public ActivityBuilder setOutputUri(Uri outputUri) {
        this.mOptions.outputUri = outputUri;
        return this;
    }

    public ActivityBuilder setOutputCompressFormat(Bitmap.CompressFormat outputCompressFormat) {
        this.mOptions.outputCompressFormat = outputCompressFormat;
        return this;
    }

    public ActivityBuilder setOutputCompressQuality(int outputCompressQuality) {
        this.mOptions.outputCompressQuality = outputCompressQuality;
        return this;
    }

    public ActivityBuilder setRequestedSize(int reqWidth, int reqHeight) {
        return this.setRequestedSize(reqWidth, reqHeight, CropImageView.RequestSizeOptions.RESIZE_INSIDE);
    }

    public ActivityBuilder setRequestedSize(int reqWidth, int reqHeight, CropImageView.RequestSizeOptions options) {
        this.mOptions.outputRequestWidth = reqWidth;
        this.mOptions.outputRequestHeight = reqHeight;
        this.mOptions.outputRequestSizeOptions = options;
        return this;
    }

    public ActivityBuilder setNoOutputImage(boolean noOutputImage) {
        this.mOptions.noOutputImage = noOutputImage;
        return this;
    }

    public ActivityBuilder setInitialCropWindowRectangle(Rect initialCropWindowRectangle) {
        this.mOptions.initialCropWindowRectangle = initialCropWindowRectangle;
        return this;
    }

    public ActivityBuilder setInitialRotation(int initialRotation) {
        this.mOptions.initialRotation = initialRotation;
        return this;
    }

    public ActivityBuilder setAllowRotation(boolean allowRotation) {
        this.mOptions.allowRotation = allowRotation;
        return this;
    }

    public ActivityBuilder setRotationDegrees(int rotationDegrees) {
        this.mOptions.rotationDegrees = rotationDegrees;
        return this;
    }
}

