/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.imagepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.InputStream;

final class HybridityUtils {
    HybridityUtils() {
    }

    public static Intent getCameraIntent(@NonNull Context context) {
        Uri outputFileUri = HybridityUtils.getCaptureImageOutputUri(context);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)HybridityUtils.getIntentUri(context, outputFileUri));
        return intent;
    }

    public static Intent getGalleryIntent() {
        return HybridityUtils.getChooserIntent("image/*");
    }

    public static Intent getChooserIntent(String mime) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType(mime);
        return intent;
    }

    public static Uri getPickImageResultUri(@NonNull Context context, @Nullable Intent data) {
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            isCamera = action != null && action.equals("android.media.action.IMAGE_CAPTURE");
        }
        return isCamera || data.getData() == null ? HybridityUtils.getCaptureImageOutputUri(context) : data.getData();
    }

    public static Uri getCaptureImageOutputUri(@NonNull Context context) {
        Uri outputFileUri = null;
        File getImage = context.getExternalCacheDir();
        if (getImage != null) {
            outputFileUri = Uri.fromFile((File)new File(getImage.getPath(), "pickImageResult.jpeg"));
        }
        return outputFileUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealPathFromUri(Context context, Uri contentUri) {
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            if (cursor == null) {
                String string = "";
                return string;
            }
            int columnIndex = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String string = cursor.getString(columnIndex);
            return string;
        }
    }

    public static boolean isExplicitCameraPermissionRequired(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return HybridityUtils.hasPermissionInManifest(context, "android.permission.CAMERA") && context.checkSelfPermission("android.permission.CAMERA") != 0;
        }
        return false;
    }

    public static boolean hasPermissionInManifest(@NonNull Context context, @NonNull String permissionName) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermisisons = packageInfo.requestedPermissions;
            if (declaredPermisisons != null && declaredPermisisons.length > 0) {
                for (String p : declaredPermisisons) {
                    if (!p.equalsIgnoreCase(permissionName)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isReadExternalStoragePermissionsRequired(@NonNull Context context, @NonNull Uri uri) {
        if (Build.VERSION.SDK_INT >= 23) {
            return HybridityUtils.hasPermissionInManifest(context, "android.permission.READ_EXTERNAL_STORAGE") && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0 && HybridityUtils.isUriRequiresPermissions(context, uri);
        }
        return false;
    }

    public static boolean isUriRequiresPermissions(@NonNull Context context, @NonNull Uri uri) {
        try {
            ContentResolver resolver = context.getContentResolver();
            InputStream stream = resolver.openInputStream(uri);
            if (stream != null) {
                stream.close();
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static Uri getIntentUri(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 24) {
            return HybridityUtils.getContentUri(context, uri);
        }
        return uri;
    }

    public static Uri getContentUri(Context context, Uri fileUri) {
        return FileProvider.getUriForFile((Context)context, (String)(context.getApplicationContext().getPackageName() + ".imagepicker.provider"), (File)new File(fileUri.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealPathFromURI(Context context, Uri contentUri) {
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            if (cursor != null) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                String string = cursor.getString(column_index);
                return string;
            }
            String string = "";
            return string;
        }
    }
}

