/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.imagepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.github.gzuliyujiang.imagepicker.ActivityResult;
import com.github.gzuliyujiang.imagepicker.CropImageOptions;
import com.github.gzuliyujiang.imagepicker.CropImageView;
import com.github.gzuliyujiang.imagepicker.HybridityUtils;
import com.github.gzuliyujiang.imagepicker.R;
import java.io.File;
import java.io.IOException;

public class CropImageActivity
extends FragmentActivity
implements View.OnClickListener,
CropImageView.OnSetImageUriCompleteListener,
CropImageView.OnCropImageCompleteListener {
    private CropImageView mCropImageView;
    private Uri mCropImageUri;
    private CropImageOptions mOptions;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setStatusBarColor(-16777216);
        this.getWindow().setNavigationBarColor(-16777216);
        if (Build.VERSION.SDK_INT >= 28) {
            this.getWindow().setNavigationBarDividerColor(-16777216);
        }
        this.setContentView(R.layout.crop_image_activity);
        this.findViewById(R.id.crop_image_back).setOnClickListener((View.OnClickListener)this);
        View rotateView = this.findViewById(R.id.crop_image_rotate);
        rotateView.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.crop_image_done).setOnClickListener((View.OnClickListener)this);
        this.mCropImageView = (CropImageView)this.findViewById(R.id.crop_image_content);
        Intent intent = this.getIntent();
        this.mCropImageUri = (Uri)intent.getParcelableExtra("CROP_IMAGE_EXTRA_SOURCE");
        this.mOptions = (CropImageOptions)intent.getParcelableExtra("CROP_IMAGE_EXTRA_OPTIONS");
        this.mCropImageView.setCropImageOptions(this.mOptions);
        if (!this.mOptions.allowRotation) {
            rotateView.setVisibility(8);
        }
        if (savedInstanceState == null) {
            if (this.mCropImageUri == null || this.mCropImageUri.equals((Object)Uri.EMPTY)) {
                if (Build.VERSION.SDK_INT >= 23 && HybridityUtils.isExplicitCameraPermissionRequired((Context)this)) {
                    this.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
                } else {
                    this.startCamera();
                }
            } else if (Build.VERSION.SDK_INT >= 23 && HybridityUtils.isReadExternalStoragePermissionsRequired((Context)this, this.mCropImageUri)) {
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
            } else {
                this.mCropImageView.setImageUriAsync(this.mCropImageUri);
            }
        }
    }

    private void startCamera() {
        this.startActivityForResult(HybridityUtils.getCameraIntent((Context)this), 200);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.crop_image_back) {
            this.setResultCancel();
        } else if (id2 == R.id.crop_image_rotate) {
            this.rotateImage(this.mOptions.rotationDegrees);
        } else if (id2 == R.id.crop_image_done) {
            this.cropImage();
        }
    }

    protected void onStart() {
        super.onStart();
        this.mCropImageView.setOnSetImageUriCompleteListener(this);
        this.mCropImageView.setOnCropImageCompleteListener(this);
    }

    protected void onStop() {
        super.onStop();
        this.mCropImageView.setOnSetImageUriCompleteListener(null);
        this.mCropImageView.setOnCropImageCompleteListener(null);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResultCancel();
    }

    @SuppressLint(value={"NewApi"})
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 200) {
            if (resultCode == 0) {
                this.setResultCancel();
            }
            if (resultCode == -1) {
                this.mCropImageUri = HybridityUtils.getPickImageResultUri((Context)this, data);
                if (HybridityUtils.isReadExternalStoragePermissionsRequired((Context)this, this.mCropImageUri)) {
                    this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
                } else {
                    this.mCropImageView.setImageUriAsync(this.mCropImageUri);
                }
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 201) {
            if (this.mCropImageUri != null && grantResults.length > 0 && grantResults[0] == 0) {
                this.mCropImageView.setImageUriAsync(this.mCropImageUri);
            } else {
                this.setResultCancel();
            }
        } else if (requestCode == 2011) {
            this.startCamera();
        }
    }

    @Override
    public void onSetImageUriComplete(CropImageView view, Uri uri, Exception error) {
        if (error == null) {
            if (this.mOptions.initialCropWindowRectangle != null) {
                this.mCropImageView.setCropRect(this.mOptions.initialCropWindowRectangle);
            }
            if (this.mOptions.initialRotation > -1) {
                this.mCropImageView.setRotatedDegrees(this.mOptions.initialRotation);
            }
        } else {
            this.setResult(null, error, 1);
        }
    }

    @Override
    public void onCropImageComplete(CropImageView view, CropImageView.CropResult result) {
        this.setResult(result.getUri(), result.getError(), result.getSampleSize());
    }

    protected void cropImage() {
        if (this.mOptions.noOutputImage) {
            this.setResult(null, null, 1);
        } else {
            Uri outputUri = this.getOutputUri();
            this.mCropImageView.saveCroppedImageAsync(outputUri, this.mOptions.outputCompressFormat, this.mOptions.outputCompressQuality, this.mOptions.outputRequestWidth, this.mOptions.outputRequestHeight, this.mOptions.outputRequestSizeOptions);
        }
    }

    protected void rotateImage(int degrees) {
        this.mCropImageView.rotateImage(degrees);
    }

    protected Uri getOutputUri() {
        Uri outputUri = this.mOptions.outputUri;
        if (outputUri.equals((Object)Uri.EMPTY)) {
            try {
                String ext = this.mOptions.outputCompressFormat == Bitmap.CompressFormat.JPEG ? ".jpg" : (this.mOptions.outputCompressFormat == Bitmap.CompressFormat.PNG ? ".png" : ".webp");
                outputUri = Uri.fromFile((File)File.createTempFile("cropped", ext, this.getCacheDir()));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temp file for output image", e);
            }
        }
        return outputUri;
    }

    protected void setResult(Uri uri, Exception error, int sampleSize) {
        int resultCode = error == null ? -1 : 204;
        this.setResult(resultCode, this.getResultIntent(uri, error, sampleSize));
        this.finish();
    }

    protected void setResultCancel() {
        this.setResult(0);
        this.finish();
    }

    protected Intent getResultIntent(Uri uri, Exception error, int sampleSize) {
        ActivityResult result = new ActivityResult(null, uri, error, this.mCropImageView.getCropPoints(), this.mCropImageView.getCropRect(), this.mCropImageView.getRotatedDegrees(), sampleSize);
        Intent intent = new Intent();
        intent.putExtra("CROP_IMAGE_EXTRA_RESULT", (Parcelable)result);
        return intent;
    }

    private void updateMenuItemIconColor(Menu menu, int itemId, int color) {
        Drawable menuItemIcon;
        MenuItem menuItem = menu.findItem(itemId);
        if (menuItem != null && (menuItemIcon = menuItem.getIcon()) != null) {
            try {
                menuItemIcon.mutate();
                menuItemIcon.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
                menuItem.setIcon(menuItemIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

