/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.github.gzuliyujiang.imagepicker.ActivityBuilder;
import com.github.gzuliyujiang.imagepicker.ActivityResult;
import com.github.gzuliyujiang.imagepicker.CropImageView;
import com.github.gzuliyujiang.imagepicker.HybridityUtils;
import com.github.gzuliyujiang.imagepicker.PickCallback;
import java.io.File;

public class ImagePicker {
    private Uri cropImageUri;
    private boolean cropEnabled = true;
    private PickCallback callback;

    public static ImagePicker getInstance() {
        return Holder.INSTANCE;
    }

    private ImagePicker() {
    }

    public void startCamera(Activity activity, boolean cropEnabled, @NonNull PickCallback callback) {
        this.cropEnabled = cropEnabled;
        this.callback = callback;
        if (HybridityUtils.isExplicitCameraPermissionRequired((Context)activity)) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.CAMERA"}, (int)2011);
        } else {
            activity.startActivityForResult(HybridityUtils.getCameraIntent((Context)activity), 200);
        }
    }

    public void startCamera(Fragment fragment, boolean cropEnabled, @NonNull PickCallback callback) {
        this.cropEnabled = cropEnabled;
        this.callback = callback;
        if (HybridityUtils.isExplicitCameraPermissionRequired((Context)fragment.requireActivity())) {
            fragment.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
        } else {
            fragment.startActivityForResult(HybridityUtils.getCameraIntent((Context)fragment.requireActivity()), 200);
        }
    }

    public void startGallery(Activity activity, boolean cropEnabled, @NonNull PickCallback callback) {
        this.cropEnabled = cropEnabled;
        this.callback = callback;
        activity.startActivityForResult(HybridityUtils.getGalleryIntent(), 200);
    }

    public void startGallery(Fragment fragment, boolean cropEnabled, @NonNull PickCallback callback) {
        this.cropEnabled = cropEnabled;
        this.callback = callback;
        fragment.startActivityForResult(HybridityUtils.getGalleryIntent(), 200);
    }

    public void startChooser(Activity activity, String mime, @NonNull PickCallback callback) {
        this.cropEnabled = false;
        this.callback = callback;
        activity.startActivityForResult(HybridityUtils.getChooserIntent(mime), 200);
    }

    public void startChooser(Fragment fragment, String mime, @NonNull PickCallback callback) {
        this.cropEnabled = false;
        this.callback = callback;
        fragment.startActivityForResult(HybridityUtils.getChooserIntent(mime), 200);
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        this.onActivityResultInner(activity, null, requestCode, resultCode, data);
    }

    public void onActivityResult(Fragment fragment, int requestCode, int resultCode, Intent data) {
        this.onActivityResultInner(null, fragment, requestCode, resultCode, data);
    }

    private void onActivityResultInner(Activity activity, Fragment fragment, int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            if (this.callback != null) {
                this.callback.onCanceled();
            }
            return;
        }
        Object context = activity != null ? activity : fragment.getActivity();
        if (context != null && requestCode == 200) {
            Uri pickImageUri = HybridityUtils.getPickImageResultUri((Context)context, data);
            if (HybridityUtils.isReadExternalStoragePermissionsRequired((Context)context, pickImageUri)) {
                if (activity != null) {
                    ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)201);
                } else {
                    fragment.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
                }
            } else if (activity != null) {
                this.handlePickImage(activity, null, pickImageUri);
            } else {
                this.handlePickImage(null, fragment, pickImageUri);
            }
        } else if (requestCode == 203) {
            this.handleCropResult((Context)context, data);
        }
    }

    public void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        this.onRequestPermissionsResultInner(activity, null, requestCode, permissions, grantResults);
    }

    public void onRequestPermissionsResult(Fragment fragment, int requestCode, String[] permissions, int[] grantResults) {
        this.onRequestPermissionsResultInner(null, fragment, requestCode, permissions, grantResults);
    }

    private void onRequestPermissionsResultInner(Activity activity, Fragment fragment, int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 2011) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                if (activity != null) {
                    this.startCamera(activity, this.cropEnabled, this.callback);
                } else {
                    this.startCamera(fragment, this.cropEnabled, this.callback);
                }
            } else if (this.callback != null) {
                this.callback.onPermissionDenied(permissions, "\u6ca1\u6709\u76f8\u673a\u6743\u9650");
            }
        } else if (requestCode == 201) {
            if (this.cropImageUri != null && grantResults.length > 0 && grantResults[0] == 0) {
                if (activity != null) {
                    this.handlePickImage(activity, null, this.cropImageUri);
                } else {
                    this.handlePickImage(null, fragment, this.cropImageUri);
                }
            } else if (this.callback != null) {
                this.callback.onPermissionDenied(permissions, "\u6ca1\u6709\u5916\u90e8\u5b58\u50a8\u6743\u9650");
            }
        }
    }

    private void handleCropResult(Context context, Intent data) {
        CropImageView.CropResult result = null;
        if (data != null) {
            result = (ActivityResult)data.getParcelableExtra("CROP_IMAGE_EXTRA_RESULT");
        }
        if (result == null) {
            return;
        }
        Exception error = result.getError();
        if (error == null) {
            this.cropImageUri = result.getUri();
            if (this.callback != null) {
                this.callback.onCropImage(this.handleUri(context, this.cropImageUri));
            }
        } else if (this.callback != null) {
            this.callback.onCropError(error);
        }
    }

    private void handlePickImage(Activity activity, Fragment fragment, Uri imageUri) {
        if (this.callback != null) {
            Object context = activity != null ? activity : fragment.getContext();
            this.callback.onPickImage(this.handleUri((Context)context, imageUri));
        }
        if (!this.cropEnabled) {
            return;
        }
        if (imageUri == null || imageUri.equals((Object)Uri.EMPTY)) {
            if (this.callback != null) {
                this.callback.onCropError(new IllegalArgumentException("Uri is null or empty"));
            }
            return;
        }
        ActivityBuilder builder = new ActivityBuilder(imageUri);
        if (this.callback != null) {
            this.callback.cropConfig(builder);
        }
        if (activity != null) {
            builder.start(activity);
        } else {
            builder.start(fragment);
        }
    }

    private Uri handleUri(Context context, Uri imageUri) {
        String realPath;
        if ("content".equals(imageUri.getScheme()) && !TextUtils.isEmpty((CharSequence)(realPath = HybridityUtils.getRealPathFromUri(context, imageUri)))) {
            return Uri.fromFile((File)new File(realPath));
        }
        return imageUri;
    }

    private static class Holder {
        private static final ImagePicker INSTANCE = new ImagePicker();

        private Holder() {
        }
    }
}

