/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.core;

import android.app.Activity;
import android.app.Fragment;
import android.text.TextUtils;
import com.app.hubert.guide.core.Controller;
import com.app.hubert.guide.listener.OnGuideChangedListener;
import com.app.hubert.guide.listener.OnPageChangedListener;
import com.app.hubert.guide.model.GuidePage;
import java.util.ArrayList;
import java.util.List;

public class Builder {
    Activity activity;
    Fragment fragment;
    android.support.v4.app.Fragment v4Fragment;
    String label;
    boolean alwaysShow;
    OnGuideChangedListener onGuideChangedListener;
    OnPageChangedListener onPageChangedListener;
    List<GuidePage> guidePages = new ArrayList<GuidePage>();

    public Builder(Activity activity) {
        this.activity = activity;
    }

    public Builder(Fragment fragment) {
        this.fragment = fragment;
        this.activity = fragment.getActivity();
    }

    public Builder(android.support.v4.app.Fragment v4Fragment) {
        this.v4Fragment = v4Fragment;
        this.activity = v4Fragment.getActivity();
    }

    public Builder alwaysShow(boolean b) {
        this.alwaysShow = b;
        return this;
    }

    public Builder addGuidePage(GuidePage page) {
        this.guidePages.add(page);
        return this;
    }

    public Builder setOnGuideChangedListener(OnGuideChangedListener listener) {
        this.onGuideChangedListener = listener;
        return this;
    }

    public Builder setOnPageChangedListener(OnPageChangedListener onPageChangedListener) {
        this.onPageChangedListener = onPageChangedListener;
        return this;
    }

    public Builder setLabel(String label) {
        this.label = label;
        return this;
    }

    public Controller build() {
        this.checkAndSaveAsPage();
        return new Controller(this);
    }

    public Controller show() {
        this.checkAndSaveAsPage();
        Controller controller = new Controller(this);
        controller.show();
        return controller;
    }

    private void checkAndSaveAsPage() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("the param 'label' is missing, please call setLabel()");
        }
        if (this.activity == null && (this.fragment != null || this.v4Fragment != null)) {
            throw new IllegalStateException("activity is null, please make sure that fragment is showing when call NewbieGuide");
        }
    }
}

