/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.app.hubert.guide.model.HighLight;
import com.app.hubert.guide.model.HighlightOptions;
import com.app.hubert.guide.util.LogUtil;
import com.app.hubert.guide.util.ViewUtils;

public class HighlightView
implements HighLight {
    private View mHole;
    private HighLight.Shape shape;
    private int round;
    private int padding;
    private HighlightOptions options;
    private RectF rectF;

    public HighlightView(View mHole, HighLight.Shape shape, int round, int padding) {
        this.mHole = mHole;
        this.shape = shape;
        this.round = round;
        this.padding = padding;
    }

    public void setOptions(HighlightOptions options) {
        this.options = options;
    }

    @Override
    public HighLight.Shape getShape() {
        return this.shape;
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public HighlightOptions getOptions() {
        return this.options;
    }

    @Override
    public float getRadius() {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the highlight view is null!");
        }
        return Math.max(this.mHole.getWidth() / 2, this.mHole.getHeight() / 2) + this.padding;
    }

    @Override
    public RectF getRectF(View target) {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the highlight view is null!");
        }
        if (this.rectF == null) {
            this.rectF = new RectF();
            Rect locationInView = ViewUtils.getLocationInView(target, this.mHole);
            this.rectF.left = locationInView.left - this.padding;
            this.rectF.top = locationInView.top - this.padding;
            this.rectF.right = locationInView.right + this.padding;
            this.rectF.bottom = locationInView.bottom + this.padding;
            LogUtil.i(this.mHole.getClass().getSimpleName() + "'s location:" + this.rectF);
        }
        return this.rectF;
    }
}

