/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.core;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.guide.core.Builder;
import com.app.hubert.guide.core.GuideLayout;
import com.app.hubert.guide.lifecycle.FragmentLifecycleAdapter;
import com.app.hubert.guide.lifecycle.ListenerFragment;
import com.app.hubert.guide.lifecycle.V4ListenerFragment;
import com.app.hubert.guide.listener.OnGuideChangedListener;
import com.app.hubert.guide.listener.OnLayoutInflatedListener;
import com.app.hubert.guide.listener.OnPageChangedListener;
import com.app.hubert.guide.model.GuidePage;
import com.app.hubert.guide.util.LogUtil;
import com.app.hubert.guide.util.ScreenUtils;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.List;

public class Controller {
    private static final String LISTENER_FRAGMENT = "listener_fragment";
    private Activity activity;
    private Fragment fragment;
    private android.support.v4.app.Fragment v4Fragment;
    private OnGuideChangedListener onGuideChangedListener;
    private OnPageChangedListener onPageChangedListener;
    private String label;
    private boolean alwaysShow;
    private int showCounts;
    private List<GuidePage> guidePages;
    private int current;
    private GuideLayout currentLayout;
    private FrameLayout mParentView;
    private SharedPreferences sp;
    private boolean isDefaultParent;
    private int topMargin;
    private int indexOfChild = -1;

    public Controller(Builder builder) {
        this.activity = builder.activity;
        this.fragment = builder.fragment;
        this.v4Fragment = builder.v4Fragment;
        this.onGuideChangedListener = builder.onGuideChangedListener;
        this.onPageChangedListener = builder.onPageChangedListener;
        this.label = builder.label;
        this.alwaysShow = builder.alwaysShow;
        this.guidePages = builder.guidePages;
        this.showCounts = builder.showCounts;
        View anchor = builder.anchor;
        if (anchor == null) {
            anchor = this.activity.getWindow().getDecorView();
            this.isDefaultParent = true;
        }
        if (anchor instanceof FrameLayout) {
            this.mParentView = (FrameLayout)anchor;
        } else {
            FrameLayout frameLayout = new FrameLayout((Context)this.activity);
            ViewGroup parent = (ViewGroup)anchor.getParent();
            this.indexOfChild = parent.indexOfChild(anchor);
            parent.removeView(anchor);
            if (this.indexOfChild >= 0) {
                parent.addView((View)frameLayout, this.indexOfChild, anchor.getLayoutParams());
            } else {
                parent.addView((View)frameLayout, anchor.getLayoutParams());
            }
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            frameLayout.addView(anchor, lp);
            this.mParentView = frameLayout;
        }
        this.sp = this.activity.getSharedPreferences("NewbieGuide", 0);
    }

    public void show() {
        final int showed = this.sp.getInt(this.label, 0);
        if (!this.alwaysShow && showed >= this.showCounts) {
            return;
        }
        this.mParentView.post(new Runnable(){

            @Override
            public void run() {
                Controller.this.getTopMargin();
                if (Controller.this.guidePages == null || Controller.this.guidePages.size() == 0) {
                    throw new IllegalStateException("there is no guide to show!! Please add at least one Page.");
                }
                Controller.this.current = 0;
                Controller.this.showGuidePage();
                if (Controller.this.onGuideChangedListener != null) {
                    Controller.this.onGuideChangedListener.onShowed(Controller.this);
                }
                Controller.this.addListenerFragment();
                Controller.this.sp.edit().putInt(Controller.this.label, showed + 1).apply();
            }
        });
    }

    public void showPage(int position) {
        if (position < 0 || position > this.guidePages.size() - 1) {
            throw new InvalidParameterException("The Guide page position is out of range. current:" + position + ", range: [ 0, " + this.guidePages.size() + " )");
        }
        this.current = position;
        this.currentLayout.setOnGuideLayoutDismissListener(new GuideLayout.OnGuideLayoutDismissListener(){

            @Override
            public void onGuideLayoutDismiss(GuideLayout guideLayout) {
                Controller.this.showGuidePage();
            }
        });
        this.currentLayout.remove();
    }

    public void showPreviewPage() {
        this.showPage(--this.current);
    }

    private void showGuidePage() {
        GuidePage page = this.guidePages.get(this.current);
        GuideLayout guideLayout = new GuideLayout((Context)this.activity, page);
        this.addCustomToLayout(guideLayout, page);
        guideLayout.setOnGuideLayoutDismissListener(new GuideLayout.OnGuideLayoutDismissListener(){

            @Override
            public void onGuideLayoutDismiss(GuideLayout guideLayout) {
                Controller.this.showNextOrRemove();
            }
        });
        this.mParentView.addView((View)guideLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.currentLayout = guideLayout;
        if (this.onPageChangedListener != null) {
            this.onPageChangedListener.onPageChanged(this.current);
        }
    }

    private void showNextOrRemove() {
        if (this.current < this.guidePages.size() - 1) {
            ++this.current;
            this.showGuidePage();
        } else {
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onRemoved(this);
            }
            this.removeListenerFragment();
        }
    }

    private void addCustomToLayout(final GuideLayout guideLayout, GuidePage guidePage) {
        guideLayout.removeAllViews();
        int layoutResId = guidePage.getLayoutResId();
        if (layoutResId != 0) {
            OnLayoutInflatedListener inflatedListener;
            int[] viewIds;
            View view = LayoutInflater.from((Context)this.activity).inflate(layoutResId, (ViewGroup)guideLayout, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            if (this.isDefaultParent) {
                params.topMargin = this.topMargin;
                params.bottomMargin = ScreenUtils.getNavigationBarHeight(this.activity);
            }
            if ((viewIds = guidePage.getClickToDismissIds()) != null && viewIds.length > 0) {
                for (int viewId : viewIds) {
                    View click = view.findViewById(viewId);
                    if (click != null) {
                        click.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                guideLayout.remove();
                            }
                        });
                        continue;
                    }
                    Log.w((String)"NewbieGuide", (String)("can't find the view by id : " + viewId + " which used to remove guide page"));
                }
            }
            if ((inflatedListener = guidePage.getOnLayoutInflatedListener()) != null) {
                inflatedListener.onLayoutInflated(view, this);
            }
            guideLayout.addView(view, (ViewGroup.LayoutParams)params);
        }
    }

    private void getTopMargin() {
        View contentView = this.activity.findViewById(0x1020002);
        int[] location = new int[2];
        contentView.getLocationOnScreen(location);
        this.topMargin = location[1];
        LogUtil.i("contentView top:" + this.topMargin);
    }

    public void resetLabel() {
        this.resetLabel(this.label);
    }

    public void resetLabel(String label) {
        this.sp.edit().putInt(label, 0).apply();
    }

    public void remove() {
        if (this.currentLayout != null && this.currentLayout.getParent() != null) {
            ViewGroup parent = (ViewGroup)this.currentLayout.getParent();
            parent.removeView((View)this.currentLayout);
            if (!(parent instanceof FrameLayout)) {
                ViewGroup original = (ViewGroup)parent.getParent();
                View anchor = parent.getChildAt(0);
                parent.removeAllViews();
                if (anchor != null) {
                    if (this.indexOfChild > 0) {
                        original.addView(anchor, this.indexOfChild, parent.getLayoutParams());
                    } else {
                        original.addView(anchor, parent.getLayoutParams());
                    }
                }
            }
        }
        if (this.onGuideChangedListener != null) {
            this.onGuideChangedListener.onRemoved(this);
        }
    }

    private void addListenerFragment() {
        if (this.fragment != null && Build.VERSION.SDK_INT > 16) {
            this.compatibleFragment(this.fragment);
            android.app.FragmentManager fm = this.fragment.getChildFragmentManager();
            ListenerFragment listenerFragment = (ListenerFragment)fm.findFragmentByTag(LISTENER_FRAGMENT);
            if (listenerFragment == null) {
                listenerFragment = new ListenerFragment();
                fm.beginTransaction().add((Fragment)listenerFragment, LISTENER_FRAGMENT).commitAllowingStateLoss();
            }
            listenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    LogUtil.i("ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
        if (this.v4Fragment != null) {
            FragmentManager v4Fm = this.v4Fragment.getChildFragmentManager();
            V4ListenerFragment v4ListenerFragment = (V4ListenerFragment)v4Fm.findFragmentByTag(LISTENER_FRAGMENT);
            if (v4ListenerFragment == null) {
                v4ListenerFragment = new V4ListenerFragment();
                v4Fm.beginTransaction().add((android.support.v4.app.Fragment)v4ListenerFragment, LISTENER_FRAGMENT).commitAllowingStateLoss();
            }
            v4ListenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    LogUtil.i("v4ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
    }

    private void removeListenerFragment() {
        FragmentManager v4Fm;
        V4ListenerFragment v4ListenerFragment;
        android.app.FragmentManager fm;
        ListenerFragment listenerFragment;
        if (this.fragment != null && Build.VERSION.SDK_INT > 16 && (listenerFragment = (ListenerFragment)(fm = this.fragment.getChildFragmentManager()).findFragmentByTag(LISTENER_FRAGMENT)) != null) {
            fm.beginTransaction().remove((Fragment)listenerFragment).commitAllowingStateLoss();
        }
        if (this.v4Fragment != null && (v4ListenerFragment = (V4ListenerFragment)(v4Fm = this.v4Fragment.getChildFragmentManager()).findFragmentByTag(LISTENER_FRAGMENT)) != null) {
            v4Fm.beginTransaction().remove((android.support.v4.app.Fragment)v4ListenerFragment).commitAllowingStateLoss();
        }
    }

    private void compatibleFragment(Fragment fragment) {
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set(fragment, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

