/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mosaic.utils.SysOps;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvMetaInfo;

public class Files {
    public static final String[] outSuffixesCluster = new String[]{"*_mask_c1.zip", "*_mask_c2.zip", "*_outline_overlay_c1.zip", "*_outline_overlay_c2.zip", "*_intensities_c1.zip", "*_intensities_c2.zip", "*_seg_c1.zip", "*_seg_c2.zip", "*_coloc.zip", "*_soft_mask_c1.tiff", "*_soft_mask_c2.tiff", "*.tif", "*_ImageData.csv", "*_ObjectData.csv", "*_ImageColoc.csv", "*_ObjectColoc.csv"};

    public static <E extends BaseType> String createTitle(E aType, String aTitle) {
        if (aType.hasChannelInfo()) {
            throw new RuntimeException("Channel info not provided! [" + aTitle + " " + aType + "]");
        }
        return aTitle + aType.baseName();
    }

    public static <E extends BaseType> String createTitle(E aType, String aTitle, int aChannel) {
        if (!aType.hasChannelInfo()) {
            throw new RuntimeException("Channel provided but this type does not require it! [" + aTitle + " " + aType + "], " + aChannel + "]");
        }
        return aTitle + aType.baseName() + "_c" + aChannel;
    }

    public static <E extends BaseType> String createTitleWithExt(E aType, String aTitle) {
        return Files.addExt(aType, Files.createTitle(aType, aTitle));
    }

    public static <E extends BaseType> String createTitleWithExt(E aType, String aTitle, int aChannel) {
        return Files.addExt(aType, Files.createTitle(aType, aTitle, aChannel));
    }

    private static <E extends BaseType> String addExt(E aType, String aTitle) {
        return aTitle + "." + aType.ext();
    }

    public static <E extends BaseType> String getTypeDir(E aType) {
        return Files.createTitleWithExt(aType, "_") + File.separator;
    }

    public static <E extends BaseType> String getTypeDir(E aType, int aChannel) {
        return Files.createTitleWithExt(aType, "_", aChannel) + File.separator;
    }

    public static <E extends BaseType> String getMovedFilePath(E aType, String aTitle, int aChannel) {
        return Files.getTypeDir(aType, aChannel) + Files.createTitleWithExt(aType, aTitle, aChannel);
    }

    public static <E extends BaseType> String getMovedFilePath(E aType, String aTitle) {
        return Files.getTypeDir(aType) + Files.createTitleWithExt(aType, aTitle);
    }

    public static String getFullTypeName(FileInfo aFileInfo) {
        return aFileInfo.name.substring(aFileInfo.name.lastIndexOf(aFileInfo.type.baseName()));
    }

    public static Set<FileInfo> moveFilesToOutputDirs(Set<FileInfo> aSavedFiles, String aOutputDir) {
        LinkedHashSet<FileInfo> result = new LinkedHashSet<FileInfo>();
        for (FileInfo fi : aSavedFiles) {
            File dirName = new File(aOutputDir + File.separator + "_" + Files.getFullTypeName(fi));
            File fileToMove = new File(fi.name);
            SysOps.moveFileToDir(fileToMove, dirName, true, true);
            result.add(new FileInfo(fi.type, dirName + File.separator + fileToMove.getName()));
        }
        return result;
    }

    public static void stitchCsvFiles(Set<FileInfo> aSavedFiles, String aOutputDir, String aBackgroundValue) {
        HashMap<String, ArrayList<String>> m = new HashMap<String, ArrayList<String>>();
        for (FileInfo fi : aSavedFiles) {
            if (!fi.type.ext().equals("csv")) continue;
            String typeName = Files.getFullTypeName(fi);
            ArrayList<String> fileList = (ArrayList<String>)m.get(typeName);
            if (fileList == null) {
                fileList = new ArrayList<String>();
                m.put(typeName, fileList);
            }
            fileList.add(fi.name);
        }
        CsvMetaInfo metaInfo = aBackgroundValue != null ? new CsvMetaInfo("background", aBackgroundValue) : null;
        boolean firstFile = true;
        for (Map.Entry e : m.entrySet()) {
            Object[] currentFilesAbsPaths = ((List)e.getValue()).toArray(new String[0]);
            Arrays.sort(currentFilesAbsPaths);
            CSV<Object> csv = new CSV<Object>(Object.class);
            if (metaInfo != null) {
                csv.setMetaInformation(metaInfo);
            }
            if (firstFile) {
                firstFile = false;
                csv.setCSVPreferenceFromFile((String)currentFilesAbsPaths[0]);
            }
            csv.StitchAny((String[])currentFilesAbsPaths, aOutputDir + "stitch_" + (String)e.getKey());
        }
    }

    public static class FileInfo {
        FileType type;
        String name;

        FileInfo(FileType aType, String aName) {
            this.type = aType;
            this.name = aName;
        }

        public String toString() {
            return "[" + this.type + ", " + this.name + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileInfo other = (FileInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static enum FileType implements BaseType
    {
        Outline("_outline_overlay", "zip", true, 1),
        Intensity("_intensities", "zip", true, 1),
        Segmentation("_seg", "zip", true, 1),
        SoftMask("_soft_mask", "tiff", true, 1),
        Colocalization("_coloc", "zip", false, 0),
        Mask("_mask", "zip", true, 1),
        ImagesData("_ImageData", "csv", false, 0),
        ObjectsData("_ObjectData", "csv", false, 0),
        ImageColoc("_ImageColoc", "csv", false, 0),
        ObjectsColoc("_ObjectColoc", "csv", false, 0);

        private String baseName;
        private String ext;
        private boolean hasChannelInfo;
        private int numOfChannels;

        @Override
        public String baseName() {
            return this.baseName;
        }

        @Override
        public String ext() {
            return this.ext;
        }

        @Override
        public boolean hasChannelInfo() {
            return this.hasChannelInfo;
        }

        @Override
        public int numOfChannels() {
            return this.numOfChannels;
        }

        private FileType(String aBaseName, String aExt, boolean aHasChannelInfo, int aNumOfChannels) {
            this.baseName = aBaseName;
            this.ext = aExt;
            this.hasChannelInfo = aHasChannelInfo;
            this.numOfChannels = aNumOfChannels;
        }

        public String toString() {
            return "[" + this.name() + ", " + this.baseName + " / " + this.ext + "]";
        }
    }

    static interface BaseType {
        public String baseName();

        public String ext();

        public boolean hasChannelInfo();

        public int numOfChannels();
    }
}

