/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.GUI;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mosaic.bregman.GUI.BackgroundSubGUI;
import mosaic.bregman.GUI.ColocalizationGUI;
import mosaic.bregman.GUI.SegmentationGUI;
import mosaic.bregman.GUI.VisualizationGUI;
import mosaic.bregman.Parameters;
import mosaic.core.GUI.HelpGUI;
import mosaic.plugins.BregmanGLM_Batch;

public class GenericGUI {
    protected final Parameters iParameters;
    protected ImagePlus iInputImage;
    private static boolean iUseGui = true;
    private boolean iIsConfigReadFromArguments;
    private String iInputField = "";
    protected ImagePlus imgch2;

    public GenericGUI(ImagePlus aInputImg, boolean aUseGui, Parameters aParameters, boolean aIsConfigReadFromArguments) {
        this.iParameters = aParameters;
        this.iInputImage = aInputImg;
        iUseGui = aUseGui;
        this.iIsConfigReadFromArguments = aIsConfigReadFromArguments;
    }

    public BregmanGLM_Batch.RunMode drawStandardWindow(String aImgPath, boolean aRunOnCluster) {
        this.iInputField = aImgPath;
        GenericDialog gd = new GenericDialog("Squassh");
        gd.setInsets(-10, 0, 3);
        gd.addStringField("Input:", this.iInputField, 50);
        Panel p = new Panel(new FlowLayout(0, 75, 3));
        GenericGUI.addButton(p, "Select File/Folder", new FileOpenerActionListener(gd.getStringFields(), 0));
        gd.addPanel(p, 10, new Insets(0, 0, 0, 0));
        p = new Panel(new FlowLayout(0, 75, 3));
        GenericGUI.addButton(p, "Reset Settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericGUI.this.iParameters.copy(new Parameters());
            }
        });
        GenericGUI.addButton(p, "     Help     ", new HelpOpenerActionListener(gd));
        gd.addPanel(p, 10, new Insets(0, 0, 0, 0));
        p = new Panel();
        this.addLabel(p, "Background subtraction");
        GenericGUI.addButton(p, "Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BackgroundSubGUI.getParameters(GenericGUI.this.iParameters);
            }
        });
        gd.addPanel(p);
        p = new Panel();
        this.addLabel(p, "Segmentation parameters");
        GenericGUI.addButton(p, "Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SegmentationGUI.getParameters(GenericGUI.this.iParameters);
            }
        });
        gd.addPanel(p);
        p = new Panel();
        this.addLabel(p, "Colocalization (two channels images)");
        GenericGUI.addButton(p, "Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColocalizationGUI gds = new ColocalizationGUI(GenericGUI.this.iInputImage, GenericGUI.this.imgch2, GenericGUI.this.iParameters);
                gds.run();
            }
        });
        gd.addPanel(p);
        p = new Panel();
        this.addLabel(p, "Vizualization and output");
        GenericGUI.addButton(p, "Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VisualizationGUI.getParameters(GenericGUI.this.iParameters);
            }
        });
        gd.addPanel(p);
        gd.addCheckbox("Process on computer cluster", aRunOnCluster);
        p = new Panel();
        p.add(new JLabel("<html>Please refer to and cite:<br><br> G. Paul, J. Cardinale, and I. F. Sbalzarini.<br>Coupling image restoration and segmentation:<br>A generalized linear model/Bregman<br>perspective. Int. J. Comput. Vis., 104(1):69\u201393, 2013.<br><br>A. Rizk, G. Paul, P. Incardona, M. Bugarski, M. Mansouri,<br>A. Niemann, U. Ziegler, P. Berger, and I. F. Sbalzarini.<br>Segmentation and quantification of subcellular structures<br>in fluorescence microscopy images using Squassh.<br>Nature Protocols, 9(3):586\u2013596, 2014. </html>"));
        gd.addPanel(p);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return BregmanGLM_Batch.RunMode.STOP;
        }
        if (!iUseGui && !this.iIsConfigReadFromArguments) {
            BackgroundSubGUI.getParameters(this.iParameters);
            SegmentationGUI.getParameters(this.iParameters);
            new ColocalizationGUI(this.iInputImage, this.imgch2, this.iParameters).run();
            VisualizationGUI.getParameters(this.iParameters);
        }
        this.iInputField = gd.getNextString();
        BregmanGLM_Batch.RunMode runMode = gd.getNextBoolean() ? BregmanGLM_Batch.RunMode.CLUSTER : BregmanGLM_Batch.RunMode.LOCAL;
        return runMode;
    }

    public String getInput() {
        return this.iInputField;
    }

    private void addLabel(Panel p, String aLabel) {
        if (iUseGui) {
            Label label = new Label(aLabel);
            label.setFont(new Font(null, 1, 12));
            p.add(label);
        }
    }

    static void addButton(Panel aPanel, String aLabel, ActionListener aActionListener) {
        if (iUseGui) {
            Button b = new Button(aLabel);
            b.addActionListener(aActionListener);
            aPanel.add(b);
        }
    }

    private class Helpwindow
    extends HelpGUI {
        public Helpwindow(int x, int y) {
            JPanel pref = new JPanel(new GridBagLayout());
            this.setPanel(pref);
            this.setHelpTitle("Squassh");
            this.createArticle("http://mosaic.mpi-cbg.de/docs/Paul2013a.pdf");
            String desc = new String("Background subtraction is performed first, as the segmentation model assumes locally homogeneous intensities. Background variations are non-specific signals that are not accounted for by this model. We subtract the image background using the rolling-ball algorithm");
            this.createField("Background subtraction", desc, null);
            desc = new String("Model-based segmentation aim at finding the segmentation that best explains the image. In other words, they compute the segmentation that has the highest probability of resulting in the actually observed image when imaged with the specific microscope used.");
            this.createField("Segmentation", desc, null);
            desc = new String("Object-based colocalization is computed after segmenting the objects using information about the shapes and intensities of all objects in both channels. This allows straightforward calculation of the degree of overlap between objects from the different channels.");
            this.createField("Colocalization", desc, null);
            desc = new String("Select one or more output and visualization options");
            this.createField("Visualization and output", desc, null);
            JPanel panel = new JPanel(new FlowLayout(0, 10, 5));
            panel.setPreferredSize(new Dimension(575, 720));
            panel.add(pref);
            JDialog frame = new JDialog();
            frame.setModal(true);
            frame.setSize(555, 480);
            frame.setLocation(x + 500, y - 50);
            frame.add(panel);
            frame.setVisible(true);
        }
    }

    private class HelpOpenerActionListener
    implements ActionListener {
        GenericDialog gd;

        public HelpOpenerActionListener(GenericDialog gd) {
            this.gd = gd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point p = this.gd.getLocationOnScreen();
            new Helpwindow(p.x, p.y);
        }
    }

    private class FileOpenerActionListener
    implements ActionListener {
        List<?> iTextFields;
        int iFieldNumber;

        public FileOpenerActionListener(Vector<?> aTextFields, int aFilePathFieldNumber) {
            this.iTextFields = aTextFields;
            this.iFieldNumber = aFilePathFieldNumber;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GenericGUI.this.iInputImage != null) {
                GenericGUI.this.iInputImage.close();
                GenericGUI.this.iInputImage = null;
            }
            if (GenericGUI.this.imgch2 != null) {
                GenericGUI.this.imgch2.close();
                GenericGUI.this.imgch2 = null;
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            fc.showOpenDialog(null);
            File selFile = fc.getSelectedFile();
            if (selFile == null) {
                return;
            }
            String path = selFile.getAbsolutePath();
            boolean isFile = selFile.isFile();
            if (isFile) {
                ImagePlus img2 = IJ.openImage((String)path);
                img2.show();
            }
            TextField tf = (TextField)this.iTextFields.get(this.iFieldNumber);
            tf.setText(path);
        }
    }
}

