/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.GUI;

import ij.gui.GenericDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mosaic.bregman.GUI.GaussianPSFModel;
import org.apache.log4j.Logger;

class PSFWindow
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(PSFWindow.class);
    private double lem;
    private double lex;
    private double NA;
    private double n;
    private double pinhole;
    private double pix_xy;
    private double pix_z;
    private final JDialog frame;
    private final JPanel panel;
    private boolean confocal = true;
    private final String[] items = new String[]{"Confocal Microscope", "Wide Field Fluorescence Microscope"};
    private final NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private final JFormattedTextField Vlem = new JFormattedTextField(this.nf);
    private final JFormattedTextField Vlex = new JFormattedTextField(this.nf);
    private final JFormattedTextField VNA = new JFormattedTextField(this.nf);
    private final JFormattedTextField Vn = new JFormattedTextField(this.nf);
    private final JFormattedTextField Vpinhole = new JFormattedTextField(this.nf);
    private final JFormattedTextField Vpix_xy = new JFormattedTextField(this.nf);
    private final JFormattedTextField Vpix_z = new JFormattedTextField(this.nf);
    private final JComboBox<String> micr = new JComboBox<String>(this.items);
    private final JButton estimate = new JButton("Compute PSF");
    private final JLabel ref = new JLabel("<html><div align=\"justify\">Gaussian PSF approximation.<br><br>Model from: Gaussian approximations of fluorescence microscope point-spread function models. B Zhang, J Zerubia, J C Olivo-Marin. Appl. Optics (46) 1819-29, 2007.</div></html>");
    private final JLabel tlem = new JLabel("Emission wavelength (nm)");
    private final JLabel tlex = new JLabel("Excitation wavelength (nm)");
    private final JLabel tNA = new JLabel("Numerical aperture");
    private final JLabel tn = new JLabel("Refraction index");
    private final JLabel tpinhole = new JLabel("Pinhole size (Airy units)");
    private final JLabel tpix_xy = new JLabel("Lateral pixel size (nm)");
    private final JLabel tpix_z = new JLabel("Axial pixel size (nm)");
    private final JLabel result = new JLabel("");
    private final GenericDialog gd;

    public PSFWindow(int x, int y, GenericDialog gd) {
        y = 0;
        this.gd = gd;
        this.lem = 520.0;
        this.lex = 488.0;
        this.NA = 1.3;
        this.n = 1.46;
        this.pinhole = 1.0;
        this.pix_xy = 100.0;
        this.pix_z = 400.0;
        this.Vlem.setValue(this.lem);
        this.Vlex.setValue(this.lex);
        this.VNA.setValue(this.NA);
        this.Vn.setValue(this.n);
        this.Vpinhole.setValue(this.pinhole);
        this.Vpix_xy.setValue(this.pix_xy);
        this.Vpix_z.setValue(this.pix_z);
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.frame.setSize(300, 500);
        this.frame.setLocation(x + 450, y + 150);
        this.panel = new JPanel();
        this.panel.setPreferredSize(new Dimension(300, 500));
        this.panel.setSize(this.panel.getPreferredSize());
        this.panel.setLayout(null);
        JPanel pref = new JPanel(new BorderLayout());
        pref.setPreferredSize(new Dimension(280, 120));
        pref.setSize(pref.getPreferredSize());
        pref.add(this.ref);
        JPanel pres = new JPanel(new BorderLayout());
        pres.setPreferredSize(new Dimension(280, 80));
        pres.setSize(pres.getPreferredSize());
        pres.add(this.result);
        this.Vlem.setColumns(4);
        this.Vlex.setColumns(4);
        this.VNA.setColumns(4);
        this.Vn.setColumns(4);
        this.Vpinhole.setColumns(4);
        this.Vpix_xy.setColumns(4);
        this.Vpix_z.setColumns(4);
        this.Vlem.setHorizontalAlignment(0);
        this.Vlex.setHorizontalAlignment(0);
        this.VNA.setHorizontalAlignment(0);
        this.Vn.setHorizontalAlignment(0);
        this.Vpinhole.setHorizontalAlignment(0);
        this.Vpix_xy.setHorizontalAlignment(0);
        this.Vpix_z.setHorizontalAlignment(0);
        this.Vlem.setLocale(Locale.US);
        this.Vlex.setLocale(Locale.US);
        this.VNA.setLocale(Locale.US);
        this.Vn.setLocale(Locale.US);
        this.Vpinhole.setLocale(Locale.US);
        this.Vpix_xy.setLocale(Locale.US);
        this.Vpix_z.setLocale(Locale.US);
        this.micr.setSize(this.micr.getPreferredSize());
        this.tlem.setSize(this.tlem.getPreferredSize());
        this.Vlem.setSize(this.Vlem.getPreferredSize());
        this.tlex.setSize(this.tlex.getPreferredSize());
        this.Vlex.setSize(this.Vlex.getPreferredSize());
        this.tNA.setSize(this.tNA.getPreferredSize());
        this.VNA.setSize(this.VNA.getPreferredSize());
        this.tn.setSize(this.tn.getPreferredSize());
        this.Vn.setSize(this.Vn.getPreferredSize());
        this.tpinhole.setSize(this.tpinhole.getPreferredSize());
        this.Vpinhole.setSize(this.Vpinhole.getPreferredSize());
        this.tpix_xy.setSize(this.tpix_xy.getPreferredSize());
        this.Vpix_xy.setSize(this.Vpix_xy.getPreferredSize());
        this.tpix_z.setSize(this.tpix_z.getPreferredSize());
        this.Vpix_z.setSize(this.Vpix_z.getPreferredSize());
        this.estimate.setSize(this.estimate.getPreferredSize());
        pref.setLocation(10, 0);
        this.panel.add(pref);
        this.micr.setLocation(10, 125);
        this.tlem.setLocation(20, 165);
        this.Vlem.setLocation(200, 160);
        this.tlex.setLocation(20, 195);
        this.Vlex.setLocation(200, 190);
        this.tNA.setLocation(20, 225);
        this.VNA.setLocation(200, 220);
        this.tn.setLocation(20, 255);
        this.Vn.setLocation(200, 250);
        this.tpinhole.setLocation(20, 285);
        this.Vpinhole.setLocation(200, 280);
        this.tpix_xy.setLocation(20, 315);
        this.Vpix_xy.setLocation(200, 310);
        this.tpix_z.setLocation(20, 345);
        this.Vpix_z.setLocation(200, 340);
        this.estimate.setLocation(80, 375);
        this.result.setLocation(10, 405);
        this.panel.add(this.micr);
        this.panel.add(this.tlem);
        this.panel.add(this.Vlem);
        this.panel.add(this.tlex);
        this.panel.add(this.Vlex);
        this.panel.add(this.tNA);
        this.panel.add(this.VNA);
        this.panel.add(this.tn);
        this.panel.add(this.Vn);
        this.panel.add(this.tpinhole);
        this.panel.add(this.Vpinhole);
        this.panel.add(this.tpix_xy);
        this.panel.add(this.Vpix_xy);
        this.panel.add(this.tpix_z);
        this.panel.add(this.Vpix_z);
        this.panel.add(this.estimate);
        pres.setLocation(10, 400);
        this.panel.add(pres);
        this.frame.add(this.panel);
        this.estimate.addActionListener(this);
        this.Vlem.addPropertyChangeListener(this);
        this.Vlex.addPropertyChangeListener(this);
        this.VNA.addPropertyChangeListener(this);
        this.Vn.addPropertyChangeListener(this);
        this.Vpinhole.addPropertyChangeListener(this);
        this.Vpix_xy.addPropertyChangeListener(this);
        this.Vpix_z.addPropertyChangeListener(this);
        this.micr.addActionListener(this);
        this.frame.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.Vlem) {
            this.lem = (int)((Number)this.Vlem.getValue()).doubleValue();
        } else if (source == this.Vlex) {
            this.lex = ((Number)this.Vlex.getValue()).doubleValue();
        } else if (source == this.VNA) {
            this.NA = ((Number)this.VNA.getValue()).doubleValue();
        } else if (source == this.Vn) {
            this.n = ((Number)this.Vn.getValue()).doubleValue();
        } else if (source == this.Vpinhole) {
            this.pinhole = ((Number)this.Vpinhole.getValue()).doubleValue();
        } else if (source == this.Vpix_xy) {
            this.pix_xy = ((Number)this.Vpix_xy.getValue()).doubleValue();
        } else if (source == this.Vpix_z) {
            this.pix_z = ((Number)this.Vpix_z.getValue()).doubleValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.estimate) {
            double sx;
            double sz;
            GaussianPSFModel psf2 = new GaussianPSFModel(this.lem, this.lex, this.NA, this.pinhole, this.n);
            if (this.confocal) {
                sz = 1000.0 * psf2.axial_LSCM();
                sx = 1000.0 * psf2.lateral_LSCM();
            } else {
                sz = 1000.0 * psf2.axial_WFFM();
                sx = 1000.0 * psf2.lateral_WFFM();
            }
            TextField tx = (TextField)this.gd.getNumericFields().elementAt(4);
            TextField tz = (TextField)this.gd.getNumericFields().elementAt(5);
            logger.debug((Object)("Calculated sigmas xy / z: " + sx / this.pix_xy + " / " + sz / this.pix_z + " with pixel size xy/z: " + this.pix_xy + " / " + this.pix_z));
            tx.setText(String.format(Locale.US, "%.2f", sx / this.pix_xy));
            tz.setText(String.format(Locale.US, "%.2f", sz / this.pix_z));
            this.result.setText("<html><div align=\"justify\">Gaussian PSF stddev:<br>Lateral : " + String.format(Locale.US, "%.2f", sx) + " nm Axial : " + String.format(Locale.US, "%.2f", sz) + " nm<br>(" + String.format(Locale.US, "%.3f", sx / this.pix_xy) + ", " + String.format(Locale.US, "%.3f", sz / this.pix_z) + " in pixels)</div></html>");
        } else if (source == this.micr) {
            String selected = (String)this.micr.getSelectedItem();
            if (selected == this.items[1]) {
                this.confocal = false;
            }
            if (selected == this.items[0]) {
                this.confocal = true;
            }
        }
    }
}

