/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import ij.IJ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mosaic.bregman.segmentation.AnalysePatch;
import mosaic.bregman.segmentation.ObjectProperties;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.bregman.segmentation.SegmentationParameters;
import mosaic.bregman.segmentation.SegmentationTools;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import mosaic.utils.Debug;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.log4j.Logger;

class ImagePatches {
    private static final Logger logger = Logger.getLogger(ImagePatches.class);
    private final SegmentationParameters iParameters;
    private final ArrayList<Region> iRegionsList;
    private final double[][][] iImage;
    private final double[][][] w3kbest;
    private final double iGlobalMax;
    private final double iGlobalMin;
    private final double iRegularization;
    private final double iMinObjectIntensity;
    private final psf<DoubleType> iPsf;
    private final int iOversampling;
    private final int iOverInterXY;
    private final int iOverInterZ;
    private final int iSizeOverInterX;
    private final int iSizeOverInterY;
    private final int iSizeOverInterZ;
    private ArrayList<Region> iOutputRegionsList;
    private final short[][][] iOutputLabeledRegions;

    ImagePatches(SegmentationParameters aParameters, ArrayList<Region> aRegionsList, double[][][] aImage, double[][][] w3k, double aGlobalMin, double aGlobalMax, double aRegularization, double aMinObjectIntensity, psf<DoubleType> aPsf) {
        logger.debug((Object)("ImagePatches: numOfInputRegions: " + aRegionsList.size() + ", inputImage: " + Debug.getArrayDims(aImage)));
        this.iParameters = aParameters;
        this.iRegionsList = aRegionsList;
        this.iImage = aImage;
        this.w3kbest = w3k;
        this.iGlobalMin = aGlobalMin;
        this.iGlobalMax = aGlobalMax;
        this.iRegularization = aRegularization;
        this.iMinObjectIntensity = aMinObjectIntensity;
        this.iPsf = aPsf;
        int ni = aImage[0].length;
        int nj = aImage[0][0].length;
        int nz = aImage.length;
        this.iOversampling = this.iParameters.interpolation > 1 ? 2 : 1;
        this.iOverInterXY = this.iOversampling * this.iParameters.interpolation;
        this.iOverInterZ = nz == 1 ? 1 : this.iOversampling * this.iParameters.interpolation;
        this.iSizeOverInterX = ni * this.iOverInterXY;
        this.iSizeOverInterY = nj * this.iOverInterXY;
        this.iSizeOverInterZ = nz * this.iOverInterZ;
        this.iOutputRegionsList = new ArrayList();
        this.iOutputLabeledRegions = new short[this.iSizeOverInterZ][this.iSizeOverInterX][this.iSizeOverInterY];
        logger.debug((Object)("              oversampling/interpolation: " + this.iOversampling + " / " + this.iParameters.interpolation));
    }

    ArrayList<Region> getRegionsList() {
        return this.iOutputRegionsList;
    }

    short[][][] getLabeledRegions() {
        return this.iOutputLabeledRegions;
    }

    void processPatches() {
        int numberOfJobs = this.iRegionsList.size();
        int numOfDoneJobs = 0;
        int newLabel = 1;
        for (Region inputRegion : this.iRegionsList) {
            AnalysePatch ap = new AnalysePatch(this.iImage, inputRegion, this.iParameters, this.iOversampling, this.w3kbest, this.iRegularization, this.iMinObjectIntensity, this.iPsf);
            ArrayList<Region> regions = ap.calculateRegions();
            for (Region r : regions) {
                r.iLabel = newLabel++;
                this.iOutputRegionsList.add(r);
            }
            double d = 55.0 + 45.0 * (double)(++numOfDoneJobs) / (double)numberOfJobs;
            IJ.showStatus((String)("Computing segmentation  " + SegmentationTools.round(d, 2) + "%"));
            IJ.showProgress((double)(d / 100.0));
        }
        this.generateLabeledRegions(this.iOutputRegionsList, this.iOutputLabeledRegions);
        logger.debug((Object)("number of found regions:                      " + this.iOutputRegionsList.size() + ", output label regions: " + Debug.getArrayDims(this.iOutputLabeledRegions)));
        LabelImage img = new LabelImage(this.iOutputLabeledRegions);
        img.connectedComponents();
        HashMap<Integer, ArrayList<Pix>> newRegionList = new HashMap<Integer, ArrayList<Pix>>();
        Iterator<Point> rit = new SpaceIterator(img.getDimensions()).getPointIterator();
        while (rit.hasNext()) {
            Point p = rit.next();
            int n = img.getLabel(p);
            if (n == 0) continue;
            ArrayList<Pix> pixels = (ArrayList<Pix>)newRegionList.get(n);
            if (pixels == null) {
                pixels = new ArrayList<Pix>();
                newRegionList.put(n, pixels);
            }
            pixels.add(new Pix(p.iCoords[2], p.iCoords[0], p.iCoords[1]));
        }
        this.iOutputRegionsList.clear();
        for (Map.Entry entry : newRegionList.entrySet()) {
            if (((ArrayList)entry.getValue()).size() < this.iParameters.minRegionSize) continue;
            this.iOutputRegionsList.add(new Region((Integer)entry.getKey(), (List)entry.getValue()));
        }
        logger.debug((Object)("number of found regions after postprocessing: " + this.iOutputRegionsList.size()));
        ArrayOps.fill(this.iOutputLabeledRegions, (short)0);
        this.generateLabeledRegions(this.iOutputRegionsList, this.iOutputLabeledRegions);
        for (Region region : this.iOutputRegionsList) {
            double d = this.iParameters.defaultBetaMleOut;
            this.iParameters.getClass();
            ObjectProperties obj = new ObjectProperties(this.iImage, region, this.iOutputLabeledRegions, this.iPsf, d, 1.0, this.iSizeOverInterX, this.iSizeOverInterY, this.iSizeOverInterZ, this.iOverInterXY, this.iOverInterZ);
            obj.run();
        }
        ArrayList<Region> regionsListFiltered = new ArrayList<Region>();
        for (Region r : this.iOutputRegionsList) {
            r.intensity = r.intensity * (this.iGlobalMax - this.iGlobalMin) + this.iGlobalMin;
            if (!(r.intensity >= this.iParameters.minRegionIntensity)) continue;
            regionsListFiltered.add(r);
        }
        if (regionsListFiltered.size() != this.iOutputRegionsList.size()) {
            ArrayOps.fill(this.iOutputLabeledRegions, (short)0);
            this.generateLabeledRegions(regionsListFiltered, this.iOutputLabeledRegions);
            this.iOutputRegionsList = regionsListFiltered;
        }
        logger.debug((Object)("number of found regions after filtering:      " + this.iOutputRegionsList.size()));
    }

    private void generateLabeledRegions(Collection<Region> aRegionsList, short[][][] aOutputRegions) {
        for (Region r : aRegionsList) {
            for (Pix p : r.iPixels) {
                aOutputRegions[p.pz][p.px][p.py] = (short)r.iLabel;
            }
        }
    }
}

