/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.bregman.segmentation.RegionStatisticsSolver;
import mosaic.bregman.segmentation.SegmentationTools;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;
import sc.fiji.skeletonize3D.Skeletonize3D_;

class ObjectProperties
implements Runnable {
    private final double[][][] iImage;
    private final Region iRegion;
    private final short[][][] iLabeledRegion;
    private final psf<DoubleType> iPsf;
    private final double iBetaMleOut;
    private final double iBetaMleIn;
    private final int nx;
    private final int ny;
    private final int nz;
    private final int osxy;
    private final int osz;
    private int sx;
    private int sy;
    private int sz;
    private int cx;
    private int cy;
    private int cz;

    ObjectProperties(double[][][] aImage, Region aRegion, short[][][] aLabeledRegion, psf<DoubleType> aPsf, double aBetaMleOut, double aBetaMleIn, int nx, int ny, int nz, int osxy, int osz) {
        this.iImage = aImage;
        this.iRegion = aRegion;
        this.iLabeledRegion = aLabeledRegion;
        this.iPsf = aPsf;
        this.iBetaMleOut = aBetaMleOut;
        this.iBetaMleIn = aBetaMleIn;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.osxy = osxy;
        this.osz = osz;
        this.calculatePatchGeometry(aRegion);
    }

    @Override
    public void run() {
        double[][][] patch = this.fillPatch(this.iImage);
        ArrayOps.MinMax<Double> patchMinMax = ArrayOps.normalize(patch);
        double[][][] mask = this.fillMask(this.iRegion);
        double cin = this.estimateIntensity(mask, patch);
        this.iRegion.intensity = cin * (patchMinMax.getMax() - patchMinMax.getMin()) + patchMinMax.getMin();
        this.iRegion.realSize = (float)this.iRegion.iPixels.size() / ((float)this.osxy * (float)this.osxy * (float)this.osz);
        this.iRegion.calculateRegionCenter(this.osxy, this.osz);
        this.iRegion.perimeter = this.calculatePerimeter(this.iRegion, this.iLabeledRegion);
        this.calculateLength(this.iRegion, this.iLabeledRegion);
    }

    private double[][][] fillPatch(double[][][] image) {
        double[][][] patchResult = new double[this.sz][this.sx][this.sy];
        for (int z = 0; z < this.sz; ++z) {
            for (int i = 0; i < this.sx; ++i) {
                for (int j = 0; j < this.sy; ++j) {
                    patchResult[z][i][j] = image[(this.cz + z) / this.osz][(this.cx + i) / this.osxy][(this.cy + j) / this.osxy];
                }
            }
        }
        return patchResult;
    }

    private double[][][] fillMask(Region r) {
        double[][][] result = new double[this.sz][this.sx][this.sy];
        for (Pix p : r.iPixels) {
            int rz = p.pz - this.cz;
            int rx = p.px - this.cx;
            int ry = p.py - this.cy;
            result[rz][rx][ry] = 1.0;
        }
        return result;
    }

    private double estimateIntensity(double[][][] aMask, double[][][] aPatch) {
        double[][][][] temp = new double[3][this.sz][this.sx][this.sy];
        SegmentationTools.normalizeAndConvolveMask(temp[2], aMask, this.iPsf, temp[0], temp[1]);
        RegionStatisticsSolver RSS = new RegionStatisticsSolver(temp[0], temp[1], aPatch, null, 10, this.iBetaMleOut, this.iBetaMleIn);
        RSS.eval(temp[2]);
        return RSS.betaMLEin;
    }

    private double calculatePerimeter(Region aRegion, short[][][] aRegions) {
        if (this.sz == 1) {
            return this.regionPerimeter2D(aRegion, aRegions);
        }
        return this.regionPerimeter3D(aRegion, aRegions);
    }

    private double regionPerimeter2D(Region aRegion, short[][][] aRegions) {
        int numOfFreeEdges = 0;
        for (Pix p : aRegion.iPixels) {
            if (p.px != 0 && p.px != this.nx - 1 && p.py != 0 && p.py != this.ny - 1) {
                if (aRegions[p.pz][p.px - 1][p.py] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px + 1][p.py] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px][p.py - 1] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px][p.py + 1] != 0) continue;
                ++numOfFreeEdges;
                continue;
            }
            ++numOfFreeEdges;
        }
        return (double)numOfFreeEdges / (double)this.osxy;
    }

    private double regionPerimeter3D(Region aRegion, short[][][] aRegions) {
        int numOfFreeEdges = 0;
        for (Pix p : aRegion.iPixels) {
            if (p.px != 0 && p.px != this.nx - 1 && p.py != 0 && p.py != this.ny - 1 && p.pz != 0 && p.pz != this.nz - 1) {
                if (aRegions[p.pz][p.px - 1][p.py] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px + 1][p.py] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px][p.py - 1] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz][p.px][p.py + 1] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz + 1][p.px][p.py] == 0) {
                    ++numOfFreeEdges;
                }
                if (aRegions[p.pz - 1][p.px][p.py] != 0) continue;
                ++numOfFreeEdges;
                continue;
            }
            ++numOfFreeEdges;
        }
        return (double)numOfFreeEdges / (double)(this.osxy * this.osz);
    }

    private void calculateLength(Region aRegion, short[][][] aRegions) {
        ImageStack is = new ImageStack(this.sx, this.sy);
        for (int k = 0; k < this.sz; ++k) {
            byte[] maskBytes = new byte[this.sx * this.sy];
            for (int i = 0; i < this.sx; ++i) {
                for (int j = 0; j < this.sy; ++j) {
                    if (aRegions[this.cz + k][this.cx + i][this.cy + j] <= 0) continue;
                    maskBytes[j * this.sx + i] = -1;
                }
            }
            ByteProcessor bp = new ByteProcessor(this.sx, this.sy, maskBytes);
            is.addSlice((ImageProcessor)bp);
        }
        ImagePlus skeleton = new ImagePlus("Skeletonized", is);
        Skeletonize3D_ skel = new Skeletonize3D_();
        skel.setup("", skeleton);
        skel.run(skeleton.getProcessor());
        this.regionlength(aRegion, skeleton);
    }

    private void regionlength(Region r, ImagePlus skel) {
        int length = 0;
        ImageStack is = skel.getStack();
        for (Pix v : r.iPixels) {
            if (is.getProcessor(v.pz - this.cz + 1).getPixelValue(v.px - this.cx, v.py - this.cy) == 0.0f) continue;
            ++length;
        }
        r.length = (double)length / (double)(this.osxy * this.osz);
    }

    private void calculatePatchGeometry(Region aRegion) {
        Pix[] mm = aRegion.getMinMaxCoordinates();
        Pix min = mm[0];
        Pix max = mm[1];
        int xmin = min.px;
        int ymin = min.py;
        int zmin = min.pz;
        int xmax = max.px;
        int ymax = max.py;
        int zmax = max.pz;
        int margin = 5;
        int zmargin = 2;
        xmin = Math.max(0, xmin - 5);
        xmax = Math.min(this.nx, xmax + 5 + 1);
        ymin = Math.max(0, ymin - 5);
        ymax = Math.min(this.ny, ymax + 5 + 1);
        zmin = Math.max(0, zmin - 2);
        zmax = Math.min(this.nz, zmax + 2 + 1);
        this.sx = xmax - xmin;
        this.sy = ymax - ymin;
        this.cx = xmin;
        this.cy = ymin;
        this.sz = zmax - zmin;
        this.cz = zmin;
    }
}

