/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import java.util.List;
import mosaic.bregman.segmentation.Pix;

public class Region
implements Comparable<Region> {
    public int iLabel;
    public final List<Pix> iPixels;
    public double intensity;
    public double length;
    public double perimeter;
    public float realSize;
    private float cx;
    private float cy;
    private float cz;
    Region rvoronoi;

    public Region(int aLabel, List<Pix> aPixels) {
        this.iLabel = aLabel;
        this.iPixels = aPixels;
    }

    Pix[] getMinMaxCoordinates() {
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int zmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        int zmax = Integer.MIN_VALUE;
        for (Pix p : this.iPixels) {
            if (p.px < xmin) {
                xmin = p.px;
            }
            if (p.px > xmax) {
                xmax = p.px;
            }
            if (p.py < ymin) {
                ymin = p.py;
            }
            if (p.py > ymax) {
                ymax = p.py;
            }
            if (p.pz < zmin) {
                zmin = p.pz;
            }
            if (p.pz <= zmax) continue;
            zmax = p.pz;
        }
        Pix aMin = new Pix(zmin, xmin, ymin);
        Pix aMax = new Pix(zmax, xmax, ymax);
        return new Pix[]{aMin, aMax};
    }

    void calculateRegionCenter(int aScaleXY, int aScaleZ) {
        double sumx = 0.0;
        double sumy = 0.0;
        double sumz = 0.0;
        for (Pix p : this.iPixels) {
            sumx += (double)p.px;
            sumy += (double)p.py;
            sumz += (double)p.pz;
        }
        int count = this.iPixels.size();
        this.cx = (float)(sumx / (double)count);
        this.cy = (float)(sumy / (double)count);
        this.cz = (float)(sumz / (double)count);
        this.cx /= (float)aScaleXY;
        this.cy /= (float)aScaleXY;
        this.cz /= (float)aScaleZ;
    }

    @Override
    public int compareTo(Region otherRegion) {
        return this.iLabel < otherRegion.iLabel ? 1 : (this.iLabel > otherRegion.iLabel ? -1 : 0);
    }

    public double getcx() {
        return this.cx;
    }

    public double getcy() {
        return this.cy;
    }

    public double getcz() {
        return this.cz;
    }

    public double getintensity() {
        return this.intensity;
    }

    public double getrsize() {
        return this.realSize;
    }

    public double getperimeter() {
        return this.perimeter;
    }

    public double getlength() {
        return this.length;
    }

    public String toString() {
        return "{" + this.iLabel + ", " + this.iPixels.size() + "}";
    }
}

