/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import mosaic.bregman.segmentation.SegmentationParameters;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;

class SegmentationTools {
    private final int ni;
    private final int nj;
    private final int nz;

    SegmentationTools(int nni, int nnj, int nnz) {
        this.ni = nni;
        this.nj = nnj;
        this.nz = nnz;
    }

    private static void convolve2Dseparable(double[][] out, double[][] in, int icols, int irows, psf<DoubleType> psf2, double[][] temp) {
        SegmentationTools.convolve2Dseparable(out, in, icols, irows, psf2, temp, 0, icols);
    }

    private static void convolve2Dseparable(double[][] out, double[][] in, int icols, int irows, psf<DoubleType> psf2, double[][] temp, int iStart, int iEnd) {
        int rowIndex;
        int colIndex;
        double sum;
        int j;
        int i;
        int[] sz = psf2.getSuggestedImageSize();
        int kCenterX = sz[0] / 2;
        int kCenterY = sz[1] / 2;
        double[] kernelx = psf2.getSeparableImageAsDoubleArray(0);
        double[] kernely = psf2.getSeparableImageAsDoubleArray(1);
        for (i = iStart; i < iEnd; ++i) {
            for (j = 0; j < irows; ++j) {
                sum = 0.0;
                for (int m = 0; m < sz[0]; ++m) {
                    int mm = sz[0] - 1 - m;
                    colIndex = i + m - kCenterX;
                    rowIndex = j;
                    if (colIndex >= 0 && colIndex < icols) {
                        sum += in[colIndex][rowIndex] * kernelx[mm];
                        continue;
                    }
                    do {
                        if (colIndex < 0) {
                            colIndex = -colIndex - 1;
                        }
                        if (colIndex <= icols - 1) continue;
                        colIndex = icols - (colIndex - icols) - 1;
                    } while (colIndex < 0 || colIndex >= icols);
                    sum += in[colIndex][rowIndex] * kernelx[mm];
                }
                temp[i][j] = sum;
            }
        }
        for (i = iStart; i < iEnd; ++i) {
            for (j = 0; j < irows; ++j) {
                sum = 0.0;
                for (int n = 0; n < sz[1]; ++n) {
                    int nn = sz[1] - 1 - n;
                    colIndex = i;
                    rowIndex = j + n - kCenterY;
                    if (rowIndex >= 0 && rowIndex < irows) {
                        sum += temp[colIndex][rowIndex] * kernely[nn];
                        continue;
                    }
                    do {
                        if (rowIndex < 0) {
                            rowIndex = -rowIndex - 1;
                        }
                        if (rowIndex <= irows - 1) continue;
                        rowIndex = irows - (rowIndex - irows) - 1;
                    } while (rowIndex < 0 || rowIndex >= irows);
                    sum += temp[colIndex][rowIndex] * kernely[nn];
                }
                out[i][j] = sum;
            }
        }
    }

    private static void convolve3Dseparable(double[][][] out, double[][][] in, int icols, int irows, int islices, psf<DoubleType> psf2, double[][][] temp) {
        SegmentationTools.convolve3Dseparable(out, in, icols, irows, islices, psf2, temp, 0, icols);
    }

    private static void convolve3Dseparable(double[][][] out, double[][][] in, int icols, int irows, int islices, psf<DoubleType> psf2, double[][][] temp, int iStart, int iEnd) {
        int rowIndex;
        int colIndex;
        double sum;
        int j;
        int i;
        int k;
        int[] sz = psf2.getSuggestedImageSize();
        double[] kernelx = psf2.getSeparableImageAsDoubleArray(0);
        double[] kernely = psf2.getSeparableImageAsDoubleArray(1);
        double[] kernelz = psf2.getSeparableImageAsDoubleArray(2);
        int kCenterX = sz[0] / 2;
        int kCenterY = sz[1] / 2;
        int kCenterZ = sz[2] / 2;
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int m = 0; m < sz[0]; ++m) {
                        int mm = sz[0] - 1 - m;
                        colIndex = i + m - kCenterX;
                        rowIndex = j;
                        if (colIndex >= 0 && colIndex < icols) {
                            sum += in[k][colIndex][rowIndex] * kernelx[mm];
                            continue;
                        }
                        do {
                            if (colIndex < 0) {
                                colIndex = -colIndex - 1;
                            }
                            if (colIndex <= icols - 1) continue;
                            colIndex = icols - (colIndex - icols) - 1;
                        } while (colIndex < 0 || colIndex >= icols);
                        sum += in[k][colIndex][rowIndex] * kernelx[mm];
                    }
                    out[k][i][j] = sum;
                }
            }
        }
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int n = 0; n < sz[1]; ++n) {
                        int nn = sz[1] - 1 - n;
                        colIndex = i;
                        rowIndex = j + n - kCenterY;
                        if (rowIndex >= 0 && rowIndex < irows) {
                            sum += out[k][colIndex][rowIndex] * kernely[nn];
                            continue;
                        }
                        do {
                            if (rowIndex < 0) {
                                rowIndex = -rowIndex - 1;
                            }
                            if (rowIndex <= irows - 1) continue;
                            rowIndex = irows - (rowIndex - irows) - 1;
                        } while (rowIndex < 0 || rowIndex >= irows);
                        sum += out[k][colIndex][rowIndex] * kernely[nn];
                    }
                    temp[k][i][j] = sum;
                }
            }
        }
        for (k = 0; k < islices; ++k) {
            for (i = iStart; i < iEnd; ++i) {
                for (j = 0; j < irows; ++j) {
                    sum = 0.0;
                    for (int l = 0; l < sz[2]; ++l) {
                        int ll = sz[2] - 1 - l;
                        colIndex = i;
                        rowIndex = j;
                        int sliceIndex = k + l - kCenterZ;
                        if (sliceIndex >= 0 && sliceIndex < islices) {
                            sum += temp[sliceIndex][colIndex][rowIndex] * kernelz[ll];
                            continue;
                        }
                        do {
                            if (sliceIndex < 0) {
                                sliceIndex = Math.min(islices - 1, -sliceIndex - 1);
                            }
                            if (sliceIndex <= islices - 1) continue;
                            sliceIndex = Math.max(0, islices - (sliceIndex - islices) - 1);
                        } while (sliceIndex < 0 || sliceIndex >= islices);
                        sum += temp[sliceIndex][colIndex][rowIndex] * kernelz[ll];
                    }
                    out[k][i][j] = sum;
                }
            }
        }
    }

    static void copytab(double[][][] res, double[][][] m1) {
        int nz = res.length;
        int ni = res[0].length;
        int nj = res[0][0].length;
        for (int z = 0; z < nz; ++z) {
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    res[z][i][j] = m1[z][i][j];
                }
            }
        }
    }

    private void nllMean(double[][][] res, double[][][] image, double[][][] mu, SegmentationParameters.NoiseModel aNoiseModel) {
        this.nllMean(res, image, mu, 0, this.ni, aNoiseModel);
    }

    private void nllMean(double[][][] res, double[][][] image, double[][][] mu, int iStart, int iEnd, SegmentationParameters.NoiseModel aNoiseModel) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = iStart; i < iEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = this.noise(image[z][i][j], mu[z][i][j], aNoiseModel);
                }
            }
        }
    }

    private double noise(double im, double mu, SegmentationParameters.NoiseModel aNoiseModel) {
        double res;
        if (mu < 0.0) {
            mu = 1.0E-4;
        }
        if (aNoiseModel == SegmentationParameters.NoiseModel.POISSON) {
            res = im != 0.0 ? im * Math.log(im / mu) + mu - im : mu;
            if (mu == 0.0) {
                res = im;
            }
        } else {
            res = (im - mu) * (im - mu);
        }
        return res;
    }

    private void fgradz2D(double[][][] res, double[][][] im) {
        this.fgradz2D(res, im, 0, this.ni);
    }

    private void fgradz2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz - 1; ++z) {
            for (int i = tStart; i < tEnd; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    res[z][i][j] = im[z + 1][i][j] - im[z][i][j];
                }
            }
        }
        for (int i = tStart; i < tEnd; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                res[this.nz - 1][i][j] = 0.0;
            }
        }
    }

    private void fgradx2D(double[][][] res, double[][][] im) {
        this.fgradx2D(res, im, 0, this.nj);
    }

    private void fgradx2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni - 1; ++i) {
                for (int j = tStart; j < tEnd; ++j) {
                    res[z][i][j] = im[z][i + 1][j] - im[z][i][j];
                }
            }
            for (int j = tStart; j < tEnd; ++j) {
                res[z][this.ni - 1][j] = 0.0;
            }
        }
    }

    private void fgrady2D(double[][][] res, double[][][] im) {
        this.fgrady2D(res, im, 0, this.ni);
    }

    private void fgrady2D(double[][][] res, double[][][] im, int tStart, int tEnd) {
        for (int z = 0; z < this.nz; ++z) {
            int i;
            for (i = tStart; i < tEnd; ++i) {
                for (int j = 0; j < this.nj - 1; ++j) {
                    res[z][i][j] = im[z][i][j + 1] - im[z][i][j];
                }
            }
            for (i = tStart; i < tEnd; ++i) {
                res[z][i][this.nj - 1] = 0.0;
            }
        }
    }

    double computeEnergyPSF_weighted(double[][][] speedData, double[][][] mask, double[][][] maskx, double[][][] masky, double[][][] weights, double ldata, double lreg, psf<DoubleType> aPsf, double c0, double c1, double[][][] image, SegmentationParameters.NoiseModel aNoiseModel) {
        return this.nz == 1 ? this.computeEnergyPSF2D_weighted(speedData, mask, maskx, masky, weights, ldata, lreg, aPsf, c0, c1, image, aNoiseModel) : this.computeEnergyPSF3D_weighted(speedData, mask, maskx, masky, weights, ldata, lreg, aPsf, c0, c1, image, aNoiseModel);
    }

    private double computeEnergyPSF2D_weighted(double[][][] speedData, double[][][] mask, double[][][] maskx, double[][][] masky, double[][][] weights, double ldata, double lreg, psf<DoubleType> aPsf, double c0, double c1, double[][][] image, SegmentationParameters.NoiseModel aNoiseModel) {
        if (!aPsf.isSeparable()) {
            throw new RuntimeException("Error: non-separable PSF calculation are not implemented");
        }
        SegmentationTools.convolve2Dseparable(speedData[0], mask[0], this.ni, this.nj, aPsf, maskx[0], 0, this.ni);
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                speedData[0][i][j] = (c1 - c0) * speedData[0][i][j] + c0;
            }
        }
        this.nllMean(speedData, image, speedData, 0, this.ni, aNoiseModel);
        double energyData = 0.0;
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                energyData += speedData[0][i][j] * weights[0][i][j];
            }
        }
        this.fgradx2D(maskx, mask, 0, this.nj);
        this.fgrady2D(masky, mask, 0, this.ni);
        double energyPrior = 0.0;
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    double mkx = maskx[z][i][j];
                    double mky = masky[z][i][j];
                    energyPrior += Math.sqrt(mkx * mkx + mky * mky);
                }
            }
        }
        double energy = ldata * energyData + lreg * energyPrior;
        return energy;
    }

    private double computeEnergyPSF3D_weighted(double[][][] speedData, double[][][] mask, double[][][] temp, double[][][] temp2, double[][][] weights, double ldata, double lreg, psf<DoubleType> aPsf, double c0, double c1, double[][][] image, SegmentationParameters.NoiseModel aNoiseModel) {
        int j;
        int i;
        int z;
        SegmentationTools.convolve3Dseparable(speedData, mask, this.ni, this.nj, this.nz, aPsf, temp);
        for (int z2 = 0; z2 < this.nz; ++z2) {
            for (int i2 = 0; i2 < this.ni; ++i2) {
                for (int j2 = 0; j2 < this.nj; ++j2) {
                    speedData[z2][i2][j2] = (c1 - c0) * speedData[z2][i2][j2] + c0;
                }
            }
        }
        this.nllMean(speedData, image, speedData, aNoiseModel);
        double energyData = 0.0;
        for (int z3 = 0; z3 < this.nz; ++z3) {
            for (int i3 = 0; i3 < this.ni; ++i3) {
                for (int j3 = 0; j3 < this.nj; ++j3) {
                    energyData += speedData[z3][i3][j3] * weights[z3][i3][j3];
                }
            }
        }
        this.fgradx2D(temp, mask);
        for (z = 0; z < this.nz; ++z) {
            for (i = 0; i < this.ni; ++i) {
                for (j = 0; j < this.nj; ++j) {
                    double tmp = temp[z][i][j];
                    temp2[z][i][j] = tmp * tmp;
                }
            }
        }
        this.fgrady2D(temp, mask);
        for (z = 0; z < this.nz; ++z) {
            for (i = 0; i < this.ni; ++i) {
                j = 0;
                while (j < this.nj) {
                    double tmp = temp[z][i][j];
                    double[] dArray = temp2[z][i];
                    int n = j++;
                    dArray[n] = dArray[n] + tmp * tmp;
                }
            }
        }
        this.fgradz2D(temp, mask);
        for (z = 0; z < this.nz; ++z) {
            for (i = 0; i < this.ni; ++i) {
                j = 0;
                while (j < this.nj) {
                    double tmp = temp[z][i][j];
                    double[] dArray = temp2[z][i];
                    int n = j++;
                    dArray[n] = dArray[n] + tmp * tmp;
                }
            }
        }
        double energyPrior = 0.0;
        for (int z4 = 0; z4 < this.nz; ++z4) {
            for (int i4 = 0; i4 < this.ni; ++i4) {
                for (int j4 = 0; j4 < this.nj; ++j4) {
                    energyPrior += Math.sqrt(temp2[z4][i4][j4]);
                }
            }
        }
        double energy = ldata * energyData + lreg * energyPrior;
        return energy;
    }

    static double round(double y, int z) {
        double factor = Math.pow(10.0, z);
        y *= factor;
        y = (int)y;
        return y /= factor;
    }

    static double[][][] normalizeAndConvolveMask(double[][][] aResult, double[][][] Mask2, psf<DoubleType> aPsf, double[][][] aTempBuf1, double[][][] aTempBuf2) {
        SegmentationTools.scale_mask(aTempBuf1, Mask2);
        if (Mask2.length == 1) {
            SegmentationTools.convolve2Dseparable(aResult[0], aTempBuf1[0], Mask2[0].length, Mask2[0][0].length, aPsf, aTempBuf2[0]);
        } else {
            SegmentationTools.convolve3Dseparable(aResult, aTempBuf1, Mask2[0].length, Mask2[0][0].length, Mask2.length, aPsf, aTempBuf2);
        }
        return aResult;
    }

    private static void scale_mask(double[][][] ScaledMask, double[][][] Mask2) {
        ArrayOps.MinMax<Double> minMax = ArrayOps.findMinMax(Mask2);
        ArrayOps.normalize(Mask2, ScaledMask, minMax.getMin(), minMax.getMax());
    }
}

