/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.plugin.filter.EDM;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.List;
import mosaic.bregman.segmentation.FindConnectedRegions;
import mosaic.bregman.segmentation.ImagePatches;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.bregman.segmentation.SegmentationParameters;
import mosaic.bregman.segmentation.SegmentationTools;
import mosaic.bregman.solver.ASplitBregmanSolver;
import mosaic.bregman.solver.SolverParameters;
import mosaic.core.psf.GaussPSF;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import mosaic.utils.Debug;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.log4j.Logger;

public class SquasshSegmentation {
    private static final Logger logger = Logger.getLogger(SquasshSegmentation.class);
    private final SegmentationParameters iParameters;
    private final double iGlobalMin;
    private final double iGlobalMax;
    private final int ni;
    private final int nj;
    private final int nz;
    private final double[][][] iImage;
    private final double[][][] iMask;
    private final psf<DoubleType> iPsf;
    private final ASplitBregmanSolver iSolver;
    public short[][][] iLabeledRegions;
    public ArrayList<Region> iRegionsList;
    public double[][][] iSoftMask;
    public final List<float[][][]> iAllMasks = new ArrayList<float[][][]>();

    public SquasshSegmentation(double[][][] aInputImg, SegmentationParameters aParameters, double aGlobalMin, double aGlobalMax) {
        double d;
        logger.debug((Object)aParameters);
        logger.debug((Object)("Input Image dimensions (z/x/y):" + Debug.getArrayDims(aInputImg)));
        logger.debug((Object)("Global min/max: " + aGlobalMin + " / " + aGlobalMax));
        this.iParameters = aParameters;
        this.iGlobalMin = aGlobalMin;
        this.iGlobalMax = aGlobalMax;
        this.ni = aInputImg[0].length;
        this.nj = aInputImg[0][0].length;
        this.nz = aInputImg.length;
        this.iImage = new double[this.nz][this.ni][this.nj];
        ArrayOps.normalize(aInputImg, this.iImage, this.iGlobalMin, this.iGlobalMax);
        this.iParameters.getClass();
        if (1.0 == 1.0) {
            d = 0.5;
        } else {
            this.iParameters.getClass();
            d = 1.0;
        }
        double maskThreshold = d;
        this.iMask = this.createMask(this.iImage, maskThreshold);
        this.iPsf = this.generatePsf();
        int n = this.iParameters.numOfThreads;
        SolverParameters.NoiseModel noiseModel = SolverParameters.NoiseModel.valueOf(this.iParameters.noiseModel.name());
        this.iParameters.getClass();
        SolverParameters solverParams = new SolverParameters(n, noiseModel, 1.0, this.iParameters.defaultBetaMleOut, this.iParameters.lambdaRegularization);
        this.iSolver = ASplitBregmanSolver.create(solverParams, this.iImage, this.iMask, this.iPsf);
    }

    public void run() {
        this.stepOneFromImage();
        this.stepTwoSegmentation();
    }

    public void runWithProvidedMask(double[][][] aMask) {
        this.stepOneFromPatches(aMask);
        this.stepTwoSegmentation();
    }

    private void stepOneFromImage() {
        this.setProgress(0);
        int numOfIterations = 151;
        boolean isDone = false;
        for (int iteration = 0; iteration < 151 && !isDone; ++iteration) {
            boolean lastIteration = iteration == 150;
            isDone = this.iSolver.performIteration(lastIteration);
            this.iParameters.getClass();
            this.setProgress(50 * iteration / 150);
        }
        this.iSolver.postprocess();
    }

    private void stepOneFromPatches(double[][][] aInputMask) {
        SegmentationTools.copytab(this.iSolver.w3kbest, aInputMask);
    }

    private void stepTwoSegmentation() {
        this.iSoftMask = (double[][][])this.iSolver.w3kbest.clone();
        this.computeConnectedRegions(this.iSolver.w3kbest);
        this.setProgress(51);
        this.computeVoronoiRegions();
        ImagePatches ipatches = new ImagePatches(this.iParameters, this.iRegionsList, this.iImage, this.iSolver.w3kbest, this.iGlobalMin, this.iGlobalMax, this.iParameters.lambdaRegularization, this.iParameters.minObjectIntensity, this.iPsf);
        ipatches.processPatches();
        this.iRegionsList = ipatches.getRegionsList();
        this.iLabeledRegions = ipatches.getLabeledRegions();
        this.relabelRegions(this.iRegionsList, this.iLabeledRegions);
        this.setProgress(100);
    }

    private void relabelRegions(ArrayList<Region> aRegionsList, short[][][] aLabeledRegions) {
        int label = 1;
        for (Region r : aRegionsList) {
            for (Pix p : r.iPixels) {
                aLabeledRegions[p.pz][p.px][p.py] = label;
            }
            r.iLabel = label;
            label = (short)(label + 1);
        }
    }

    private GaussPSF<DoubleType> generatePsf() {
        int psfDims = this.nz > 1 ? 3 : 2;
        GaussPSF<DoubleType> psf2 = new GaussPSF<DoubleType>(psfDims, DoubleType.class);
        DoubleType[] var = new DoubleType[psfDims];
        var[0] = new DoubleType(this.iParameters.sigmaGaussianXY);
        var[1] = new DoubleType(this.iParameters.sigmaGaussianXY);
        if (psfDims == 3) {
            var[2] = new DoubleType(this.iParameters.sigmaGaussianZ);
        }
        psf2.setStdDeviation((RealType<T>[])var);
        psf2.getSeparableImageAsDoubleArray(0);
        return psf2;
    }

    private double[][][] createMask(double[][][] aInputImage, double aMaskThreshold) {
        double[][][] result = new double[this.nz][this.ni][this.nj];
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    if (!(aInputImage[z][i][j] >= aMaskThreshold)) continue;
                    result[z][i][j] = 1.0;
                }
            }
        }
        return result;
    }

    private void computeConnectedRegions(double[][][] aMask) {
        ImageStack maskStack = new ImageStack(this.ni, this.nj);
        for (int z = 0; z < this.nz; ++z) {
            byte[] mask_bytes = new byte[this.ni * this.nj];
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    mask_bytes[j * this.ni + i] = (byte)(255.0 * aMask[z][i][j]);
                }
            }
            ByteProcessor bp = new ByteProcessor(this.ni, this.nj, mask_bytes);
            maskStack.addSlice("", (ImageProcessor)bp);
        }
        ImagePlus maskImg = new ImagePlus("ConnectedRegions", maskStack);
        FindConnectedRegions fcr = new FindConnectedRegions(maskImg);
        fcr.run(-1, this.iParameters.minRegionSize, (float)(255.0 * this.iParameters.minObjectIntensity), this.iParameters.excludeEdgesZ, 1, 1);
        this.iLabeledRegions = fcr.getLabeledRegions();
        this.iRegionsList = fcr.getFoundRegions();
        this.iParameters.getClass();
    }

    private void computeVoronoiRegions() {
        byte[] mask_bytes = new byte[this.ni * this.nj];
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    if (this.iLabeledRegions[z][i][j] <= 0) continue;
                    mask_bytes[j * this.ni + i] = -1;
                }
            }
        }
        ByteProcessor bp = new ByteProcessor(this.ni, this.nj, mask_bytes);
        bp.invert();
        ImagePlus maskImg = new ImagePlus("Mask Thresholded", (ImageProcessor)bp);
        boolean tempBlackBackground = Prefs.blackBackground;
        Prefs.blackBackground = false;
        EDM filtEDM = new EDM();
        filtEDM.setup("voronoi", maskImg);
        filtEDM.run(maskImg.getProcessor());
        Prefs.blackBackground = tempBlackBackground;
        maskImg.getProcessor().invert();
        this.setProgress(53);
        ImageProcessor impVoronoi = maskImg.getProcessor();
        byte[] maskBytesVoronoi = new byte[this.ni * this.nj];
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                maskBytesVoronoi[j * this.ni + i] = (byte)impVoronoi.getPixelValue(i, j);
            }
        }
        ImageStack imgStackVoronoi = new ImageStack(this.ni, this.nj);
        for (int z = 0; z < this.nz; ++z) {
            imgStackVoronoi.addSlice("", (ImageProcessor)new ByteProcessor(this.ni, this.nj, (byte[])maskBytesVoronoi.clone()));
        }
        maskImg.setStack("Voronoi", imgStackVoronoi);
        FindConnectedRegions fcr = new FindConnectedRegions(maskImg);
        fcr.run(this.ni * this.nj * this.nz, 0, 255.0f, this.iParameters.excludeEdgesZ, 1, 1);
        ArrayList<Region> regionsvoronoi = fcr.getFoundRegions();
        logger.debug((Object)("NumOfRegions - connected regions / voronoi: " + this.iRegionsList.size() + " / " + regionsvoronoi.size()));
        this.setRegionsObjsVoronoi(this.iRegionsList, regionsvoronoi);
        this.setProgress(54);
    }

    private void setProgress(int aPercent) {
        logger.debug((Object)("Segmentation progress: " + aPercent));
        IJ.showStatus((String)("Computing segmentation " + aPercent + "%"));
        IJ.showProgress((double)((double)aPercent / 100.0));
    }

    private void setRegionsObjsVoronoi(ArrayList<Region> aRegionsList, ArrayList<Region> aRegionsVoronoi) {
        float[][][] voronoiIndexMap = new float[this.nz][this.ni][this.nj];
        ArrayOps.fill(voronoiIndexMap, 255.0f);
        for (Region r : aRegionsVoronoi) {
            int index = aRegionsVoronoi.indexOf(r);
            for (Pix p : r.iPixels) {
                voronoiIndexMap[p.pz][p.px][p.py] = index;
            }
        }
        this.iParameters.getClass();
        for (Region r : aRegionsList) {
            Pix pixel = r.iPixels.get(0);
            int x = pixel.px;
            int y = pixel.py;
            int z = pixel.pz;
            r.rvoronoi = aRegionsVoronoi.get((int)voronoiIndexMap[z][x][y]);
        }
    }
}

