/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.solver;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import java.util.concurrent.CountDownLatch;
import mosaic.bregman.solver.ASplitBregmanSolver;
import mosaic.bregman.solver.SolverParameters;
import mosaic.bregman.solver.SolverTools;
import mosaic.bregman.solver.ZoneTask2D;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;

class ASplitBregmanSolver2D
extends ASplitBregmanSolver {
    private final double[][] eigenPsf2D;
    private final DoubleDCT_2D dct2d;
    private final double[][] eigenLaplacian;

    ASplitBregmanSolver2D(SolverParameters aParameters, double[][][] image, double[][][] mask, psf<DoubleType> aPsf) {
        super(aParameters, image, mask, aPsf);
        this.dct2d = new DoubleDCT_2D(this.ni, this.nj);
        this.eigenLaplacian = new double[this.ni][this.nj];
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                this.eigenLaplacian[i][j] = 2.0 - 2.0 * Math.cos((double)j * Math.PI / (double)this.nj) + (2.0 - 2.0 * Math.cos((double)i * Math.PI / (double)this.ni));
            }
        }
        this.eigenPsf2D = new double[this.ni][this.nj];
        this.compute_eigenPSF();
        this.convolveAndScale(mask[0]);
        this.calculateGradients(mask);
    }

    @Override
    public void init() {
        this.iBetaMleOut = this.betaMle[0];
        this.iBetaMleIn = this.betaMle[1];
        this.compute_eigenPSF();
        this.convolveAndScale(this.w3k[0]);
        this.calculateGradients(this.w3k);
    }

    private void convolveAndScale(double[][] aValues) {
        SolverTools.convolve2D(this.temp3[0], aValues, this.ni, this.nj, this.iPsf);
        for (int z = 0; z < this.nz; ++z) {
            for (int i = 0; i < this.ni; ++i) {
                for (int j = 0; j < this.nj; ++j) {
                    this.w1k[z][i][j] = (this.iBetaMleIn - this.iBetaMleOut) * this.temp3[z][i][j] + this.iBetaMleOut;
                }
            }
        }
    }

    private void calculateGradients(double[][][] aValues) {
        this.iLocalTools.fgradx2D(this.w2xk, aValues);
        this.iLocalTools.fgrady2D(this.w2yk, aValues);
    }

    @Override
    protected void step(boolean aEvaluateEnergy) throws InterruptedException {
        CountDownLatch ZoneDoneSignal = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync1 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync2 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync3 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync4 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync5 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync6 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync7 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync8 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync9 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync10 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync11 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Sync12 = new CountDownLatch(this.iParameters.numOfThreads);
        CountDownLatch Dct = new CountDownLatch(1);
        int ichunk = this.ni / this.iParameters.numOfThreads;
        int ilastchunk = this.ni - ichunk * (this.iParameters.numOfThreads - 1);
        int jchunk = this.nj / this.iParameters.numOfThreads;
        int jlastchunk = this.nj - jchunk * (this.iParameters.numOfThreads - 1);
        int iStart = 0;
        int jStart = 0;
        for (int nt = 0; nt < this.iParameters.numOfThreads - 1; ++nt) {
            ZoneTask2D task = new ZoneTask2D(ZoneDoneSignal, Sync1, Sync2, Sync3, Sync4, Dct, Sync5, Sync6, Sync7, Sync8, Sync9, Sync10, Sync11, Sync12, iStart, iStart + ichunk, jStart, jStart + jchunk, nt, this, this.iLocalTools, aEvaluateEnergy);
            this.executor.execute(task);
            iStart += ichunk;
            jStart += jchunk;
        }
        ZoneTask2D task = new ZoneTask2D(ZoneDoneSignal, Sync1, Sync2, Sync3, Sync4, Dct, Sync5, Sync6, Sync7, Sync8, Sync9, Sync10, Sync11, Sync12, iStart, iStart + ilastchunk, jStart, jStart + jlastchunk, this.iParameters.numOfThreads - 1, this, this.iLocalTools, aEvaluateEnergy);
        this.executor.execute(task);
        Sync4.await();
        this.dct2d.forward(this.temp1[0], true);
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                double denominator = 1.0 + this.eigenLaplacian[i][j] + this.eigenPsf2D[i][j];
                if (denominator == 0.0) continue;
                this.temp1[0][i][j] = this.temp1[0][i][j] / denominator;
            }
        }
        this.dct2d.inverse(this.temp1[0], true);
        Dct.countDown();
        ZoneDoneSignal.await();
    }

    private void compute_eigenPSF() {
        int[] sz = this.iPsf.getSuggestedImageSize();
        int xmin = Math.min(sz[0], this.eigenPsf2D.length);
        int ymin = Math.min(sz[1], this.eigenPsf2D[0].length);
        SolverTools.convolve2D(this.eigenPsf2D, this.iPsf.getImage2DAsDoubleArray(), xmin, ymin, this.iPsf);
        ArrayOps.fill(this.temp1, 0.0);
        for (int i = 0; i < xmin; ++i) {
            for (int j = 0; j < ymin; ++j) {
                this.temp1[0][i][j] = this.eigenPsf2D[i][j];
            }
        }
        int cc = sz[0] / 2 + 1;
        int cr = sz[1] / 2 + 1;
        this.iLocalTools.dctshift(this.temp3[0], this.temp1[0], cc, cr);
        this.dct2d.forward(this.temp3[0], true);
        ArrayOps.fill(this.temp2, 0.0);
        this.temp2[0][0][0] = 1.0;
        this.dct2d.forward(this.temp2[0], true);
        for (int i = 0; i < this.ni; ++i) {
            for (int j = 0; j < this.nj; ++j) {
                this.eigenPsf2D[i][j] = Math.pow(this.iBetaMleIn - this.iBetaMleOut, 2.0) * this.temp3[0][i][j] / this.temp2[0][i][j];
            }
        }
    }
}

