/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.solver;

import java.util.concurrent.CountDownLatch;
import mosaic.bregman.solver.ASplitBregmanSolver3D;
import mosaic.bregman.solver.SolverParameters;
import mosaic.bregman.solver.SolverTools;

class ZoneTask3D
implements Runnable {
    private final CountDownLatch ZoneDoneSignal;
    private final CountDownLatch Sync1;
    private final CountDownLatch Sync2;
    private final CountDownLatch Sync3;
    private final CountDownLatch Sync4;
    private final CountDownLatch Sync5;
    private final CountDownLatch Sync6;
    private final CountDownLatch Sync7;
    private final CountDownLatch Sync8;
    private final CountDownLatch Sync9;
    private final CountDownLatch Sync10;
    private final CountDownLatch Sync11;
    private final CountDownLatch Sync12;
    private final CountDownLatch Sync13;
    private final CountDownLatch Dct;
    private final ASplitBregmanSolver3D AS;
    private final int iStart;
    private final int iEnd;
    private final int jStart;
    private final int jEnd;
    private final int nt;
    private final SolverTools LocalTools;
    private final boolean iEvaluateEnergy;

    ZoneTask3D(CountDownLatch ZoneDoneSignal, CountDownLatch Sync1, CountDownLatch Sync2, CountDownLatch Sync3, CountDownLatch Sync4, CountDownLatch Sync5, CountDownLatch Sync6, CountDownLatch Sync7, CountDownLatch Sync8, CountDownLatch Sync9, CountDownLatch Sync10, CountDownLatch Sync11, CountDownLatch Sync12, CountDownLatch Sync13, CountDownLatch Dct, int iStart, int iEnd, int jStart, int jEnd, int nt, ASplitBregmanSolver3D AS, SolverTools tTools, boolean aEvaluateEnergy) {
        this.LocalTools = tTools;
        this.ZoneDoneSignal = ZoneDoneSignal;
        this.Sync1 = Sync1;
        this.Sync2 = Sync2;
        this.Sync3 = Sync3;
        this.Sync4 = Sync4;
        this.Sync5 = Sync5;
        this.Sync6 = Sync6;
        this.Sync7 = Sync7;
        this.Sync8 = Sync8;
        this.Sync9 = Sync9;
        this.Sync10 = Sync10;
        this.Sync11 = Sync11;
        this.Sync12 = Sync12;
        this.Sync13 = Sync13;
        this.Dct = Dct;
        this.AS = AS;
        this.nt = nt;
        this.iStart = iStart;
        this.jStart = jStart;
        this.iEnd = iEnd;
        this.jEnd = jEnd;
        this.iEvaluateEnergy = aEvaluateEnergy;
    }

    @Override
    public void run() {
        try {
            this.doWork();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ZoneDoneSignal.countDown();
    }

    private void doWork() throws InterruptedException {
        int j;
        int i;
        int z;
        this.LocalTools.subtab(this.AS.temp1, this.AS.w2xk, this.AS.b2xk, this.iStart, this.iEnd);
        this.LocalTools.subtab(this.AS.temp2, this.AS.w2yk, this.AS.b2yk, this.iStart, this.iEnd);
        this.LocalTools.subtab(this.AS.temp4, this.AS.w2zk, this.AS.b2zk, this.iStart, this.iEnd);
        SolverTools.synchronizedWait(this.Sync1);
        this.LocalTools.mydivergence3D(this.AS.temp3, this.AS.temp1, this.AS.temp2, this.AS.temp4, this.AS.w2zk, this.Sync2, this.iStart, this.iEnd, this.jStart, this.jEnd);
        SolverTools.synchronizedWait(this.Sync12);
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.temp2[z][i][j] = this.AS.w1k[z][i][j] - this.AS.b1k[z][i][j] - this.AS.iBetaMleOut;
                }
            }
        }
        SolverTools.synchronizedWait(this.Sync3);
        SolverTools.convolve3Dseparable(this.AS.temp4, this.AS.temp2, this.AS.ni, this.AS.nj, this.AS.nz, this.AS.iPsf, this.AS.temp1, this.iStart, this.iEnd);
        SolverTools.synchronizedWait(this.Sync11);
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.temp1[z][i][j] = -this.AS.temp3[z][i][j] + this.AS.w3k[z][i][j] - this.AS.b3k[z][i][j] + (this.AS.iBetaMleIn - this.AS.iBetaMleOut) * this.AS.temp4[z][i][j];
                }
            }
        }
        this.Sync4.countDown();
        this.Dct.await();
        SolverTools.convolve3Dseparable(this.AS.temp2, this.AS.temp1, this.AS.ni, this.AS.nj, this.AS.nz, this.AS.iPsf, this.AS.temp3, this.iStart, this.iEnd);
        SolverTools.synchronizedWait(this.Sync10);
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.temp2[z][i][j] = (this.AS.iBetaMleIn - this.AS.iBetaMleOut) * this.AS.temp2[z][i][j] + this.AS.iBetaMleOut;
                }
            }
        }
        if (this.AS.iParameters.noiseModel == SolverParameters.NoiseModel.POISSON) {
            for (z = 0; z < this.AS.nz; ++z) {
                for (i = this.iStart; i < this.iEnd; ++i) {
                    for (j = 0; j < this.AS.nj; ++j) {
                        double[] dArray = this.AS.temp3[z][i];
                        this.AS.iParameters.getClass();
                        double d = 1.0 / this.AS.iRegularization;
                        this.AS.iParameters.getClass();
                        double d2 = Math.pow(d * 1.0 - this.AS.b1k[z][i][j] - this.AS.temp2[z][i][j], 2.0);
                        this.AS.iParameters.getClass();
                        double d3 = 4.0 * (1.0 / this.AS.iRegularization);
                        this.AS.iParameters.getClass();
                        dArray[j] = d2 + d3 * 1.0 * this.AS.iImage[z][i][j];
                    }
                }
            }
            for (z = 0; z < this.AS.nz; ++z) {
                for (i = this.iStart; i < this.iEnd; ++i) {
                    for (j = 0; j < this.AS.nj; ++j) {
                        double[] dArray = this.AS.w1k[z][i];
                        double d = this.AS.b1k[z][i][j] + this.AS.temp2[z][i][j];
                        this.AS.iParameters.getClass();
                        double d4 = 1.0 / this.AS.iRegularization;
                        this.AS.iParameters.getClass();
                        dArray[j] = 0.5 * (d - d4 * 1.0 + Math.sqrt(this.AS.temp3[z][i][j]));
                    }
                }
            }
        } else {
            for (z = 0; z < this.AS.nz; ++z) {
                for (i = this.iStart; i < this.iEnd; ++i) {
                    for (j = 0; j < this.AS.nj; ++j) {
                        double[] dArray = this.AS.w1k[0][i];
                        double d = this.AS.b1k[z][i][j] + this.AS.temp2[z][i][j];
                        this.AS.iParameters.getClass();
                        double d5 = 2.0 * (1.0 / this.AS.iRegularization);
                        this.AS.iParameters.getClass();
                        double d6 = d + d5 * 1.0 * this.AS.iImage[0][i][j];
                        this.AS.iParameters.getClass();
                        double d7 = 2.0 * (1.0 / this.AS.iRegularization);
                        this.AS.iParameters.getClass();
                        dArray[j] = d6 / (1.0 + d7 * 1.0);
                    }
                }
            }
        }
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.w3k[z][i][j] = Math.max(Math.min(this.AS.temp1[z][i][j] + this.AS.b3k[z][i][j], 1.0), 0.0);
                }
            }
        }
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.b1k[z][i][j] = this.AS.b1k[z][i][j] + this.AS.temp2[z][i][j] - this.AS.w1k[z][i][j];
                    this.AS.b3k[z][i][j] = this.AS.b3k[z][i][j] + this.AS.temp1[z][i][j] - this.AS.w3k[z][i][j];
                }
            }
        }
        SolverTools.synchronizedWait(this.Sync5);
        this.LocalTools.fgradx2D(this.AS.temp3, this.AS.temp1, this.jStart, this.jEnd);
        this.LocalTools.fgrady2D(this.AS.temp4, this.AS.temp1, this.iStart, this.iEnd);
        this.LocalTools.fgradz2D(this.AS.ukz, this.AS.temp1, this.iStart, this.iEnd);
        SolverTools.synchronizedWait(this.Sync6);
        this.LocalTools.addtab(this.AS.w2xk, this.AS.temp3, this.AS.b2xk, this.iStart, this.iEnd);
        this.LocalTools.addtab(this.AS.w2yk, this.AS.temp4, this.AS.b2yk, this.iStart, this.iEnd);
        this.LocalTools.addtab(this.AS.w2zk, this.AS.ukz, this.AS.b2zk, this.iStart, this.iEnd);
        double[][][] dArray = this.AS.w2xk;
        double[][][] dArray2 = this.AS.w2yk;
        double[][][] dArray3 = this.AS.w2zk;
        double[][][] dArray4 = this.AS.w2xk;
        double[][][] dArray5 = this.AS.w2yk;
        double[][][] dArray6 = this.AS.w2zk;
        this.AS.iParameters.getClass();
        this.LocalTools.shrink3D(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, 1.0, this.iStart, this.iEnd);
        for (z = 0; z < this.AS.nz; ++z) {
            for (i = this.iStart; i < this.iEnd; ++i) {
                for (j = 0; j < this.AS.nj; ++j) {
                    this.AS.b2xk[z][i][j] = this.AS.b2xk[z][i][j] + this.AS.temp3[z][i][j] - this.AS.w2xk[z][i][j];
                    this.AS.b2yk[z][i][j] = this.AS.b2yk[z][i][j] + this.AS.temp4[z][i][j] - this.AS.w2yk[z][i][j];
                    this.AS.b2zk[z][i][j] = this.AS.b2zk[z][i][j] + this.AS.ukz[z][i][j] - this.AS.w2zk[z][i][j];
                }
            }
        }
        SolverTools.synchronizedWait(this.Sync7);
        if (this.iEvaluateEnergy) {
            double[] dArray7 = this.AS.iEnergies;
            double[][][] dArray8 = this.AS.temp1;
            double[][][] dArray9 = this.AS.w3k;
            double[][][] dArray10 = this.AS.temp3;
            double[][][] dArray11 = this.AS.temp4;
            this.AS.iParameters.getClass();
            dArray7[this.nt] = this.LocalTools.computeEnergyPSF3D(dArray8, dArray9, dArray10, dArray11, 1.0, this.AS.iRegularization, this.AS.iPsf, this.AS.iBetaMleOut, this.AS.iBetaMleIn, this.AS.iImage, this.iStart, this.iEnd, this.jStart, this.jEnd, this.Sync8, this.Sync9, this.Sync13, this.AS.iNoiseModel);
        }
    }
}

