/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import mosaic.core.cluster.JobStatus;

class ClusterStatusStack {
    ClusterStatusStack() {
    }

    private ColorProcessor createResult(JobStatus js) {
        ColorProcessor ip = null;
        if (js == null) {
            ip = new ColorProcessor(200, 50);
            ip.setColor(new Color(0, 0, 255));
            ip.fill();
            ip.setColor(new Color(0, 0, 0));
            ip.drawString("UNKNOWN", 10, 25);
        } else if (js.getStatus() == JobStatus.jobS.PENDING) {
            if (js.getNotifiedStatus() != JobStatus.jobS.PENDING) {
                ip = new ColorProcessor(200, 50);
                ip.setColor(new Color(255, 164, 0));
                ip.fill();
                ip.setColor(new Color(0, 0, 0));
                ip.drawString(js.getStatus().toString(), 10, 25);
                js.setNotifiedStatus(JobStatus.jobS.PENDING);
            }
        } else if (js.getStatus() == JobStatus.jobS.RUNNING) {
            if (js.getNotifiedStatus() != JobStatus.jobS.RUNNING) {
                ip = new ColorProcessor(200, 50);
                ip.setColor(new Color(255, 255, 0));
                ip.fill();
                ip.setColor(new Color(0, 0, 0));
                ip.drawString(js.getStatus().toString(), 10, 25);
                js.setNotifiedStatus(JobStatus.jobS.RUNNING);
            }
        } else if (js.getStatus() == JobStatus.jobS.COMPLETE) {
            if (js.getNotifiedStatus() != JobStatus.jobS.COMPLETE) {
                ip = new ColorProcessor(200, 50);
                ip.setColor(new Color(0, 255, 0));
                ip.fill();
                ip.setColor(new Color(0, 0, 0));
                ip.drawString(js.getStatus().toString(), 10, 25);
                js.setNotifiedStatus(JobStatus.jobS.COMPLETE);
            }
        } else if (js.getStatus() == JobStatus.jobS.FAILED) {
            if (js.getNotifiedStatus() != JobStatus.jobS.FAILED) {
                ip = new ColorProcessor(200, 50);
                ip.setColor(new Color(255, 0, 0));
                ip.fill();
                ip.setColor(new Color(0, 0, 0));
                ip.drawString(js.getStatus().toString(), 10, 25);
                js.setNotifiedStatus(JobStatus.jobS.FAILED);
            }
        } else if (js.getStatus() == JobStatus.jobS.UNKNOWN && js.getNotifiedStatus() != JobStatus.jobS.UNKNOWN) {
            ip = new ColorProcessor(200, 50);
            ip.setColor(new Color(0, 0, 255));
            ip.fill();
            ip.setColor(new Color(0, 0, 0));
            ip.drawString(js.getStatus().toString(), 10, 25);
            js.setNotifiedStatus(JobStatus.jobS.UNKNOWN);
        }
        if (ip == null) {
            return null;
        }
        return ip;
    }

    ImageStack CreateStack(JobStatus[] jb) {
        ImageStack is = new ImageStack(200, 50);
        for (int i = 0; i < jb.length; ++i) {
            is.addSlice("Job " + i + 1, (ImageProcessor)this.createResult(jb[i]));
        }
        return is;
    }

    void UpdateStack(ImageStack ip, JobStatus[] jb) {
        for (int i = 0; i < jb.length; ++i) {
            if (jb[i] == null || jb[i].getNotifiedStatus() == jb[i].getStatus()) continue;
            ip.deleteSlice(i + 1);
            ip.addSlice("Staus job: " + i + 1, (ImageProcessor)this.createResult(jb[i]), i);
        }
    }
}

