/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.DataCompression;
import mosaic.core.cluster.GeneralProfile;
import mosaic.core.cluster.LSFBatch;

class MadMaxProfile
extends GeneralProfile {
    MadMaxProfile() {
        this.setAcc(ClusterProfile.hw.CPU);
        this.setQueue(60.0, "short");
        this.setQueue(480.0, "medium");
        this.setQueue(Double.MAX_VALUE, "long");
        this.setAcc(ClusterProfile.hw.GPU);
        this.setQueue(720.0, "gpu");
        this.setBatchSystem(new LSFBatch(this));
        this.setAcc(ClusterProfile.hw.CPU);
    }

    @Override
    public String getProfileName() {
        return "Mad Max";
    }

    @Override
    public void setProfileName(String ProfileName_) {
    }

    @Override
    public String getAccessAddress() {
        return "falcon";
    }

    @Override
    public String getRunningDir() {
        return "/scratch/users/" + this.UserName + "/";
    }

    @Override
    public void setRunningDir(String RunningDir_) {
    }

    @Override
    public String getImageJCommand() {
        return "fiji";
    }

    @Override
    public void setImageJCommand(String ImageJCommand_) {
    }

    @Override
    public boolean hasCompressor(DataCompression.Algorithm a) {
        if (a == null) {
            return true;
        }
        if (a.name.equals("TAR")) {
            return true;
        }
        return a.name.equals("ZIP");
    }
}

