/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.detection;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackStatistics;
import java.util.Arrays;
import java.util.Vector;
import mosaic.core.detection.Particle;
import mosaic.core.imageUtils.convolution.Convolver;
import mosaic.core.imageUtils.convolution.Kernel1D;
import mosaic.core.imageUtils.convolution.Kernel2D;
import mosaic.core.imageUtils.convolution.Kernel3D;
import mosaic.core.utils.DilateImage;
import org.apache.log4j.Logger;

public class FeaturePointDetector {
    private static final Logger logger = Logger.getLogger(FeaturePointDetector.class);
    private float iGlobalMax;
    private float iGlobalMin;
    private double iCutoff;
    private float iPercentile;
    private int iRadius;
    private float iAbsIntensityThreshold;
    private Mode iThresholdMode = Mode.PERCENTILE_MODE;
    private Vector<Particle> iParticles;
    private int[][] iMask;

    public FeaturePointDetector(float aGlobalMax, float aGlobalMin) {
        this.iGlobalMax = aGlobalMax;
        this.iGlobalMin = aGlobalMin;
        this.setDetectionParameters(0.001f, 0.005f, 3, 0.0f, false);
    }

    public Vector<Particle> featurePointDetection(ImageStack original_ips) {
        ImageStack restored_fps = new ImageStack(original_ips.getWidth(), original_ips.getHeight());
        for (int i = 1; i <= original_ips.getSize(); ++i) {
            restored_fps.addSlice(null, original_ips.getProcessor(i).convertToFloat().duplicate());
        }
        this.normalizeFrameFloat(restored_fps, this.iGlobalMin, this.iGlobalMax);
        restored_fps = this.imageRestoration(restored_fps);
        this.pointLocationsEstimation(restored_fps);
        this.pointLocationsRefinement(restored_fps);
        this.nonParticleDiscrimination();
        return this.iParticles;
    }

    private void normalizeFrameFloat(ImageStack is, float global_min, float global_max) {
        for (int s = 1; s <= is.getSize(); ++s) {
            float[] pixels = (float[])is.getPixels(s);
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (pixels[i] - global_min) / (global_max - global_min);
            }
        }
    }

    private float findThreshold(ImageStack ips, double percent, float absIntensityThreshold2) {
        int i;
        if (this.iThresholdMode == Mode.ABS_THRESHOLD_MODE) {
            StackStatistics stack_stats = new StackStatistics(new ImagePlus("", ips));
            float max = (float)stack_stats.max;
            float min = (float)stack_stats.min;
            float threshold = (absIntensityThreshold2 - this.iGlobalMin) / (this.iGlobalMax - this.iGlobalMin);
            float threshold2 = threshold * (max - min) + min;
            logger.debug((Object)("Calculated absolute threshold: " + threshold + " for params[" + absIntensityThreshold2 + ", " + this.iGlobalMin + ", " + this.iGlobalMax + "]"));
            logger.debug((Object)("New min/max: " + min + "/" + max + " New threshold: " + threshold2));
            return (absIntensityThreshold2 - this.iGlobalMin) / (this.iGlobalMax - this.iGlobalMin);
        }
        int width = ips.getWidth();
        float min = 0.0f;
        float max = 0.0f;
        if (ips.getSize() > 1) {
            StackStatistics sstats = new StackStatistics(new ImagePlus(null, ips));
            min = (float)sstats.min;
            max = (float)sstats.max;
        } else {
            ImageStatistics istats = ImageStatistics.getStatistics((ImageProcessor)ips.getProcessor(1), (int)28, null);
            min = (float)istats.min;
            max = (float)istats.max;
        }
        double[] hist = new double[256];
        for (i = 0; i < hist.length; ++i) {
            hist[i] = 0.0;
        }
        for (int s = 0; s < ips.getSize(); ++s) {
            float[] pixels = (float[])ips.getProcessor(s + 1).getPixels();
            for (i = 0; i < ips.getHeight(); ++i) {
                for (int j = 0; j < ips.getWidth(); ++j) {
                    int n = (int)((double)(pixels[i * width + j] - min) * 255.0 / (double)(max - min));
                    hist[n] = hist[n] + 1.0;
                }
            }
        }
        for (i = 254; i >= 0; --i) {
            int n = i;
            hist[n] = hist[n] + hist[i + 1];
        }
        int thold = 0;
        while (hist[255 - thold] / hist[0] < percent && ++thold <= 255) {
        }
        thold = 255 - thold + 1;
        return (float)((double)thold / 255.0) * (max - min) + min;
    }

    private void pointLocationsEstimation(ImageStack ips) {
        float threshold = this.findThreshold(ips, this.iPercentile, this.iAbsIntensityThreshold);
        ImageStack dilated_ips = DilateImage.dilate(ips, this.iRadius, 4);
        this.iParticles = new Vector();
        int height = ips.getHeight();
        int width = ips.getWidth();
        float depthShift = ips.getSize() > 1 ? 0.5f : 0.0f;
        for (int s = 0; s < ips.getSize(); ++s) {
            float[] ips_pixels = (float[])ips.getProcessor(s + 1).getPixels();
            float[] ips_dilated_pixels = (float[])dilated_ips.getProcessor(s + 1).getPixels();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    if (!(ips_pixels[i * width + j] > threshold) || ips_pixels[i * width + j] != ips_dilated_pixels[i * width + j]) continue;
                    this.iParticles.add(new Particle((float)j + 0.5f, (float)i + 0.5f, (float)s + depthShift, -1));
                }
            }
        }
        logger.info((Object)("Detected " + this.iParticles.size() + " particles."));
    }

    private void pointLocationsRefinement(ImageStack ips) {
        int mask_width = 2 * this.iRadius + 1;
        int imageWidth = ips.getWidth();
        int imageHeight = ips.getHeight();
        int imageDepth = ips.getSize();
        for (int s = 0; s < ips.getSize(); ++s) {
            float[] pixels = (float[])ips.getPixels(s + 1);
            for (int i = 0; i < pixels.length; ++i) {
                if (!(pixels[i] < 0.0f)) continue;
                pixels[i] = 0.0f;
            }
        }
        for (int m = 0; m < this.iParticles.size(); ++m) {
            int tz;
            int ty;
            int tx;
            Particle currentParticle = this.iParticles.elementAt(m);
            float epsx = 0.0f;
            float epsy = 0.0f;
            float epsz = 0.0f;
            do {
                currentParticle.m0 = 0.0f;
                currentParticle.m1 = 0.0f;
                currentParticle.m2 = 0.0f;
                currentParticle.m3 = 0.0f;
                currentParticle.m4 = 0.0f;
                epsx = 0.0f;
                epsy = 0.0f;
                epsz = 0.0f;
                for (int s = -this.iRadius; s <= this.iRadius; ++s) {
                    if ((int)currentParticle.iZ + s < 0 || (int)currentParticle.iZ + s >= imageDepth) continue;
                    int z = (int)currentParticle.iZ + s;
                    float[] pixels = (float[])ips.getPixels(z + 1);
                    for (int k = -this.iRadius; k <= this.iRadius; ++k) {
                        if ((int)currentParticle.iY + k < 0 || (int)currentParticle.iY + k >= imageHeight) continue;
                        int y = (int)currentParticle.iY + k;
                        for (int l = -this.iRadius; l <= this.iRadius; ++l) {
                            if ((int)currentParticle.iX + l < 0 || (int)currentParticle.iX + l >= imageWidth) continue;
                            int x = (int)currentParticle.iX + l;
                            float c = pixels[y * imageWidth + x] * (float)this.iMask[s + this.iRadius][(k + this.iRadius) * mask_width + (l + this.iRadius)];
                            epsx += (float)l * c;
                            epsy += (float)k * c;
                            epsz += (float)s * c;
                            currentParticle.m0 += c;
                            int squaredDistance = k * k + l * l + s * s;
                            currentParticle.m1 += (float)Math.sqrt(squaredDistance) * c;
                            currentParticle.m2 += (float)squaredDistance * c;
                            currentParticle.m3 += (float)Math.pow(squaredDistance, 1.5) * c;
                            currentParticle.m4 += (float)Math.pow(squaredDistance, 2.0) * c;
                        }
                    }
                }
                epsx /= currentParticle.m0;
                epsy /= currentParticle.m0;
                epsz /= currentParticle.m0;
                currentParticle.m1 /= currentParticle.m0;
                currentParticle.m2 /= currentParticle.m0;
                currentParticle.m3 /= currentParticle.m0;
                currentParticle.m4 /= currentParticle.m0;
                tx = (int)(10.0 * (double)epsx);
                ty = (int)(10.0 * (double)epsy);
                tz = (int)(10.0 * (double)epsz);
                if ((double)tx / 10.0 > 0.5) {
                    if ((int)currentParticle.iX + 1 < imageWidth) {
                        currentParticle.iX += 1.0f;
                    }
                } else if ((double)tx / 10.0 < -0.5 && (int)currentParticle.iX - 1 >= 0) {
                    currentParticle.iX -= 1.0f;
                }
                if ((double)ty / 10.0 > 0.5) {
                    if ((int)currentParticle.iY + 1 < imageHeight) {
                        currentParticle.iY += 1.0f;
                    }
                } else if ((double)ty / 10.0 < -0.5 && (int)currentParticle.iY - 1 >= 0) {
                    currentParticle.iY -= 1.0f;
                }
                if ((double)tz / 10.0 > 0.5) {
                    if ((int)currentParticle.iZ + 1 >= imageDepth) continue;
                    currentParticle.iZ += 1.0f;
                    continue;
                }
                if (!((double)tz / 10.0 < -0.5) || (int)currentParticle.iZ - 1 < 0) continue;
                currentParticle.iZ -= 1.0f;
            } while (!((double)tx / 10.0 <= 0.5 && (double)tx / 10.0 >= -0.5 && (double)ty / 10.0 <= 0.5 && (double)ty / 10.0 >= -0.5 && (double)tz / 10.0 <= 0.5 && (double)tz / 10.0 >= -0.5) && ((double)epsx > 0.5 || (double)epsx < -0.5 || (double)epsy > 0.5 || (double)epsy < -0.5 || (double)epsz > 0.5 || (double)epsz < -0.5));
            currentParticle.iX += epsx;
            currentParticle.iY += epsy;
            currentParticle.iZ += epsz;
        }
    }

    private void nonParticleDiscrimination() {
        if (this.iParticles.size() == 1) {
            this.iParticles.elementAt((int)0).nonParticleDiscriminationScore = Float.MAX_VALUE;
            this.iParticles.elementAt((int)0).special = true;
        }
        int maxX = 1;
        int maxY = 1;
        int maxZ = 1;
        for (int j = 0; j < this.iParticles.size(); ++j) {
            Particle pJ = this.iParticles.elementAt(j);
            pJ.special = true;
            pJ.nonParticleDiscriminationScore = 0.0f;
            maxX = Math.max((int)pJ.iX, maxX);
            maxY = Math.max((int)pJ.iY, maxY);
            maxZ = Math.max((int)pJ.iZ, maxZ);
        }
        boolean[][][] takenPositions = new boolean[maxZ + 3][maxY + 3][maxX + 3];
        for (int j = 0; j < this.iParticles.size(); ++j) {
            Particle pJ = this.iParticles.elementAt(j);
            boolean particleInNeighborhood = false;
            for (int oz = -1; !particleInNeighborhood && oz <= 1; ++oz) {
                for (int oy = -1; !particleInNeighborhood && oy <= 1; ++oy) {
                    for (int ox = -1; !particleInNeighborhood && ox <= 1; ++ox) {
                        if (!takenPositions[(int)pJ.iZ + 1 + oz][(int)pJ.iY + 1 + oy][(int)pJ.iX + 1 + ox]) continue;
                        particleInNeighborhood = true;
                    }
                }
            }
            if (particleInNeighborhood) {
                pJ.special = false;
                continue;
            }
            takenPositions[(int)pJ.iZ + 1][(int)pJ.iY + 1][(int)pJ.iX + 1] = true;
        }
        int Nt = 0;
        for (int j = 0; j < this.iParticles.size(); ++j) {
            if (!this.iParticles.elementAt((int)j).special) continue;
            ++Nt;
        }
        logger.debug((Object)("Detected " + Nt + " non duplicated particles."));
        int countValid = 0;
        double sigma0 = 0.1;
        double sigma2 = 0.1;
        for (int j = 0; j < this.iParticles.size(); ++j) {
            Particle pJ = this.iParticles.elementAt(j);
            if (!pJ.special) continue;
            for (int k = j; k < this.iParticles.size(); ++k) {
                Particle pK = this.iParticles.elementAt(k);
                if (!pK.special) continue;
                double score = 1.0 / (Math.PI * 2 * sigma0 * sigma2 * (double)Nt) * Math.exp(-Math.pow(pJ.m0 - pK.m0, 2.0) / (2.0 * sigma0 * sigma0) - Math.pow(pJ.m2 - pK.m2, 2.0) / (2.0 * sigma2 * sigma2));
                pJ.nonParticleDiscriminationScore = (float)((double)pJ.nonParticleDiscriminationScore + score);
                if (j == k) continue;
                pK.nonParticleDiscriminationScore = (float)((double)pK.nonParticleDiscriminationScore + score);
            }
            pJ.nonParticleDiscriminationScore = (float)((double)pJ.nonParticleDiscriminationScore / (1.0 / (Math.PI * 2 * sigma0 * sigma2)));
            if ((double)pJ.nonParticleDiscriminationScore < this.iCutoff) {
                pJ.special = false;
                continue;
            }
            ++countValid;
        }
        logger.info((Object)("Detected " + countValid + " after non particle discrimination phase."));
    }

    private ImageStack imageRestoration(ImageStack is) {
        boolean is3D;
        Convolver img = new Convolver(is.getWidth(), is.getHeight(), is.getSize());
        img.initFromImageStack(is);
        Convolver gaussImg = new Convolver(is.getWidth(), is.getHeight(), is.getSize());
        GaussSeparable1D gauss = new GaussSeparable1D(1, this.iRadius);
        gaussImg.x1D(img, gauss);
        gaussImg.y1D(gauss);
        Convolver backgroundImg = new Convolver(is.getWidth(), is.getHeight(), is.getSize());
        CarBoxSeparable1D carbox = new CarBoxSeparable1D(this.iRadius);
        backgroundImg.x1D(img, carbox);
        backgroundImg.y1D(carbox);
        boolean bl = is3D = is.getSize() > 1;
        if (is3D) {
            gaussImg.z1D(gauss);
            backgroundImg.z1D(carbox);
        }
        gaussImg.sub(backgroundImg).div(this.calculateK0(is3D ? 3 : 2, 1, this.iRadius));
        return gaussImg.getImageStack();
    }

    public double calculateK0(int dimension, int lambda, int radius) {
        double B = 0.0;
        for (int i = -radius; i <= radius; ++i) {
            B += Math.exp((double)(-(i * i)) / (4.0 * (double)lambda * (double)lambda));
        }
        B = Math.pow(B, dimension);
        double K0 = 0.0;
        for (int i = -radius; i <= radius; ++i) {
            K0 += Math.exp((double)(-(i * i)) / (2.0 * (double)lambda * (double)lambda));
        }
        int width = 2 * radius + 1;
        K0 = Math.pow(K0, dimension) / B - B / Math.pow(width, dimension);
        return K0;
    }

    private void generateDilationMasks(int mask_radius) {
        this.iMask = DilateImage.generateMask(mask_radius);
    }

    public boolean setDetectionParameters(double cutoff, float percentile, int radius, float Threshold, boolean absolute) {
        boolean changed = radius != this.iRadius || cutoff != this.iCutoff || percentile != this.iPercentile;
        this.iCutoff = cutoff;
        this.iPercentile = percentile;
        this.iAbsIntensityThreshold = Threshold;
        this.iRadius = radius;
        this.iThresholdMode = absolute ? Mode.ABS_THRESHOLD_MODE : Mode.PERCENTILE_MODE;
        logger.info((Object)("Detection options: radius=" + this.iRadius + " cutoff=" + this.iCutoff + " percentile=" + this.iPercentile + " threshold=" + this.iAbsIntensityThreshold + " mode=" + (absolute ? "THRESHOLD" : "PERCENTILE")));
        this.generateDilationMasks(this.iRadius);
        return changed;
    }

    public int getRadius() {
        return this.iRadius;
    }

    public Mode getThresholdMode() {
        return this.iThresholdMode;
    }

    public float getGlobalMax() {
        return this.iGlobalMax;
    }

    public float getGlobalMin() {
        return this.iGlobalMin;
    }

    public void setGlobalMax(float aValue) {
        this.iGlobalMax = aValue;
    }

    public void setGlobalMin(float aValue) {
        this.iGlobalMin = aValue;
    }

    public double getCutoff() {
        return this.iCutoff;
    }

    public float getPercentile() {
        return this.iPercentile;
    }

    public float getAbsIntensityThreshold() {
        return this.iAbsIntensityThreshold;
    }

    public class RestorationKernel3D
    extends Kernel3D {
        public RestorationKernel3D(int lambda, int radius) {
            this.k = this.resorationKernel3D(lambda, radius);
            int width = this.k[0].length;
            this.iHalfWidth = width / 2;
        }

        private double[][][] resorationKernel3D(float lambda, int radius) {
            int i;
            int width = 2 * radius + 1;
            double[][][] kernel = new double[width][width][width];
            double B = 0.0;
            for (int i2 = -radius; i2 <= radius; ++i2) {
                B += Math.exp((double)(-(i2 * i2)) / (4.0 * (double)lambda * (double)lambda));
            }
            B = B * B * B;
            double K0 = 0.0;
            for (i = -radius; i <= radius; ++i) {
                K0 += Math.exp((double)(-(i * i)) / (2.0 * (double)lambda * (double)lambda));
            }
            K0 = K0 * K0 * K0 / B - B / (double)(width * width * width);
            for (i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        kernel[i + radius][j + radius][k + radius] = 1.0 / B * Math.exp(-((float)(i * i + j * j + k * k) / (4.0f * lambda * lambda))) - (double)(1.0f / (float)(width * width * width));
                        double[] dArray = kernel[i + radius][j + radius];
                        int n = k + radius;
                        dArray[n] = dArray[n] / K0;
                    }
                }
            }
            return kernel;
        }

        public String toString() {
            return "Gauss/BoxCar 3D";
        }
    }

    public class RestorationKernel2D
    extends Kernel2D {
        public RestorationKernel2D(int lambda, int radius) {
            this.k = this.resorationKernel2D(lambda, radius);
            int width = this.k[0].length;
            this.iHalfWidth = width / 2;
        }

        private double[][] resorationKernel2D(float lambda, int radius) {
            int i;
            int width = 2 * radius + 1;
            double[][] kernel = new double[width][width];
            double B = 0.0;
            for (int i2 = -radius; i2 <= radius; ++i2) {
                B += Math.exp((double)(-(i2 * i2)) / (4.0 * (double)lambda * (double)lambda));
            }
            B *= B;
            double K0 = 0.0;
            for (i = -radius; i <= radius; ++i) {
                K0 += Math.exp((double)(-(i * i)) / (2.0 * (double)lambda * (double)lambda));
            }
            K0 = K0 * K0 / B - B / (double)(width * width);
            for (i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    kernel[i + radius][j + radius] = 1.0 / B * Math.exp(-((float)(i * i + j * j) / (4.0f * lambda * lambda))) - (double)(1.0f / (float)(width * width));
                    double[] dArray = kernel[i + radius];
                    int n = j + radius;
                    dArray[n] = dArray[n] / K0;
                }
            }
            return kernel;
        }

        public String toString() {
            return "Gauss/BoxCar 2D";
        }
    }

    public class CarBoxSeparable1D
    extends Kernel1D {
        public CarBoxSeparable1D(int radius) {
            int width = 2 * radius + 1;
            this.k = new double[width];
            Arrays.fill(this.k, 1.0 / (double)width);
            this.iHalfWidth = radius;
        }
    }

    public class GaussSeparable1D
    extends Kernel1D {
        public GaussSeparable1D(int lambda, int radius) {
            this.k = this.gaussSeparable1D(lambda, radius);
            this.iHalfWidth = this.k.length / 2;
        }

        private double[] gaussSeparable1D(double lambda, int radius) {
            int i;
            int width = 2 * radius + 1;
            double[] kernel = new double[width];
            double B = 0.0;
            for (i = -radius; i <= radius; ++i) {
                B += Math.exp((double)(-(i * i)) / (4.0 * lambda * lambda));
            }
            for (i = -radius; i <= radius; ++i) {
                kernel[i + radius] = 1.0 / B * Math.exp(-((double)(i * i) / (4.0 * lambda * lambda)));
            }
            return kernel;
        }
    }

    public static enum Mode {
        ABS_THRESHOLD_MODE,
        PERCENTILE_MODE;

    }
}

