/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.detection;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import mosaic.core.detection.FeaturePointDetector;
import mosaic.core.detection.PreviewCanvas;
import mosaic.core.detection.PreviewInterface;

public class GUIhelper {
    public static Boolean getUserDefinedParameters(GenericDialog gd, FeaturePointDetector fpd) {
        int rad = (int)gd.getNextNumber();
        double cut = gd.getNextNumber();
        float per = (float)gd.getNextNumber() / 100.0f;
        float intThreshold = per * 100.0f;
        boolean absolute = gd.getNextBoolean();
        return fpd.setDetectionParameters(cut, per, rad, intThreshold, absolute);
    }

    public static Boolean getUserDefinedPreviewParams(GenericDialog gd, FeaturePointDetector fpd) {
        Vector vec = gd.getNumericFields();
        Vector vecb = gd.getCheckboxes();
        int rad = Integer.parseInt(((TextField)vec.elementAt(0)).getText());
        double cut = Double.parseDouble(((TextField)vec.elementAt(1)).getText());
        float per = Float.parseFloat(((TextField)vec.elementAt(2)).getText()) / 100.0f;
        float intThreshold = per * 100.0f;
        boolean absolute = ((Checkbox)vecb.elementAt(0)).getState();
        return fpd.setDetectionParameters(cut, per, rad, intThreshold, absolute);
    }

    public static void addUserDefinedParametersDialog(GenericDialog gd, FeaturePointDetector fpd) {
        gd.addMessage("Particle Detection:");
        gd.addNumericField("Radius", (double)fpd.getRadius(), 0, 7, null);
        gd.addNumericField("Cutoff [0-1]", fpd.getCutoff(), 3, 7, null);
        gd.addNumericField("Per/Abs", (double)(fpd.getPercentile() * 100.0f), 3, 7, null);
        gd.addCheckbox("Absolute", fpd.getThresholdMode() == FeaturePointDetector.Mode.ABS_THRESHOLD_MODE);
    }

    public static PreviewCanvas generatePreviewCanvas(ImagePlus imp) {
        double magnification = imp.getWindow() != null ? imp.getWindow().getCanvas().getMagnification() : 1.0;
        PreviewCanvas preview_canvas = new PreviewCanvas(imp, magnification);
        StackWindow sw = new StackWindow(imp, (ImageCanvas)preview_canvas);
        while (sw.getCanvas().getMagnification() < magnification) {
            preview_canvas.zoomIn(0, 0);
        }
        return preview_canvas;
    }

    public static Panel makePreviewPanel(final PreviewInterface previewHandler, final ImagePlus img) {
        Scrollbar preview_scrollbarZ;
        Panel preview_panel = new Panel();
        GridBagLayout gridbag = new GridBagLayout();
        preview_panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        int[] position = img.convertIndexToPosition(img.getCurrentSlice());
        final Scrollbar preview_scrollbar = new Scrollbar(0, position[2], 1, 1, img.getNFrames() + 1);
        preview_scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int[] position = img.convertIndexToPosition(img.getCurrentSlice());
                img.setPosition(position[0], position[1], preview_scrollbar.getValue());
            }
        });
        preview_scrollbar.setUnitIncrement(1);
        preview_scrollbar.setBlockIncrement(1);
        int nDepth = img.getNSlices();
        if (nDepth > 1) {
            preview_scrollbarZ = new Scrollbar(0, position[1], 1, 1, img.getNSlices() + 1);
            preview_scrollbarZ.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    int[] position = img.convertIndexToPosition(img.getCurrentSlice());
                    img.setPosition(position[0], preview_scrollbarZ.getValue(), position[2]);
                }
            });
            preview_scrollbarZ.setUnitIncrement(1);
            preview_scrollbarZ.setBlockIncrement(1);
        } else {
            preview_scrollbarZ = null;
        }
        Button preview = new Button("Preview Detected");
        preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] position = img.convertIndexToPosition(img.getCurrentSlice());
                previewHandler.preview(e, position[1]);
            }
        });
        Button save_detected = new Button("Save Detected");
        save_detected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                previewHandler.saveDetected(e);
            }
        });
        gridbag.setConstraints(preview, c);
        preview_panel.add(preview);
        gridbag.setConstraints(preview_scrollbar, c);
        preview_panel.add(preview_scrollbar);
        if (nDepth > 1) {
            gridbag.setConstraints(preview_scrollbarZ, c);
            preview_panel.add(preview_scrollbarZ);
        }
        gridbag.setConstraints(save_detected, c);
        preview_panel.add(save_detected);
        Label previewLabel = new Label("");
        gridbag.setConstraints(previewLabel, c);
        preview_panel.add(previewLabel);
        Label seperation = new Label("______________", 1);
        gridbag.setConstraints(seperation, c);
        preview_panel.add(seperation);
        return preview_panel;
    }
}

