/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.detection;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class Particle {
    public float iX;
    public float iY;
    public float iZ;
    public float m0 = 0.0f;
    public float m1 = 0.0f;
    public float m2 = 0.0f;
    public float m3 = 0.0f;
    public float m4 = 0.0f;
    float original_x = 0.0f;
    float original_y = 0.0f;
    float original_z = 0.0f;
    private int frame = 0;
    public float nonParticleDiscriminationScore = 0.0f;
    public boolean special = true;
    public int[] next = null;
    public float distance = -1.0f;
    public float lx;
    public float ly;
    public float lz;
    public float lxa;
    public float lya;
    public float lza;
    public static final String[] ParticleDetection_map = new String[]{"Frame", "x", "y", "z", "Size"};
    public static final CellProcessor[] ParticleDetectionCellProcessor = new CellProcessor[]{new ParseInt(), new ParseDouble(), new ParseDouble(), new ParseDouble(), new ParseDouble()};

    Particle(Particle aParticle) {
        this.iX = aParticle.iX;
        this.iY = aParticle.iY;
        this.iZ = aParticle.iZ;
        this.m0 = aParticle.m0;
        this.m1 = aParticle.m1;
        this.m2 = aParticle.m2;
        this.m3 = aParticle.m3;
        this.m4 = aParticle.m4;
        this.frame = aParticle.frame;
    }

    public Particle(float aX, float aY, float aZ, int aFrameNumber) {
        this.iX = aX;
        this.original_x = aX;
        this.iY = aY;
        this.original_y = aY;
        this.iZ = aZ;
        this.original_z = aZ;
        this.frame = aFrameNumber;
    }

    public Particle() {
    }

    void translate(Rectangle focus) {
        this.iX -= (float)focus.x;
        this.iY -= (float)focus.y;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        StringBuffer result = new StringBuffer();
        String space = " ";
        DecimalFormat nf = new DecimalFormat("######0.000000");
        nf.setGroupingUsed(false);
        result.append(this.getFrame());
        result.append(" ");
        result.append(nf.format(this.iX));
        result.append(" ");
        result.append(nf.format(this.iY));
        result.append(" ");
        result.append(nf.format(this.iZ));
        result.append(" ");
        result.append(nf.format(this.m0));
        result.append(" ");
        result.append(nf.format(this.m1));
        result.append(" ");
        result.append(nf.format(this.m2));
        result.append(" ");
        result.append(nf.format(this.m3));
        result.append(" ");
        result.append(nf.format(this.m4));
        result.append(" ");
        result.append(nf.format(this.nonParticleDiscriminationScore));
        result.append("\n");
        return result;
    }

    public boolean match(Particle aParticle) {
        return this.iX == aParticle.iX && this.iY == aParticle.iY && this.iZ == aParticle.iZ && this.m0 == aParticle.m0 && this.m1 == aParticle.m1 && this.m2 == aParticle.m2 && this.m3 == aParticle.m3 && this.m4 == aParticle.m4;
    }

    public void setFrame(int aFrameNumber) {
        this.frame = aFrameNumber;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setx(double aX) {
        this.iX = (float)aX;
    }

    public double getx() {
        return this.iX;
    }

    public void sety(double aY) {
        this.iY = (float)aY;
    }

    public double gety() {
        return this.iY;
    }

    public void setz(double aZ) {
        this.iZ = (float)aZ;
    }

    public double getz() {
        return this.iZ;
    }

    public void setSize(double aSize) {
        this.m0 = (float)aSize;
    }

    public double getSize() {
        return this.m0;
    }

    public void setm0(double aM) {
        this.m0 = (float)aM;
    }

    public double getm0() {
        return this.m0;
    }

    public void setm1(double aM) {
        this.m1 = (float)aM;
    }

    public double getm1() {
        return this.m1;
    }

    public void setm2(double aM) {
        this.m2 = (float)aM;
    }

    public double getm2() {
        return this.m2;
    }

    public void setm3(double aM) {
        this.m3 = (float)aM;
    }

    public double getm3() {
        return this.m3;
    }

    public void setm4(double aM) {
        this.m4 = (float)aM;
    }

    public double getm4() {
        return this.m4;
    }

    public void setIntensity(double aIntensity) {
        this.m2 = (float)aIntensity;
    }

    public double getIntensity() {
        return this.m2;
    }

    public void setX(double aX) {
        this.iX = (float)aX;
    }

    public double getX() {
        return this.iX;
    }

    public void setY(double aY) {
        this.iY = (float)aY;
    }

    public double getY() {
        return this.iY;
    }

    public void setZ(double aZ) {
        this.iZ = (float)aZ;
    }

    public double getZ() {
        return this.iZ;
    }
}

