/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils;

import java.util.Iterator;
import mosaic.core.imageUtils.Point;
import mosaic.utils.math.MathOps;

public class Connectivity {
    private final int iNumOfDimensions;
    private final int iConnectivity;
    private final int iNeighborhoodSize;
    protected final int iNumOfNeighbors;
    protected final Point[] iPointOffsetsNeighbors;
    protected final int[] iIndexedNeighbors;

    public Connectivity(int aNumOfDimensions, int aConnectivity) {
        this.iNumOfDimensions = aNumOfDimensions;
        this.iConnectivity = aConnectivity;
        this.iNeighborhoodSize = (int)Math.pow(3.0, aNumOfDimensions);
        this.iNumOfNeighbors = this.computeNumberOfNeighbors();
        this.iPointOffsetsNeighbors = new Point[this.iNumOfNeighbors];
        this.iIndexedNeighbors = new int[this.iNumOfNeighbors];
        this.initOffsets();
    }

    public Connectivity getComplementaryConnectivity() {
        if (this.iConnectivity == this.iNumOfDimensions - 1) {
            return new Connectivity(this.iNumOfDimensions, 0);
        }
        return new Connectivity(this.iNumOfDimensions, this.iNumOfDimensions - 1);
    }

    public Connectivity getIncreasedConnectivity() {
        int newConnectivity = this.iConnectivity == 0 ? 0 : this.iConnectivity - 1;
        return new Connectivity(this.iNumOfDimensions, newConnectivity);
    }

    public boolean isNeighbor(Point aOffset) {
        for (Point p : this.iPointOffsetsNeighbors) {
            if (!aOffset.equals(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isNeighbor(int aIndex) {
        for (int idx : this.iIndexedNeighbors) {
            if (aIndex != idx) continue;
            return true;
        }
        return false;
    }

    public Point toPoint(int aIndex) {
        int remainder = aIndex;
        int[] x = new int[this.iNumOfDimensions];
        int i = 0;
        while (i < this.iNumOfDimensions) {
            x[i] = remainder % 3;
            int n = i++;
            x[n] = x[n] - 1;
            remainder /= 3;
        }
        return new Point(x);
    }

    public int toIndex(Point aOffset) {
        int offset = 0;
        int factor = 1;
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            offset += factor * (aOffset.iCoords[i] + 1);
            factor *= 3;
        }
        return offset;
    }

    public int getNeighborhoodSize() {
        return this.iNeighborhoodSize;
    }

    public int getNumOfNeighbors() {
        return this.iNumOfNeighbors;
    }

    public int getNumOfDimensions() {
        return this.iNumOfDimensions;
    }

    public Point[] getPointOffsets() {
        return this.iPointOffsetsNeighbors;
    }

    public int[] getIndexOffsets() {
        return this.iIndexedNeighbors;
    }

    public String toString() {
        return "Connectivity (" + this.iNumOfDimensions + "D, " + this.iNumOfNeighbors + "-connectivity)";
    }

    private int computeNumberOfNeighbors() {
        int numberOfNeighbors = 0;
        for (int i = this.iConnectivity; i <= this.iNumOfDimensions - 1; ++i) {
            numberOfNeighbors += MathOps.factorial(this.iNumOfDimensions) * (1 << this.iNumOfDimensions - i) / (MathOps.factorial(this.iNumOfDimensions - i) * MathOps.factorial(i));
        }
        return numberOfNeighbors;
    }

    private void initOffsets() {
        int currentNbNeighbors = 0;
        for (int i = 0; i < this.iNeighborhoodSize; ++i) {
            Point p = this.toPoint(i);
            int numberOfZeros = p.numOfZerosInCoordinates();
            if (numberOfZeros == this.iNumOfDimensions || numberOfZeros < this.iConnectivity) continue;
            this.iPointOffsetsNeighbors[currentNbNeighbors] = p;
            this.iIndexedNeighbors[currentNbNeighbors] = i;
            ++currentNbNeighbors;
        }
    }

    public Iterable<Point> iterator() {
        return new Iterable<Point>(){

            @Override
            public Iterator<Point> iterator() {
                return new OfsIterator();
            }
        };
    }

    public Iterable<Point> iterateNeighbors(final Point p) {
        return new Iterable<Point>(){

            @Override
            public Iterator<Point> iterator() {
                return new NeighborIterator(p);
            }
        };
    }

    public Iterable<Integer> itOfsInt() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new OfsIteratorInt();
            }
        };
    }

    private class OfsIteratorInt
    implements Iterator<Integer> {
        private int cursor = 0;

        protected OfsIteratorInt() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < Connectivity.this.iNumOfNeighbors;
        }

        @Override
        public Integer next() {
            int result = Connectivity.this.iIndexedNeighbors[this.cursor];
            ++this.cursor;
            return result;
        }

        @Override
        public void remove() {
        }
    }

    private class NeighborIterator
    extends OfsIterator {
        private final Point point;

        protected NeighborIterator(Point p) {
            this.point = p;
        }

        @Override
        public Point next() {
            Point ofs = super.next();
            return this.point.add(ofs);
        }
    }

    private class OfsIterator
    implements Iterator<Point> {
        private int cursor = 0;

        protected OfsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < Connectivity.this.iNumOfNeighbors;
        }

        @Override
        public Point next() {
            return Connectivity.this.iPointOffsetsNeighbors[this.cursor++];
        }

        @Override
        public void remove() {
        }
    }
}

