/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import mosaic.core.binarize.BinarizedImage;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;

public class FloodFill
implements Iterator<Integer>,
Iterable<Integer> {
    private final Set<Integer> iFoundIndices = new HashSet<Integer>();
    private final Iterator<Integer> iIterator;

    public FloodFill(LabelImage aInputImg, BinarizedImage aAreaForProcessing, Point aPointSeed) {
        Stack<Integer> stackIdx = new Stack<Integer>();
        Integer inputIndex = aInputImg.pointToIndex(aPointSeed);
        if (aAreaForProcessing.EvaluateAtIndex(inputIndex)) {
            stackIdx.add(inputIndex);
        }
        while (!stackIdx.isEmpty()) {
            Integer idx = (Integer)stackIdx.pop();
            for (int neighbourIdx : aInputImg.iterateNeighbours(idx)) {
                if (!aAreaForProcessing.EvaluateAtIndex(neighbourIdx) || this.iFoundIndices.contains(neighbourIdx)) continue;
                stackIdx.add(neighbourIdx);
            }
            this.iFoundIndices.add(idx);
        }
        this.iIterator = this.iFoundIndices.iterator();
    }

    public int size() {
        return this.iFoundIndices.size();
    }

    @Override
    public boolean hasNext() {
        return this.iIterator.hasNext();
    }

    @Override
    public Integer next() {
        return this.iIterator.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.iIterator;
    }
}

