/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils;

import java.util.Iterator;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.core.imageUtils.masks.Mask;

public class MaskOnSpaceMapper {
    private final SpaceIterator iInputIterator;
    private final Point iMaskMidPoint;
    private final Point iMaskRightDown;
    boolean iIsSthToCrop = false;
    private final int[] iFgIndexes;
    private final Point[] iFgPoints;
    private Point iPointOffset;
    private int iIndexOffset;
    private int iFgIndex;
    private Point iNextPointWithNoOffset;
    private int iNextIndex;

    public MaskOnSpaceMapper(Mask aMask, int[] aInputDimensions) {
        this.iInputIterator = new SpaceIterator(aInputDimensions);
        this.iMaskMidPoint = new Point(aMask.getDimensions()).div(2);
        this.iMaskRightDown = new Point(aMask.getDimensions()).sub(1.0);
        this.iFgPoints = new Point[aMask.getNumOfFgPoints()];
        this.iFgIndexes = new int[aMask.getNumOfFgPoints()];
        SpaceIterator maskIterator = new SpaceIterator(aMask.getDimensions());
        Iterator<Integer> iter = maskIterator.getIndexIterator();
        int idxFG = 0;
        while (iter.hasNext()) {
            int idx = iter.next();
            if (!aMask.isInMask(idx)) continue;
            this.iFgIndexes[idxFG] = this.iInputIterator.pointToIndex(maskIterator.indexToPoint(idx));
            this.iFgPoints[idxFG++] = maskIterator.indexToPoint(idx);
        }
        this.iPointOffset = new Point((int[])aInputDimensions.clone()).zero();
        this.initIndices();
    }

    public void setMiddlePoint(Point aMiddlePoint) {
        this.iPointOffset = aMiddlePoint.sub(this.iMaskMidPoint);
        this.initIndices();
    }

    public void setUpperLeft(Point aUpperLeftPoint) {
        this.iPointOffset = aUpperLeftPoint;
        this.initIndices();
    }

    public boolean hasNext() {
        while (this.iFgIndex < this.iFgPoints.length) {
            int currIdx = this.iFgIndexes[this.iFgIndex];
            this.iNextIndex = this.iIndexOffset + currIdx;
            this.iNextPointWithNoOffset = this.iFgPoints[this.iFgIndex++];
            if (!this.iIsSthToCrop) {
                return true;
            }
            if (!this.iInputIterator.isInBound(this.iNextPointWithNoOffset.add(this.iPointOffset))) continue;
            return true;
        }
        return false;
    }

    public int next() {
        return this.iNextIndex;
    }

    public Point nextPoint() {
        return this.iNextPointWithNoOffset.add(this.iPointOffset);
    }

    private void initIndices() {
        this.iFgIndex = 0;
        this.iIndexOffset = this.iInputIterator.pointToIndex(this.iPointOffset);
        this.iIsSthToCrop = !this.iInputIterator.isInBound(this.iPointOffset) || !this.iInputIterator.isInBound(this.iPointOffset.add(this.iMaskRightDown));
    }
}

