/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils;

import java.util.Arrays;

public class Point {
    public final int[] iCoords;

    public Point(Point aPoint) {
        this.iCoords = (int[])aPoint.iCoords.clone();
    }

    public Point(int ... aCoords) {
        this.iCoords = aCoords;
    }

    public boolean isInside(int ... aMaxValues) {
        for (int i = 0; i < aMaxValues.length; ++i) {
            if (this.iCoords[i] < aMaxValues[i]) continue;
            return false;
        }
        return true;
    }

    public double distance(Point aPoint) {
        double ret = 0.0;
        for (int i = 0; i < this.iCoords.length; ++i) {
            ret += (double)((aPoint.iCoords[i] - this.iCoords[i]) * (aPoint.iCoords[i] - this.iCoords[i]));
        }
        return Math.sqrt(ret);
    }

    public double length() {
        double ret = 0.0;
        for (int i = 0; i < this.iCoords.length; ++i) {
            ret += (double)(this.iCoords[i] * this.iCoords[i]);
        }
        return Math.sqrt(ret);
    }

    public Point add(int ... aCoords) {
        Point result = new Point((int[])this.iCoords.clone());
        for (int i = 0; i < this.iCoords.length; ++i) {
            int n = i;
            result.iCoords[n] = result.iCoords[n] + aCoords[i];
        }
        return result;
    }

    public Point add(Point aPoint) {
        Point result = new Point((int[])this.iCoords.clone());
        for (int i = 0; i < this.iCoords.length; ++i) {
            int n = i;
            result.iCoords[n] = result.iCoords[n] + aPoint.iCoords[i];
        }
        return result;
    }

    public Point add(double aValue) {
        Point result = new Point((int[])this.iCoords.clone());
        int i = 0;
        while (i < this.iCoords.length) {
            int n = i++;
            result.iCoords[n] = (int)((double)result.iCoords[n] + aValue);
        }
        return result;
    }

    public Point sub(Point aPoint) {
        Point result = new Point((int[])this.iCoords.clone());
        for (int i = 0; i < this.iCoords.length; ++i) {
            int n = i;
            result.iCoords[n] = result.iCoords[n] - aPoint.iCoords[i];
        }
        return result;
    }

    public Point sub(double aValue) {
        Point result = new Point((int[])this.iCoords.clone());
        int i = 0;
        while (i < this.iCoords.length) {
            int n = i++;
            result.iCoords[n] = (int)((double)result.iCoords[n] - aValue);
        }
        return result;
    }

    public Point mult(int aValue) {
        Point result = new Point((int[])this.iCoords.clone());
        int i = 0;
        while (i < this.iCoords.length) {
            int n = i++;
            result.iCoords[n] = result.iCoords[n] * aValue;
        }
        return result;
    }

    public Point div(int aValue) {
        Point result = new Point((int[])this.iCoords.clone());
        int i = 0;
        while (i < this.iCoords.length) {
            int n = i++;
            result.iCoords[n] = result.iCoords[n] / aValue;
        }
        return result;
    }

    public Point div(float[] aScalingFactors) {
        Point result = new Point((int[])this.iCoords.clone());
        for (int i = 0; i < this.iCoords.length; ++i) {
            int n = i;
            result.iCoords[n] = (int)((float)result.iCoords[n] / aScalingFactors[i]);
        }
        return result;
    }

    public Point zero() {
        for (int i = 0; i < this.iCoords.length; ++i) {
            this.iCoords[i] = 0;
        }
        return this;
    }

    public int numOfZerosInCoordinates() {
        int count = 0;
        for (int i : this.iCoords) {
            if (i != 0) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        String result = "[";
        int i = 0;
        for (i = 0; i < this.iCoords.length - 1; ++i) {
            result = result + this.iCoords[i] + ", ";
        }
        result = result + this.iCoords[i] + "]";
        return result;
    }

    public int getNumOfDimensions() {
        return this.iCoords.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.iCoords);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return Arrays.equals(this.iCoords, other.iCoords);
    }
}

