/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.convolution;

import mosaic.core.imageUtils.convolution.Kernel1D;
import mosaic.filamentSegmentation.GaussPsf;

public class Gauss1D
extends Kernel1D {
    public Gauss1D(double aStdDev, int aKernelLen) {
        this.generateKernel(aStdDev, aKernelLen);
    }

    public Gauss1D(double aStdDev) {
        int kernelLen = (int)(6.0 * aStdDev);
        if (kernelLen % 2 == 0) {
            ++kernelLen;
        }
        this.generateKernel(aStdDev, kernelLen);
    }

    private void generateKernel(double aSigma, int aKernelLen) {
        this.k = GaussPsf.generateKernel(aKernelLen, 1, aSigma)[0];
        this.iHalfWidth = aKernelLen / 2;
    }
}

