/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.iterators;

import java.util.Iterator;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;

public abstract class BaseIterator {
    protected final int iNumOfDimensions;
    SpaceIterator iIntersectionIt;
    Iterator<Point> iIntersectionPointIt;
    protected Point iLastPoint = null;
    protected Point iOffsetPoint = null;

    public BaseIterator(int[] iInputDims, int[] iRegionDims, int[] iRegionOffset) {
        this.iNumOfDimensions = iInputDims.length;
        if (iRegionDims.length != this.iNumOfDimensions || iRegionOffset.length != this.iNumOfDimensions) {
            throw new RuntimeException("dimensions not matching in region iterator");
        }
        int[] dimensionsOfIntersection = new int[this.iNumOfDimensions];
        int[] offsetPoint = new int[this.iNumOfDimensions];
        for (int d = 0; d < this.iNumOfDimensions; ++d) {
            int begin = iRegionOffset[d] < 0 ? 0 : iRegionOffset[d];
            int end = iRegionOffset[d] + iRegionDims[d] > iInputDims[d] ? iInputDims[d] : iRegionOffset[d] + iRegionDims[d];
            dimensionsOfIntersection[d] = end - begin;
            offsetPoint[d] = begin;
        }
        this.iOffsetPoint = new Point(offsetPoint);
        this.iIntersectionIt = new SpaceIterator(dimensionsOfIntersection);
        this.iIntersectionPointIt = this.iIntersectionIt.getPointIterator();
    }

    public abstract int next();

    public boolean hasNext() {
        return this.iIntersectionPointIt.hasNext();
    }

    public int getSize() {
        return this.iIntersectionIt.getSize();
    }

    public Point getPoint() {
        return this.iLastPoint;
    }
}

