/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.iterators;

import java.util.Iterator;
import mosaic.core.imageUtils.Point;

public class SpaceIterator {
    private final int[] iDimensions;
    private final int iNumOfDimensions;
    protected final int iSize;

    public SpaceIterator(int ... aDimensions) {
        this.iDimensions = (int[])aDimensions.clone();
        this.iNumOfDimensions = this.iDimensions.length;
        int tempSize = 1;
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            tempSize *= this.iDimensions[i];
        }
        this.iSize = tempSize;
    }

    public int getSize() {
        return this.iSize;
    }

    public int pointToIndex(Point aPoint) {
        int idx = 0;
        int fac = 1;
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            idx += fac * aPoint.iCoords[i];
            fac *= this.iDimensions[i];
        }
        return idx;
    }

    public Point indexToPoint(int aIndex) {
        int[] x = new int[this.iNumOfDimensions];
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            x[i] = aIndex % this.iDimensions[i];
            aIndex /= this.iDimensions[i];
        }
        return new Point(x);
    }

    public boolean isInBound(Point aPoint) {
        for (int d = 0; d < this.iNumOfDimensions; ++d) {
            if (aPoint.iCoords[d] >= 0 && aPoint.iCoords[d] < this.iDimensions[d]) continue;
            return false;
        }
        return true;
    }

    public boolean isInBound(int aIndex) {
        return aIndex >= 0 && aIndex < this.getSize();
    }

    public int getNumOfDimensions() {
        return this.iNumOfDimensions;
    }

    public int[] getDimensions() {
        return this.iDimensions;
    }

    public Iterator<Point> getPointIterator() {
        return new Iterator<Point>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SpaceIterator.this.iSize;
            }

            @Override
            public Point next() {
                return SpaceIterator.this.indexToPoint(this.i++);
            }

            @Override
            public void remove() {
            }
        };
    }

    public Iterable<Point> getPointIterable() {
        return new Iterable<Point>(){

            @Override
            public Iterator<Point> iterator() {
                return SpaceIterator.this.getPointIterator();
            }
        };
    }

    public Iterator<Integer> getIndexIterator() {
        return new Iterator<Integer>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SpaceIterator.this.iSize;
            }

            @Override
            public Integer next() {
                return this.i++;
            }

            @Override
            public void remove() {
            }
        };
    }

    public Iterable<Integer> getIndexIterable() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return SpaceIterator.this.getIndexIterator();
            }
        };
    }

    public String toString() {
        String str = "[";
        for (int d = 0; d < this.iNumOfDimensions - 1; ++d) {
            str = str + this.iDimensions[d] + ", ";
        }
        str = str + this.iDimensions[this.iNumOfDimensions - 1] + "]";
        str = str + " size=" + this.iSize;
        return str;
    }
}

